/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.script;

import java.io.File;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.alert.api.AlertResult;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.plugin.alert.script.ProcessUtils;
import org.apache.dolphinscheduler.plugin.alert.script.ScriptType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScriptSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScriptSender.class);
    private static final String ALERT_TITLE_OPTION = " -t ";
    private static final String ALERT_CONTENT_OPTION = " -c ";
    private static final String ALERT_USER_PARAMS_OPTION = " -p ";
    private final String scriptPath;
    private final String scriptType;
    private final String userParams;

    ScriptSender(Map<String, String> config) {
        this.scriptPath = StringUtils.isNotBlank((CharSequence)config.get("path")) ? config.get("path") : "";
        this.scriptType = StringUtils.isNotBlank((CharSequence)config.get("type")) ? config.get("type") : "";
        this.userParams = StringUtils.isNotBlank((CharSequence)config.get("userParams")) ? config.get("userParams") : "";
    }

    AlertResult sendScriptAlert(String title, String content) {
        AlertResult alertResult = new AlertResult();
        if (ScriptType.SHELL.getDescp().equals(this.scriptType)) {
            return this.executeShellScript(title, content);
        }
        alertResult.setSuccess(false);
        log.error("script type error: {}", (Object)this.scriptType);
        alertResult.setMessage("script type error : " + this.scriptType);
        return alertResult;
    }

    private AlertResult executeShellScript(String title, String content) {
        AlertResult alertResult = new AlertResult();
        alertResult.setSuccess(false);
        if (Boolean.TRUE.equals(OSUtils.isWindows())) {
            alertResult.setMessage("shell script not support windows os");
            return alertResult;
        }
        if (!this.scriptPath.endsWith(".sh")) {
            alertResult.setMessage("shell script is invalid, only support .sh file");
            return alertResult;
        }
        File shellScriptFile = new File(this.scriptPath);
        if (!shellScriptFile.exists()) {
            log.error("shell script not exist : {}", (Object)this.scriptPath);
            alertResult.setMessage("shell script not exist : " + this.scriptPath);
            return alertResult;
        }
        if (!shellScriptFile.isFile()) {
            log.error("shell script is not a file : {}", (Object)this.scriptPath);
            alertResult.setMessage("shell script is not a file : " + this.scriptPath);
            return alertResult;
        }
        if (this.userParams.contains("'")) {
            log.error("shell script illegal user params : {}", (Object)this.userParams);
            alertResult.setMessage("shell script illegal user params : " + this.userParams);
            return alertResult;
        }
        if (title.contains("'")) {
            log.error("shell script illegal title : {}", (Object)title);
            alertResult.setMessage("shell script illegal title : " + title);
            return alertResult;
        }
        if (content.contains("'")) {
            log.error("shell script illegal content : {}", (Object)content);
            alertResult.setMessage("shell script illegal content : " + content);
            return alertResult;
        }
        String[] cmd = new String[]{"/bin/sh", "-c", this.scriptPath + ALERT_TITLE_OPTION + "'" + title + "'" + ALERT_CONTENT_OPTION + "'" + content + "'" + ALERT_USER_PARAMS_OPTION + "'" + this.userParams + "'"};
        int exitCode = ProcessUtils.executeScript(cmd);
        if (exitCode == 0) {
            alertResult.setSuccess(true);
            alertResult.setMessage("send script alert msg success");
            return alertResult;
        }
        alertResult.setMessage("send script alert msg error,exitCode is " + exitCode);
        log.info("send script alert msg error,exitCode is {}", (Object)exitCode);
        return alertResult;
    }
}

