/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.prometheus;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.dolphinscheduler.alert.api.AlertData;
import org.apache.dolphinscheduler.alert.api.AlertResult;
import org.apache.dolphinscheduler.alert.api.HttpServiceRetryStrategy;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusAlertSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrometheusAlertSender.class);
    private String url;
    private String generatorURL;
    private String annotations;

    public PrometheusAlertSender(Map<String, String> config) {
        this.url = config.get("url");
        this.generatorURL = config.get("generatorURL");
        this.annotations = config.get("annotations");
    }

    public AlertResult sendMessage(AlertData alertData) {
        try {
            String resp = this.sendMsg(alertData);
            return this.checkSendAlertManageMsgResult(resp);
        }
        catch (Exception e) {
            log.error("Send prometheus alert manager alert error", (Throwable)e);
            AlertResult alertResult = new AlertResult();
            alertResult.setSuccess(false);
            alertResult.setMessage(ExceptionUtils.getMessage((Throwable)e));
            return alertResult;
        }
    }

    /*
     * Exception decompiling
     */
    private String sendMsg(AlertData alertData) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public AlertResult checkSendAlertManageMsgResult(String resp) {
        AlertResult alertResult = new AlertResult();
        alertResult.setSuccess(false);
        if (Objects.equals(resp, "alert success")) {
            alertResult.setSuccess(true);
            alertResult.setMessage("prometheus alert manager send success");
            return alertResult;
        }
        alertResult.setMessage(String.format("prometheus alert manager send fail, resp is %s", resp));
        log.info("send prometheus alert manager msg error, resp error");
        return alertResult;
    }

    public String generateContentJson(AlertData alertData) {
        List list = JSONUtils.toList((String)alertData.getContent(), HashMap.class);
        HashMap<String, String> labels = new HashMap<String, String>();
        if (CollectionUtils.isEmpty((Collection)list)) {
            labels.put("content", alertData.getContent());
        }
        for (Map map : list) {
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                String value = entry.getValue().toString();
                labels.put(key, value);
            }
        }
        labels.put("title", alertData.getTitle());
        HashMap<String, Object> alert = new HashMap<String, Object>();
        alert.put("labels", labels);
        Map annotations = JSONUtils.toMap((String)this.annotations);
        if (annotations != null) {
            alert.put("annotations", annotations);
        }
        String formattedTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").format(new Date());
        alert.put("startsAt", formattedTime);
        alert.put("endsAt", formattedTime);
        if (this.generatorURL != null && this.generatorURL.length() != 0) {
            alert.put("generatorURL", this.generatorURL);
        }
        ArrayList<HashMap<String, Object>> arrayList = new ArrayList<HashMap<String, Object>>();
        arrayList.add(alert);
        return JSONUtils.toJsonString(arrayList);
    }

    private static CloseableHttpClient getDefaultClient() {
        return HttpClients.custom().setRetryHandler((HttpRequestRetryHandler)HttpServiceRetryStrategy.retryStrategy).build();
    }

    private static HttpPost constructHttpPost(String url, String msg) {
        HttpPost post = new HttpPost(url);
        StringEntity entity = new StringEntity(msg, ContentType.APPLICATION_JSON);
        post.setEntity((HttpEntity)entity);
        return post;
    }
}

