/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.http;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.alert.api.AlertResult;
import org.apache.dolphinscheduler.common.model.OkHttpRequestHeaderContentType;
import org.apache.dolphinscheduler.common.model.OkHttpRequestHeaders;
import org.apache.dolphinscheduler.common.model.OkHttpResponse;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.OkHttpUtils;
import org.apache.dolphinscheduler.plugin.alert.http.HttpRequestMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpSender.class);
    private Map<String, String> headerParams;
    private OkHttpRequestHeaderContentType contentType;
    private Map<String, String> bodyParams;
    private HttpRequestMethod requestType;
    private int timeout;
    private String url;

    public HttpSender(Map<String, String> paramsMap) {
        this.paramsValidator(paramsMap);
    }

    private void paramsValidator(Map<String, String> paramsMap) {
        String bodyParamsString;
        this.url = paramsMap.get("url");
        if (StringUtils.isBlank((CharSequence)this.url)) {
            throw new IllegalArgumentException("url can not be null");
        }
        String headerParamsString = paramsMap.get("headerParams");
        if (StringUtils.isNotBlank((CharSequence)headerParamsString)) {
            this.headerParams = JSONUtils.toMap((String)headerParamsString);
            if (this.headerParams == null) {
                throw new IllegalArgumentException("headerParams is not a valid json");
            }
        } else {
            this.headerParams = new HashMap<String, String>();
        }
        if (StringUtils.isNotBlank((CharSequence)(bodyParamsString = paramsMap.get("bodyParams")))) {
            this.bodyParams = JSONUtils.toMap((String)bodyParamsString);
            if (this.bodyParams == null) {
                throw new IllegalArgumentException("bodyParams is not a valid json");
            }
        } else {
            this.bodyParams = new HashMap<String, String>();
        }
        try {
            this.requestType = HttpRequestMethod.valueOf(paramsMap.get("requestType"));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("requestType is not a valid value");
        }
        this.contentType = OkHttpRequestHeaderContentType.fromValue((String)paramsMap.get("contentType"));
        if (this.contentType == null) {
            throw new IllegalArgumentException("contentType is not a valid value");
        }
        this.timeout = StringUtils.isNotBlank((CharSequence)paramsMap.get("timeout")) ? Integer.parseInt(paramsMap.get("timeout")) : 120000;
    }

    public AlertResult send(String msg) {
        OkHttpResponse okHttpResponse;
        AlertResult alertResult = new AlertResult();
        try {
            okHttpResponse = this.sendHttpRequest(msg);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
        this.validateResponse(okHttpResponse, alertResult);
        return alertResult;
    }

    private void validateResponse(OkHttpResponse okHttpResponse, AlertResult alertResult) {
        if (okHttpResponse.getStatusCode() != 200) {
            alertResult.setSuccess(false);
            alertResult.setMessage(String.format("send http alert failed, response body: %s", okHttpResponse.getBody()));
        } else {
            alertResult.setSuccess(true);
            alertResult.setMessage(String.format("send http alert success, response body: %s", okHttpResponse.getBody()));
        }
    }

    private OkHttpResponse sendHttpRequest(String msg) throws RuntimeException {
        switch (this.requestType) {
            case POST: {
                this.setMsgInHeader(msg);
                this.setMsgInRequestBody(msg);
                return this.sendPostRequest();
            }
            case GET: {
                this.setMsgInUrl(msg);
                this.setMsgInHeader(msg);
                return this.sendGetRequest();
            }
            case PUT: {
                this.setMsgInHeader(msg);
                this.setMsgInRequestBody(msg);
                return this.sendPutRequest();
            }
        }
        throw new RuntimeException(String.format("http request method %s not supported", new Object[]{this.requestType}));
    }

    private OkHttpResponse sendGetRequest() {
        OkHttpRequestHeaders okHttpRequestHeaders = new OkHttpRequestHeaders();
        okHttpRequestHeaders.setHeaders(this.headerParams);
        okHttpRequestHeaders.setOkHttpRequestHeaderContentType(this.contentType);
        HashMap requestParams = new HashMap();
        log.info("sending http alert get request, url: {}, header: {}, requestParams: {}, contentType: {}", new Object[]{this.url, this.headerParams, requestParams, this.contentType.getValue()});
        return OkHttpUtils.get((String)this.url, (OkHttpRequestHeaders)okHttpRequestHeaders, requestParams, (int)this.timeout, (int)this.timeout, (int)this.timeout);
    }

    private OkHttpResponse sendPostRequest() {
        OkHttpRequestHeaders okHttpRequestHeaders = new OkHttpRequestHeaders();
        okHttpRequestHeaders.setHeaders(this.headerParams);
        okHttpRequestHeaders.setOkHttpRequestHeaderContentType(this.contentType);
        Map<String, String> requestBody = Collections.unmodifiableMap(this.bodyParams);
        log.info("sending http alert post request, url: {}, header: {}, requestBody: {}, contentType: {}", new Object[]{this.url, this.headerParams, requestBody, this.contentType.getValue()});
        return OkHttpUtils.post((String)this.url, (OkHttpRequestHeaders)okHttpRequestHeaders, null, requestBody, (int)this.timeout, (int)this.timeout, (int)this.timeout);
    }

    private OkHttpResponse sendPutRequest() {
        OkHttpRequestHeaders okHttpRequestHeaders = new OkHttpRequestHeaders();
        okHttpRequestHeaders.setHeaders(this.headerParams);
        okHttpRequestHeaders.setOkHttpRequestHeaderContentType(this.contentType);
        Map<String, String> requestBody = Collections.unmodifiableMap(this.bodyParams);
        log.info("sending http alert put request, url: {}, header: {}, requestBody: {}, contentType: {}", new Object[]{this.url, this.headerParams, requestBody, this.contentType.getValue()});
        return OkHttpUtils.put((String)this.url, (OkHttpRequestHeaders)okHttpRequestHeaders, requestBody, (int)this.timeout, (int)this.timeout, (int)this.timeout);
    }

    private void setMsgInUrl(String msg) {
        if (this.url.contains("${msg}")) {
            try {
                this.url = this.url.replace("${msg}", URLEncoder.encode(msg, StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void setMsgInHeader(String msg) {
        if (msg == null) {
            return;
        }
        this.headerParams.forEach((key, value) -> {
            if (value.contains("${msg}")) {
                this.headerParams.put((String)key, value.replace("${msg}", msg));
            }
        });
    }

    private void setMsgInRequestBody(String msg) {
        if (this.bodyParams == null) {
            return;
        }
        this.bodyParams.forEach((key, value) -> {
            if (value.contains("${msg}")) {
                this.bodyParams.put((String)key, value.replace("${msg}", msg));
            }
        });
    }
}

