/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.feishu;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.alert.api.AlertData;
import org.apache.dolphinscheduler.alert.api.AlertResult;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.alert.feishu.HttpRequestUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FeiShuSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FeiShuSender.class);
    private final String url;
    private final Boolean enableProxy;
    private String proxy;
    private Integer port;
    private String user;
    private String password;

    FeiShuSender(Map<String, String> config) {
        this.url = config.get("WebHook");
        this.enableProxy = Boolean.valueOf(config.get("IsEnableProxy"));
        if (Boolean.TRUE.equals(this.enableProxy)) {
            this.port = Integer.parseInt(config.get("Port"));
            this.proxy = config.get("Proxy");
            this.user = config.get("User");
            this.password = config.get("Password");
        }
    }

    private static String textToJsonString(AlertData alertData) {
        HashMap<String, Object> items = new HashMap<String, Object>(2);
        items.put("msg_type", "text");
        HashMap<String, String> textContent = new HashMap<String, String>();
        byte[] byt = StringUtils.getBytesUtf8((String)FeiShuSender.formatContent(alertData));
        String txt = StringUtils.newStringUtf8((byte[])byt);
        textContent.put("text", txt);
        items.put("content", textContent);
        return JSONUtils.toJsonString(items);
    }

    public static AlertResult checkSendFeiShuSendMsgResult(String result) {
        AlertResult alertResult = new AlertResult();
        alertResult.setSuccess(false);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)result)) {
            alertResult.setMessage("send feishu msg error: feishu server resp is blank.");
            log.info("send feishu msg error: feishu server resp is blank.");
            return alertResult;
        }
        FeiShuSendMsgResponse sendMsgResponse = (FeiShuSendMsgResponse)JSONUtils.parseObject((String)result, FeiShuSendMsgResponse.class);
        if (null == sendMsgResponse) {
            alertResult.setMessage("send feishu msg error: feishu server resp parse error is null.");
            log.info("send feishu msg error: feishu server resp parse error is null.");
            return alertResult;
        }
        if (sendMsgResponse.code == 0) {
            alertResult.setSuccess(true);
            alertResult.setMessage("send feishu msg success.");
            return alertResult;
        }
        alertResult.setMessage(String.format("alert send feishu msg error: %s", sendMsgResponse.getMsg()));
        log.info("alert send feishu msg error: {}", (Object)sendMsgResponse);
        return alertResult;
    }

    public static String formatContent(AlertData alertData) {
        if (alertData.getContent() != null) {
            List list = JSONUtils.toList((String)alertData.getContent(), Map.class);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return alertData.getTitle() + alertData.getContent();
            }
            StringBuilder contents = new StringBuilder(100);
            contents.append(String.format("`%s`%n", alertData.getTitle()));
            for (Map map : list) {
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = entry.getValue().toString();
                    contents.append(key + ":" + value);
                    contents.append("\n");
                }
            }
            return contents.toString();
        }
        return null;
    }

    public AlertResult sendFeiShuMsg(AlertData alertData) {
        try {
            String resp = this.sendMsg(alertData);
            return FeiShuSender.checkSendFeiShuSendMsgResult(resp);
        }
        catch (Exception e) {
            log.error("send feishu alert failed:", (Throwable)e);
            AlertResult alertResult = new AlertResult();
            alertResult.setSuccess(false);
            alertResult.setMessage("send feishu alert fail.");
            return alertResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendMsg(AlertData alertData) throws IOException {
        String msgToJson = FeiShuSender.textToJsonString(alertData);
        HttpPost httpPost = HttpRequestUtil.constructHttpPost(this.url, msgToJson);
        try (CloseableHttpClient httpClient = HttpRequestUtil.getHttpClient(this.enableProxy, this.proxy, this.port, this.user, this.password);){
            String resp;
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                log.error("send feishu message error, return http status code: {} ", (Object)statusCode);
            }
            try {
                HttpEntity entity = response.getEntity();
                resp = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                EntityUtils.consume((HttpEntity)entity);
            }
            finally {
                response.close();
            }
            log.info("feishu send title: {}, content: {}, resp: {}", new Object[]{alertData.getTitle(), alertData.getContent(), resp});
            String string = resp;
            return string;
        }
    }

    static final class FeiShuSendMsgResponse {
        @JsonProperty(value="data")
        private Object data;
        @JsonProperty(value="code")
        private Integer code;
        @JsonProperty(value="msg")
        private String msg;

        @Generated
        public static FeiShuSendMsgResponseBuilder builder() {
            return new FeiShuSendMsgResponseBuilder();
        }

        @Generated
        public FeiShuSendMsgResponse(Object data, Integer code, String msg) {
            this.data = data;
            this.code = code;
            this.msg = msg;
        }

        @Generated
        public Object getData() {
            return this.data;
        }

        @Generated
        public Integer getCode() {
            return this.code;
        }

        @Generated
        public String getMsg() {
            return this.msg;
        }

        @JsonProperty(value="data")
        @Generated
        public void setData(Object data) {
            this.data = data;
        }

        @JsonProperty(value="code")
        @Generated
        public void setCode(Integer code) {
            this.code = code;
        }

        @JsonProperty(value="msg")
        @Generated
        public void setMsg(String msg) {
            this.msg = msg;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FeiShuSendMsgResponse)) {
                return false;
            }
            FeiShuSendMsgResponse other = (FeiShuSendMsgResponse)o;
            Integer this$code = this.getCode();
            Integer other$code = other.getCode();
            if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
                return false;
            }
            Object this$data = this.getData();
            Object other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            String this$msg = this.getMsg();
            String other$msg = other.getMsg();
            return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
            Object $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            String $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FeiShuSender.FeiShuSendMsgResponse(data=" + this.getData() + ", code=" + this.getCode() + ", msg=" + this.getMsg() + ")";
        }

        @Generated
        public FeiShuSendMsgResponse() {
        }

        @Generated
        public static class FeiShuSendMsgResponseBuilder {
            @Generated
            private Object data;
            @Generated
            private Integer code;
            @Generated
            private String msg;

            @Generated
            FeiShuSendMsgResponseBuilder() {
            }

            @JsonProperty(value="data")
            @Generated
            public FeiShuSendMsgResponseBuilder data(Object data) {
                this.data = data;
                return this;
            }

            @JsonProperty(value="code")
            @Generated
            public FeiShuSendMsgResponseBuilder code(Integer code) {
                this.code = code;
                return this;
            }

            @JsonProperty(value="msg")
            @Generated
            public FeiShuSendMsgResponseBuilder msg(String msg) {
                this.msg = msg;
                return this;
            }

            @Generated
            public FeiShuSendMsgResponse build() {
                return new FeiShuSendMsgResponse(this.data, this.code, this.msg);
            }

            @Generated
            public String toString() {
                return "FeiShuSender.FeiShuSendMsgResponse.FeiShuSendMsgResponseBuilder(data=" + this.data + ", code=" + this.code + ", msg=" + this.msg + ")";
            }
        }
    }
}

