/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.feishu;

import com.google.auto.service.AutoService;
import java.util.Arrays;
import java.util.List;
import org.apache.dolphinscheduler.alert.api.AlertChannel;
import org.apache.dolphinscheduler.alert.api.AlertChannelFactory;
import org.apache.dolphinscheduler.alert.api.AlertInputTips;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.alert.feishu.FeiShuAlertChannel;
import org.apache.dolphinscheduler.spi.params.base.DataType;
import org.apache.dolphinscheduler.spi.params.base.ParamsOptions;
import org.apache.dolphinscheduler.spi.params.base.PluginParams;
import org.apache.dolphinscheduler.spi.params.base.Validate;
import org.apache.dolphinscheduler.spi.params.input.InputParam;
import org.apache.dolphinscheduler.spi.params.input.number.InputNumberParam;
import org.apache.dolphinscheduler.spi.params.radio.RadioParam;

@AutoService(value={AlertChannelFactory.class})
public final class FeiShuAlertChannelFactory
implements AlertChannelFactory {
    public String name() {
        return "Feishu";
    }

    public List<PluginParams> params() {
        InputParam webHookParam = InputParam.newBuilder((String)"WebHook", (String)"$t('webhook')").addValidate(Validate.newBuilder().setRequired(true).build()).build();
        RadioParam isEnableProxy = RadioParam.newBuilder((String)"IsEnableProxy", (String)"$t('isEnableProxy')").addParamsOptions(new ParamsOptions("YES", (Object)"true", false)).addParamsOptions(new ParamsOptions("NO", (Object)"false", false)).setValue((Object)"true").addValidate(Validate.newBuilder().setRequired(false).build()).build();
        InputParam proxyParam = InputParam.newBuilder((String)"Proxy", (String)"$t('proxy')").addValidate(Validate.newBuilder().setRequired(false).build()).build();
        InputNumberParam portParam = InputNumberParam.newBuilder((String)"Port", (String)"$t('port')").addValidate(Validate.newBuilder().setRequired(false).setType(DataType.NUMBER.getDataType()).build()).build();
        InputParam userParam = InputParam.newBuilder((String)"User", (String)"$t('user')").addValidate(Validate.newBuilder().setRequired(false).build()).build();
        InputParam passwordParam = InputParam.newBuilder((String)"Password", (String)"$t('password')").setPlaceholder(JSONUtils.toJsonString((Object)AlertInputTips.getAllMsg((AlertInputTips)AlertInputTips.PASSWORD))).setType("password").build();
        return Arrays.asList(webHookParam, isEnableProxy, proxyParam, portParam, userParam, passwordParam);
    }

    public AlertChannel create() {
        return new FeiShuAlertChannel();
    }
}

