/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.email;

import java.util.Map;
import lombok.Generated;
import org.apache.dolphinscheduler.alert.api.AlertChannel;
import org.apache.dolphinscheduler.alert.api.AlertData;
import org.apache.dolphinscheduler.alert.api.AlertInfo;
import org.apache.dolphinscheduler.alert.api.AlertResult;
import org.apache.dolphinscheduler.plugin.alert.email.MailSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EmailAlertChannel
implements AlertChannel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmailAlertChannel.class);

    public AlertResult process(AlertInfo info) {
        AlertData alert = info.getAlertData();
        Map paramsMap = info.getAlertParams();
        if (null == paramsMap) {
            return new AlertResult(false, "mail params is null");
        }
        MailSender mailSender = new MailSender(paramsMap);
        AlertResult alertResult = mailSender.sendMails(alert.getTitle(), alert.getContent());
        if (alertResult == null) {
            alertResult = new AlertResult();
            alertResult.setSuccess(false);
            alertResult.setMessage("alert send error.");
            log.info("alert send error : {}", (Object)alertResult.getMessage());
            return alertResult;
        }
        if (alertResult.isSuccess()) {
            log.info("alert send success");
            alertResult.setMessage("email send success.");
        } else {
            alertResult.setMessage("alert send error.");
            log.info("alert send error : {}", (Object)alertResult.getMessage());
        }
        return alertResult;
    }
}

