/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.maven.plugins;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.directory.studio.maven.plugins.AbstractStudioMojo;
import org.apache.directory.studio.maven.plugins.ArtifactItem;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.osgi.DefaultMaven2OsgiConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudioReplaceFileInJarMojo
extends AbstractStudioMojo {
    protected ArrayList<ArtifactItem> artifactItems;
    private File inputFile;
    private File outputDirectory;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    private String pluginWorkDir;

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public void execute() throws MojoExecutionException {
        DefaultMaven2OsgiConverter maven2OsgiConverter = new DefaultMaven2OsgiConverter();
        this.completeArtifactItems(this.artifactItems, false);
        for (ArtifactItem item : this.artifactItems) {
            try {
                File zipFile = new File(this.outputDirectory.getAbsoluteFile() + File.separator + maven2OsgiConverter.getBundleFileName(item.getArtifact()));
                File tmpDir = new File(this.pluginWorkDir + item.getArtifact().getArtifactId());
                this.unpackToLocation(tmpDir, zipFile);
                this.getLog().info((CharSequence)("Adding " + this.inputFile + " to\n              " + zipFile));
                FileUtils.copyFileToDirectory((File)this.inputFile, (File)tmpDir);
                this.packFromLocation(tmpDir, zipFile);
            }
            catch (Exception e) {
                throw new MojoExecutionException("", e);
            }
        }
    }

    public void setArtifactItems(ArrayList<ArtifactItem> artifactItems) {
        this.artifactItems = artifactItems;
    }
}

