/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.maven.plugins;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.directory.studio.maven.plugins.AbstractStudioMojo;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudioPrepareJarPackageMojo
extends AbstractStudioMojo {
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    private File classesOutDir;

    public void execute() throws MojoExecutionException {
        try {
            List<Artifact> artifactList = this.createArtifactList();
            this.copyArtifacts(artifactList);
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }

    private void copyArtifacts(List<Artifact> list) throws IOException {
        if (!list.isEmpty()) {
            File copyDir = new File(this.classesOutDir, this.libraryPath);
            if (!copyDir.exists() && !copyDir.mkdirs()) {
                throw new IOException("Failed to create directory " + copyDir);
            }
            for (Artifact artifact : list) {
                File destFile = new File(copyDir, artifact.getFile().getName());
                FileUtils.copyFile((File)artifact.getFile(), (File)destFile);
                this.getLog().info((CharSequence)("Copying " + artifact.getFile() + " to\n               " + destFile));
            }
        }
    }
}

