/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.directory.studio.maven.plugins.AbstractStudioMojo;
import org.apache.directory.studio.maven.plugins.ArtifactItem;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.osgi.DefaultMaven2OsgiConverter;
import org.apache.maven.shared.osgi.Maven2OsgiConverter;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudioCopyEclipseDependencyMojo
extends AbstractStudioMojo {
    private static final String SOURCE = "source";
    private static final String SOURCES = "sources";
    protected boolean includeSources;
    protected boolean relaxed;
    protected ArrayList<ArtifactItem> artifactItems;
    private File outputDirectory;

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void execute() throws MojoExecutionException {
        DefaultMaven2OsgiConverter maven2OsgiConverter = new DefaultMaven2OsgiConverter();
        this.executeForMainArtifacts((Maven2OsgiConverter)maven2OsgiConverter);
        if (this.includeSources) {
            this.executeForSourceArtifacts((Maven2OsgiConverter)maven2OsgiConverter);
        }
    }

    private void executeForMainArtifacts(Maven2OsgiConverter maven2OsgiConverter) throws MojoExecutionException {
        this.completeArtifactItems(this.artifactItems, false);
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new MojoExecutionException("Can't create directory " + this.outputDirectory);
        }
        for (ArtifactItem item : this.artifactItems) {
            File destFile = new File(this.outputDirectory.getAbsoluteFile() + File.separator + maven2OsgiConverter.getBundleFileName(item.getArtifact()));
            this.getLog().info((CharSequence)("Copying artifact " + item.getArtifactId() + " to\n               " + destFile.getAbsolutePath()));
            try {
                FileUtils.copyFile((File)item.getArtifact().getFile(), (File)destFile);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Can't copy file.", (Exception)ioe);
            }
        }
    }

    private void executeForSourceArtifacts(Maven2OsgiConverter maven2OsgiConverter) throws MojoExecutionException {
        List<ArtifactItem> sourceArtifactItems = this.getCopyArtifactList();
        this.completeArtifactItems(sourceArtifactItems, this.relaxed);
        for (ArtifactItem item : sourceArtifactItems) {
            if (item.getArtifact() == null || !maven2OsgiConverter.getBundleSymbolicName(item.getArtifact()).endsWith(SOURCE)) continue;
            File destFile = new File(this.outputDirectory.getAbsoluteFile() + File.separator + maven2OsgiConverter.getBundleFileName(item.getArtifact()));
            this.getLog().info((CharSequence)("Copying source artifact " + item.getArtifactId() + " to\n               " + destFile.getAbsolutePath()));
            try {
                FileUtils.copyFile((File)item.getArtifact().getFile(), (File)destFile);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Can't copy file.", (Exception)ioe);
            }
        }
    }

    private List<ArtifactItem> getCopyArtifactList() {
        ArrayList<ArtifactItem> sourceArtifactItems = new ArrayList<ArtifactItem>();
        for (ArtifactItem artifactItem : this.artifactItems) {
            if (!StringUtils.isEmpty((String)artifactItem.getClassifier()) && SOURCES.equals(artifactItem.getClassifier())) continue;
            ArtifactItem sourceItem = new ArtifactItem();
            sourceItem.setGroupId(artifactItem.getGroupId());
            sourceItem.setArtifactId(artifactItem.getArtifactId());
            sourceItem.setType(artifactItem.getType());
            sourceItem.setClassifier(SOURCES);
            sourceItem.setVersion(artifactItem.getVersion());
            sourceArtifactItems.add(sourceItem);
        }
        return sourceArtifactItems;
    }

    public void setArtifactItems(ArrayList<ArtifactItem> artifactItems) {
        this.artifactItems = artifactItems;
    }
}

