/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.studio.maven.plugins.ArtifactItem;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.exec.DefaultCommandLineFactory;
import org.apache.maven.shared.release.exec.ForkedMavenExecutor;
import org.apache.maven.shared.release.exec.MavenExecutorException;
import org.apache.maven.shared.release.exec.TeeOutputStream;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStudioMojo
extends AbstractMojo {
    protected ArchiverManager archiverManager;
    protected String buildDirectory;
    protected ArtifactFactory factory;
    protected ArtifactResolver resolver;
    protected String libraryPath;
    protected ArtifactCollector artifactCollector;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected ArtifactRepository local;
    protected List<ArtifactRepository> remoteRepos;
    protected MavenProject project;
    protected MavenSession session;

    protected void unpackToLocation(File location, File file) throws Exception {
        try {
            this.getLog().info((CharSequence)("Unpacking " + file + " to\n                 " + location));
            if (!location.exists() && !location.mkdirs()) {
                throw new IOException("Failed to create directory " + location);
            }
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(file);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Unknown archiver type", (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error unpacking file: " + file + " to: " + location + "\r\n" + e.toString(), (Exception)((Object)e));
        }
    }

    protected void packFromLocation(File location, File file) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("Packing " + location + " to\n               " + file));
            Archiver archiver = this.archiverManager.getArchiver(file);
            archiver.setDestFile(file);
            archiver.setIncludeEmptyDirs(true);
            archiver.addDirectory(location);
            archiver.createArchive();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Unknown archiver type", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating archive", (Exception)e);
        }
        catch (ArchiverException e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error packing file: " + file + " to: " + location + "\r\n" + e.toString(), (Exception)((Object)e));
        }
    }

    protected int forkMvnGoal(String goal, List<String> activeProfileIds, List<String> inactiveProfileIds) throws MavenExecutorException, CommandLineException {
        DefaultCommandLineFactory commandLineFactory = new DefaultCommandLineFactory();
        Commandline cl = commandLineFactory.createCommandLine("mvn");
        cl.setWorkingDirectory(this.project.getBasedir().getAbsolutePath());
        cl.addEnvironment("MAVEN_TERMINATE_CMD", "on");
        cl.createArg().setValue(goal);
        cl.createArg().setValue("--no-plugin-updates");
        cl.createArg().setValue("--batch-mode");
        if (activeProfileIds != null && activeProfileIds.size() > 0 || inactiveProfileIds != null && inactiveProfileIds.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("-P");
            if (activeProfileIds != null && activeProfileIds.size() > 0) {
                for (String activeProfileId : activeProfileIds) {
                    sb.append(activeProfileId);
                    sb.append(',');
                }
            }
            if (inactiveProfileIds != null && inactiveProfileIds.size() > 0) {
                for (String inactiveProfileId : inactiveProfileIds) {
                    sb.append('-');
                    sb.append(inactiveProfileId);
                    sb.append(',');
                }
            }
            sb.deleteCharAt(sb.length() - 1);
            cl.createArg().setValue(sb.toString());
        }
        TeeOutputStream stdOut = new TeeOutputStream((OutputStream)System.out);
        TeeOutputStream stdErr = new TeeOutputStream((OutputStream)System.err);
        return ForkedMavenExecutor.executeCommandLine((Commandline)cl, (InputStream)System.in, (OutputStream)stdOut, (OutputStream)stdErr);
    }

    protected List<String> getActiveProfileIds() {
        ArrayList<String> activeProfileIds = new ArrayList<String>();
        List activeProfiles = this.project.getActiveProfiles();
        if (activeProfiles != null) {
            for (Object profileObject : activeProfiles) {
                if (!(profileObject instanceof Profile)) continue;
                Profile profile = (Profile)profileObject;
                activeProfileIds.add(profile.getId());
            }
        }
        return activeProfileIds;
    }

    protected List<String> getInactiveProfileIds() {
        ArrayList<String> inactiveProfileIds = new ArrayList<String>();
        List<String> activeProfileIds = this.getActiveProfileIds();
        DefaultProfileManager pm = new DefaultProfileManager(this.session.getContainer(), this.session.getExecutionProperties());
        for (MavenProject parent = this.project; parent != null; parent = parent.getParent()) {
            for (Profile profile : parent.getModel().getProfiles()) {
                String profileId = profile.getId();
                pm.explicitlyActivate(profileId);
                if (activeProfileIds.contains(profileId)) continue;
                inactiveProfileIds.add(profileId);
            }
        }
        return inactiveProfileIds;
    }

    protected Artifact getArtifact(ArtifactItem artifactItem) throws MojoExecutionException {
        VersionRange vr;
        try {
            vr = VersionRange.createFromVersionSpec((String)artifactItem.getVersion());
        }
        catch (InvalidVersionSpecificationException e1) {
            e1.printStackTrace();
            vr = VersionRange.createFromVersion((String)artifactItem.getVersion());
        }
        Artifact artifact = StringUtils.isEmpty((String)artifactItem.getClassifier()) ? this.factory.createDependencyArtifact(artifactItem.getGroupId(), artifactItem.getArtifactId(), vr, artifactItem.getType(), null, "compile") : this.factory.createDependencyArtifact(artifactItem.getGroupId(), artifactItem.getArtifactId(), vr, artifactItem.getType(), artifactItem.getClassifier(), "compile");
        try {
            this.resolver.resolve(artifact, this.remoteRepos, this.local);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve artifact.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to find artifact.", (Exception)((Object)e));
        }
        return artifact;
    }

    protected void fillMissingArtifactVersion(ArtifactItem artifact) throws MojoExecutionException {
        if (!(this.findDependencyVersion(artifact, this.project.getDependencies(), false) || this.project.getDependencyManagement() != null && this.findDependencyVersion(artifact, this.project.getDependencyManagement().getDependencies(), false) || this.findDependencyVersion(artifact, this.project.getDependencies(), true) || this.project.getDependencyManagement() != null && this.findDependencyVersion(artifact, this.project.getDependencyManagement().getDependencies(), true))) {
            throw new MojoExecutionException("Unable to find artifact version of " + artifact.getGroupId() + ":" + artifact.getArtifactId() + " in either dependency list or in project's dependency management.");
        }
    }

    protected boolean findDependencyVersion(ArtifactItem artifact, List<Dependency> list, boolean looseMatch) {
        boolean result = false;
        for (int i = 0; i < list.size(); ++i) {
            Dependency dependency = list.get(i);
            if (!StringUtils.equals((String)dependency.getArtifactId(), (String)artifact.getArtifactId()) || !StringUtils.equals((String)dependency.getGroupId(), (String)artifact.getGroupId()) || !looseMatch && !StringUtils.equals((String)dependency.getClassifier(), (String)artifact.getClassifier()) || !looseMatch && !StringUtils.equals((String)dependency.getType(), (String)artifact.getType())) continue;
            artifact.setVersion(dependency.getVersion());
            result = true;
            break;
        }
        return result;
    }

    protected void completeArtifactItems(List<ArtifactItem> artifactItems, boolean relaxed) throws MojoExecutionException {
        ArrayList<String> warnings = new ArrayList<String>();
        for (ArtifactItem item : artifactItems) {
            try {
                if (StringUtils.isEmpty((String)item.getVersion())) {
                    this.fillMissingArtifactVersion(item);
                }
                item.setArtifact(this.getArtifact(item));
            }
            catch (Exception e) {
                if (relaxed) {
                    warnings.add("Following source artifact is not available in the local repository '" + item.getGroupId() + ":" + item.getArtifactId() + ":" + item.getType() + ":" + item.getClassifier() + ":" + item.getVersion() + "'");
                    continue;
                }
                throw new MojoExecutionException("Following source artifact is not available in the local repository '" + item.getGroupId() + ":" + item.getArtifactId() + ":" + item.getType() + ":" + item.getClassifier() + ":" + item.getVersion() + "'", e);
            }
        }
        if (relaxed && !warnings.isEmpty()) {
            for (String warn : warnings) {
                this.getLog().warn((CharSequence)warn);
            }
        }
    }

    protected static boolean deleteDirectory(File path) {
        if (path.exists() && path.isDirectory()) {
            for (File file : path.listFiles()) {
                if (!(file.isDirectory() ? !AbstractStudioMojo.deleteDirectory(file) : !file.delete())) continue;
                return false;
            }
        }
        return path.delete();
    }

    protected List<Artifact> createArtifactList() {
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        for (Artifact artifact : this.project.getArtifacts()) {
            if (artifact.getScope().equalsIgnoreCase("provided")) continue;
            list.add(artifact);
        }
        Collections.sort(list, new Comparator<Artifact>(){

            @Override
            public int compare(Artifact o1, Artifact o2) {
                String artifactId1 = o1.getArtifactId();
                String artifactId2 = o2.getArtifactId();
                if (artifactId1 != null && artifactId2 != null) {
                    return artifactId1.compareToIgnoreCase(artifactId2);
                }
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        });
        return list;
    }

    public ArtifactFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ArtifactFactory factory) {
        this.factory = factory;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public ArtifactRepository getLocal() {
        return this.local;
    }

    public void setLocal(ArtifactRepository local) {
        this.local = local;
    }

    public List<ArtifactRepository> getRemoteRepos() {
        return this.remoteRepos;
    }

    public void setRemoteRepos(List<ArtifactRepository> remoteRepos) {
        this.remoteRepos = remoteRepos;
    }

    public ArtifactResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(ArtifactResolver resolver) {
        this.resolver = resolver;
    }

    public ArtifactCollector getArtifactCollector() {
        return this.artifactCollector;
    }

    public void setArtifactCollector(ArtifactCollector theArtifactCollector) {
        this.artifactCollector = theArtifactCollector;
    }

    public ArtifactMetadataSource getArtifactMetadataSource() {
        return this.artifactMetadataSource;
    }

    public void setArtifactMetadataSource(ArtifactMetadataSource theArtifactMetadataSource) {
        this.artifactMetadataSource = theArtifactMetadataSource;
    }

    public void setLibraryPath(String pLibraryPath) {
        this.libraryPath = pLibraryPath;
    }
}

