/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.OperationNotSupportedException;
import javax.naming.ServiceUnavailableException;
import javax.naming.TimeLimitExceededException;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SchemaViolationException;
import javax.naming.ldap.LdapName;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.model.exception.LdapAffectMultipleDsaException;
import org.apache.directory.shared.ldap.model.exception.LdapAliasDereferencingException;
import org.apache.directory.shared.ldap.model.exception.LdapAliasException;
import org.apache.directory.shared.ldap.model.exception.LdapAttributeInUseException;
import org.apache.directory.shared.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.shared.ldap.model.exception.LdapAuthenticationNotSupportedException;
import org.apache.directory.shared.ldap.model.exception.LdapContextNotEmptyException;
import org.apache.directory.shared.ldap.model.exception.LdapEntryAlreadyExistsException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidAttributeTypeException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidSearchFilterException;
import org.apache.directory.shared.ldap.model.exception.LdapLoopDetectedException;
import org.apache.directory.shared.ldap.model.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.model.exception.LdapNoSuchAttributeException;
import org.apache.directory.shared.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.shared.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.shared.ldap.model.exception.LdapOtherException;
import org.apache.directory.shared.ldap.model.exception.LdapPartialResultException;
import org.apache.directory.shared.ldap.model.exception.LdapProtocolErrorException;
import org.apache.directory.shared.ldap.model.exception.LdapReferralException;
import org.apache.directory.shared.ldap.model.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.model.exception.LdapServiceUnavailableException;
import org.apache.directory.shared.ldap.model.exception.LdapTimeLimitExceededException;
import org.apache.directory.shared.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.model.exception.MessageException;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.ExtendedRequest;
import org.apache.directory.shared.ldap.model.message.ExtendedResponse;
import org.apache.directory.shared.ldap.model.message.ExtendedResponseImpl;
import org.apache.directory.shared.ldap.model.message.LdapResult;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.model.message.ResultResponse;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.util.WrappedPartialResultException;
import org.apache.directory.shared.ldap.util.WrappedReferralException;

public final class JndiUtils {
    private JndiUtils() {
    }

    public static javax.naming.ldap.Control toJndiControl(LdapCodecService codec, Control control) throws EncoderException {
        return codec.toJndiControl(control);
    }

    public static javax.naming.ldap.Control[] toJndiControls(LdapCodecService codec, Control ... controls) throws EncoderException {
        if (controls != null) {
            javax.naming.ldap.Control[] jndiControls = new javax.naming.ldap.Control[controls.length];
            int i = 0;
            for (Control control : controls) {
                jndiControls[i++] = JndiUtils.toJndiControl(codec, control);
            }
            return jndiControls;
        }
        return null;
    }

    public static Control fromJndiControl(LdapCodecService codec, javax.naming.ldap.Control jndiControl) throws DecoderException {
        return codec.fromJndiControl(jndiControl);
    }

    public static Control[] fromJndiControls(LdapCodecService codec, javax.naming.ldap.Control ... jndiControls) throws DecoderException {
        if (jndiControls != null) {
            Control[] controls = new Control[jndiControls.length];
            int i = 0;
            for (javax.naming.ldap.Control jndiControl : jndiControls) {
                controls[i++] = JndiUtils.fromJndiControl(codec, jndiControl);
            }
            return controls;
        }
        return null;
    }

    public static javax.naming.ldap.ExtendedResponse toJndiExtendedResponse(ExtendedResponse response) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class JndiExtendedResponse
        implements javax.naming.ldap.ExtendedResponse {
            private static final long serialVersionUID = 1L;
            final /* synthetic */ ExtendedResponse val$response;

            JndiExtendedResponse(ExtendedResponse extendedResponse) {
                this.val$response = extendedResponse;
            }

            @Override
            public byte[] getEncodedValue() {
                return this.val$response.getEncodedValue();
            }

            @Override
            public String getID() {
                return this.val$response.getResponseName();
            }
        }
        return new JndiExtendedResponse(response);
    }

    public static javax.naming.ldap.ExtendedRequest toJndiExtendedRequest(ExtendedRequest request) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class JndiExtendedRequest
        implements javax.naming.ldap.ExtendedRequest {
            private static final long serialVersionUID = 1L;
            private javax.naming.ldap.ExtendedResponse response;
            final /* synthetic */ ExtendedRequest val$request;

            JndiExtendedRequest(ExtendedRequest extendedRequest) {
                this.val$request = extendedRequest;
            }

            @Override
            public javax.naming.ldap.ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
                ExtendedResponseImpl response = new ExtendedResponseImpl(this.val$request.getMessageId(), this.val$request.getRequestName());
                response.setResponseName(id);
                response.setResponseValue(berValue);
                this.response = JndiUtils.toJndiExtendedResponse((ExtendedResponse)response);
                return this.response;
            }

            @Override
            public byte[] getEncodedValue() {
                return this.val$request.getRequestValue();
            }

            @Override
            public String getID() {
                return this.val$request.getRequestName();
            }
        }
        return new JndiExtendedRequest(request);
    }

    public static ExtendedResponse fromJndiExtendedResponse(javax.naming.ldap.ExtendedResponse response) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ServerExtendedResponse
        implements ExtendedResponse {
            private static final long serialVersionUID = 1L;
            final /* synthetic */ javax.naming.ldap.ExtendedResponse val$response;

            ServerExtendedResponse(javax.naming.ldap.ExtendedResponse extendedResponse) {
                this.val$response = extendedResponse;
            }

            public String getResponseName() {
                return this.val$response.getID();
            }

            public byte[] getResponseValue() {
                return this.val$response.getEncodedValue();
            }

            public void setResponseName(String oid) {
            }

            public void setResponseValue(byte[] responseValue) {
            }

            public LdapResult getLdapResult() {
                return null;
            }

            public void addAllControls(Control[] controls) throws MessageException {
            }

            public void addControl(Control control) throws MessageException {
            }

            public Object get(Object key) {
                return null;
            }

            public Control getControl(String oid) {
                return null;
            }

            public Map<String, Control> getControls() {
                return null;
            }

            public int getControlsLength() {
                return 0;
            }

            public Control getCurrentControl() {
                return null;
            }

            public int getMessageId() {
                return 0;
            }

            public int getMessageLength() {
                return 0;
            }

            public MessageTypeEnum getType() {
                return null;
            }

            public boolean hasControl(String oid) {
                return false;
            }

            public Object put(Object key, Object value) {
                return null;
            }

            public void removeControl(Control control) throws MessageException {
            }

            public void setControlsLength(int controlsLength) {
            }

            public void setMessageId(int messageId) {
            }

            public void setMessageLength(int messageLength) {
            }

            public byte[] getEncodedValue() {
                return null;
            }

            public String getID() {
                return null;
            }
        }
        return new ServerExtendedResponse(response);
    }

    public static ExtendedRequest fromJndiExtendedRequest(javax.naming.ldap.ExtendedRequest request) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ServerExtendedRequest
        implements ExtendedRequest {
            final /* synthetic */ javax.naming.ldap.ExtendedRequest val$request;

            ServerExtendedRequest(javax.naming.ldap.ExtendedRequest extendedRequest) {
                this.val$request = extendedRequest;
            }

            public String getRequestName() {
                return this.val$request.getID();
            }

            public byte[] getRequestValue() {
                return this.val$request.getEncodedValue();
            }

            public void setRequestName(String oid) {
            }

            public void setRequestValue(byte[] requestValue) {
            }

            public MessageTypeEnum getResponseType() {
                return null;
            }

            public ResultResponse getResultResponse() {
                return null;
            }

            public boolean hasResponse() {
                return false;
            }

            public void addAllControls(Control[] controls) throws MessageException {
            }

            public void addControl(Control control) throws MessageException {
            }

            public Object get(Object key) {
                return null;
            }

            public Control getControl(String oid) {
                return null;
            }

            public Map<String, Control> getControls() {
                return null;
            }

            public int getControlsLength() {
                return 0;
            }

            public Control getCurrentControl() {
                return null;
            }

            public int getMessageId() {
                return 0;
            }

            public int getMessageLength() {
                return 0;
            }

            public MessageTypeEnum getType() {
                return null;
            }

            public boolean hasControl(String oid) {
                return false;
            }

            public Object put(Object key, Object value) {
                return null;
            }

            public void removeControl(Control control) throws MessageException {
            }

            public void setControlsLength(int controlsLength) {
            }

            public void setMessageId(int messageId) {
            }

            public void setMessageLength(int messageLength) {
            }
        }
        return new ServerExtendedRequest(request);
    }

    public static void wrap(Throwable t) throws NamingException {
        if (t instanceof NamingException) {
            throw (NamingException)t;
        }
        NamingException ne = null;
        ne = t instanceof LdapAffectMultipleDsaException ? new NamingException(t.getLocalizedMessage()) : (t instanceof LdapAliasDereferencingException ? new NamingException(t.getLocalizedMessage()) : (t instanceof LdapAliasException ? new NamingException(t.getLocalizedMessage()) : (t instanceof LdapAttributeInUseException ? new AttributeInUseException(t.getLocalizedMessage()) : (t instanceof LdapAuthenticationException ? new AuthenticationException(t.getLocalizedMessage()) : (t instanceof LdapAuthenticationNotSupportedException ? new AuthenticationNotSupportedException(t.getLocalizedMessage()) : (t instanceof LdapContextNotEmptyException ? new ContextNotEmptyException(t.getLocalizedMessage()) : (t instanceof LdapEntryAlreadyExistsException ? new NameAlreadyBoundException(t.getLocalizedMessage()) : (t instanceof LdapInvalidAttributeTypeException ? new InvalidAttributeIdentifierException(t.getLocalizedMessage()) : (t instanceof LdapInvalidAttributeValueException ? new InvalidAttributeValueException(t.getLocalizedMessage()) : (t instanceof LdapInvalidDnException ? new InvalidNameException(t.getLocalizedMessage()) : (t instanceof LdapInvalidSearchFilterException ? new InvalidSearchFilterException(t.getLocalizedMessage()) : (t instanceof LdapLoopDetectedException ? new NamingException(t.getLocalizedMessage()) : (t instanceof LdapNoPermissionException ? new NoPermissionException(t.getLocalizedMessage()) : (t instanceof LdapNoSuchAttributeException ? new NoSuchAttributeException(t.getLocalizedMessage()) : (t instanceof LdapNoSuchObjectException ? new NameNotFoundException(t.getLocalizedMessage()) : (t instanceof LdapOperationErrorException ? new NamingException(t.getLocalizedMessage()) : (t instanceof LdapOtherException ? new NamingException(t.getLocalizedMessage()) : (t instanceof LdapProtocolErrorException ? new CommunicationException(t.getLocalizedMessage()) : (t instanceof LdapReferralException ? new WrappedReferralException((LdapReferralException)t) : (t instanceof LdapPartialResultException ? new WrappedPartialResultException((LdapPartialResultException)t) : (t instanceof LdapSchemaViolationException ? new SchemaViolationException(t.getLocalizedMessage()) : (t instanceof LdapServiceUnavailableException ? new ServiceUnavailableException(t.getLocalizedMessage()) : (t instanceof LdapTimeLimitExceededException ? new TimeLimitExceededException(t.getLocalizedMessage()) : (t instanceof LdapUnwillingToPerformException ? new OperationNotSupportedException(t.getLocalizedMessage()) : new NamingException(t.getLocalizedMessage())))))))))))))))))))))))));
        ne.setRootCause(t);
        throw ne;
    }

    public static Name toName(Dn dn) {
        try {
            LdapName name = new LdapName(dn.toString());
            return name;
        }
        catch (InvalidNameException ine) {
            return null;
        }
    }

    public static Dn fromName(Name name) {
        try {
            Dn dn = new Dn(name.toString());
            return dn;
        }
        catch (LdapInvalidDnException lide) {
            return null;
        }
    }
}

