/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.shared.ldap.name.AttributeTypeAndValue;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtavSerializer {
    protected static final Logger LOG = LoggerFactory.getLogger(AtavSerializer.class);

    public static void serialize(AttributeTypeAndValue atav, ObjectOutput out) throws IOException {
        if (StringTools.isEmpty(atav.getUpName()) || StringTools.isEmpty(atav.getUpType()) || StringTools.isEmpty(atav.getNormType()) || atav.getStart() < 0 || atav.getLength() < 2 || atav.getUpValue() == null || atav.getNormValue() == null) {
            String message = "Cannot serialize an wrong ATAV, ";
            if (StringTools.isEmpty(atav.getUpName())) {
                message = message + "the upName should not be null or empty";
            } else if (StringTools.isEmpty(atav.getUpType())) {
                message = message + "the upType should not be null or empty";
            } else if (StringTools.isEmpty(atav.getNormType())) {
                message = message + "the normType should not be null or empty";
            } else if (atav.getStart() < 0) {
                message = message + "the start should not be < 0";
            } else if (atav.getLength() < 2) {
                message = message + "the length should not be < 2";
            } else if (atav.getUpValue() == null) {
                message = message + "the upValue should not be null";
            } else if (atav.getNormValue() == null) {
                message = message + "the value should not be null";
            }
            LOG.error(message);
            throw new IOException(message);
        }
        out.writeUTF(atav.getUpName());
        out.writeInt(atav.getStart());
        out.writeInt(atav.getLength());
        out.writeUTF(atav.getUpType());
        out.writeUTF(atav.getNormType());
        boolean isHR = atav.getNormValue() instanceof String;
        out.writeBoolean(isHR);
        if (isHR) {
            out.writeUTF((String)atav.getUpValue());
            out.writeUTF((String)atav.getNormValue());
        } else {
            out.writeInt(((byte[])atav.getUpValue()).length);
            out.write((byte[])atav.getUpValue());
            out.writeInt(((byte[])atav.getNormValue()).length);
            out.write((byte[])atav.getNormValue());
        }
        out.flush();
    }

    public static AttributeTypeAndValue deserialize(ObjectInput in) throws IOException, ClassNotFoundException {
        String upName = in.readUTF();
        int start = in.readInt();
        int length = in.readInt();
        String upType = in.readUTF();
        String normType = in.readUTF();
        boolean isHR = in.readBoolean();
        if (isHR) {
            String upValue = in.readUTF();
            String normValue = in.readUTF();
            AttributeTypeAndValue atav = new AttributeTypeAndValue(upType, normType, upValue, normValue, start, length, upName);
            return atav;
        }
        int upValueLength = in.readInt();
        byte[] upValue = new byte[upValueLength];
        in.readFully(upValue);
        int valueLength = in.readInt();
        byte[] normValue = new byte[valueLength];
        in.readFully(normValue);
        AttributeTypeAndValue atav = new AttributeTypeAndValue(upType, normType, upValue, normValue, start, length, upName);
        return atav;
    }
}

