/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.ldif;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdifAttributesReader
extends LdifReader {
    private static final Logger LOG = LoggerFactory.getLogger(LdifAttributesReader.class);

    public LdifAttributesReader() {
        this.lines = new ArrayList();
        this.position = new LdifReader.Position();
        this.version = 1;
    }

    private void parseAttribute(Attributes attributes, String line, String lowerLine) throws NamingException {
        int colonIndex = line.indexOf(58);
        String attributeType = lowerLine.substring(0, colonIndex);
        if (attributeType.equals("dn")) {
            LOG.error("An entry must not have two DNs");
            throw new NamingException("A ldif entry should not have two DNs");
        }
        Object attributeValue = this.parseValue(line, colonIndex);
        Attribute attribute = attributes.get(attributeType);
        if (attribute == null) {
            attributes.put(attributeType, attributeValue);
        } else {
            attribute.add(attributeValue);
        }
    }

    private Attributes parseAttributes() throws NamingException {
        if (this.lines == null || this.lines.size() == 0) {
            LOG.debug("The entry is empty : end of ldif file");
            return null;
        }
        String line = (String)this.lines.get(0);
        BasicAttributes attributes = new BasicAttributes(true);
        Iterator iter = this.lines.iterator();
        String lowerLine = null;
        while (iter.hasNext()) {
            line = (String)iter.next();
            lowerLine = line.toLowerCase();
            if (lowerLine.startsWith("control:")) {
                LOG.error("We cannot have changes when reading a file which already contains entries");
                throw new NamingException("No changes withing entries");
            }
            if (lowerLine.startsWith("changetype:")) {
                LOG.error("We cannot have changes when reading a file which already contains entries");
                throw new NamingException("No changes withing entries");
            }
            if (line.indexOf(58) > 0) {
                this.parseAttribute(attributes, line, lowerLine);
                continue;
            }
            LOG.error("Expecting an attribute type");
            throw new NamingException("Bad attribute");
        }
        LOG.debug("Read an attributes : {}", (Object)attributes);
        return attributes;
    }

    public Attributes parseAttributes(String ldif) throws NamingException {
        this.lines = new ArrayList();
        this.position = new LdifReader.Position();
        LOG.debug("Starts parsing ldif buffer");
        if (StringTools.isEmpty(ldif)) {
            return new BasicAttributes(true);
        }
        StringReader strIn = new StringReader(ldif);
        this.in = new BufferedReader(strIn);
        try {
            this.readLines();
            Attributes attributes = this.parseAttributes();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parsed {} entries.", (Object)(attributes == null ? 0 : 1));
            }
            return attributes;
        }
        catch (NamingException ne) {
            LOG.error("Cannot parse the ldif buffer : {}", (Object)ne.getMessage());
            throw new NamingException("Error while parsing the ldif buffer");
        }
    }
}

