/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.entry.client;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.InvalidAttributeValueException;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientAttribute;
import org.apache.directory.shared.ldap.entry.client.ClientBinaryValue;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClientAttribute
implements ClientAttribute {
    public static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultClientAttribute.class);
    protected Set<Value<?>> values = new LinkedHashSet();
    protected String upId;
    protected String id;
    protected Boolean isHR;

    public DefaultClientAttribute() {
    }

    public DefaultClientAttribute(String upId) {
        this.setUpId(upId);
    }

    public DefaultClientAttribute(String upId, Value<?> ... vals) {
        if (vals[0] == null) {
            this.add(new ClientStringValue());
        } else {
            for (Value<?> val : vals) {
                if (!(val instanceof ClientStringValue) && !(val instanceof ClientBinaryValue)) {
                    String message = "Unknown value type: " + val.getClass().getName();
                    LOG.error(message);
                    throw new IllegalStateException(message);
                }
                this.add(val);
            }
        }
        this.setUpId(upId);
    }

    public DefaultClientAttribute(String upId, String ... vals) {
        this.add(vals);
        this.setUpId(upId);
    }

    public DefaultClientAttribute(String upId, byte[] ... vals) {
        this.add(vals);
        this.setUpId(upId);
    }

    @Override
    public byte[] getBytes() throws InvalidAttributeValueException {
        Value<?> value = this.get();
        if (value instanceof ClientBinaryValue) {
            return (byte[])value.get();
        }
        String message = "The value is expected to be a byte[]";
        LOG.error(message);
        throw new InvalidAttributeValueException(message);
    }

    @Override
    public String getString() throws InvalidAttributeValueException {
        Value<?> value = this.get();
        if (value instanceof ClientStringValue) {
            return (String)value.get();
        }
        String message = "The value is expected to be a String";
        LOG.error(message);
        throw new InvalidAttributeValueException(message);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setHR(boolean isHR) {
        this.isHR = isHR;
    }

    @Override
    public void setId(String id) {
        this.id = StringTools.trim(StringTools.lowerCaseAscii(id));
        if (this.id.length() == 0) {
            this.id = null;
            throw new IllegalArgumentException("An ID cannnot be null, empty, or resolved to an emtpy value when trimmed");
        }
    }

    @Override
    public String getUpId() {
        return this.upId;
    }

    @Override
    public void setUpId(String upId) {
        this.upId = StringTools.trim(upId);
        if (this.upId.length() == 0) {
            this.upId = null;
            throw new IllegalArgumentException("An ID cannnot be null, empty, or resolved to an emtpy value when trimmed");
        }
        this.id = StringTools.lowerCaseAscii(this.upId);
    }

    @Override
    public boolean isHR() {
        return this.isHR != null ? this.isHR : false;
    }

    public boolean isValid() throws NamingException {
        for (Value<?> value : this.values) {
            if (value.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValid(SyntaxChecker checker) throws NamingException {
        for (Value<?> value : this.values) {
            if (value.isValid(checker)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int add(Value<?> ... vals) {
        int nbAdded = 0;
        ClientBinaryValue nullBinaryValue = null;
        ClientStringValue nullStringValue = null;
        boolean nullValueAdded = false;
        for (Value<?> val : vals) {
            if (val == null) {
                if (this.isHR == null) {
                    nullBinaryValue = new ClientBinaryValue(null);
                    nullStringValue = new ClientStringValue(null);
                    this.values.add(nullBinaryValue);
                    this.values.add(nullStringValue);
                    nullValueAdded = true;
                    ++nbAdded;
                    continue;
                }
                if (!this.isHR.booleanValue()) {
                    nullBinaryValue = new ClientBinaryValue(null);
                    if (this.values.contains(nullBinaryValue)) continue;
                    this.values.add(nullBinaryValue);
                    ++nbAdded;
                    continue;
                }
                nullStringValue = new ClientStringValue(null);
                if (this.values.contains(nullStringValue)) continue;
                this.values.add(nullStringValue);
                continue;
            }
            if (val instanceof ClientStringValue) {
                if (this.isHR == null) {
                    this.isHR = true;
                    this.values.add(val);
                    ++nbAdded;
                    continue;
                }
                if (!this.isHR.booleanValue()) {
                    ClientBinaryValue cbv = new ClientBinaryValue();
                    cbv.set(StringTools.getBytesUtf8((String)val.get()));
                    if (this.contains(cbv)) continue;
                    this.values.add(cbv);
                    ++nbAdded;
                    continue;
                }
                if (this.contains(val)) continue;
                this.values.add(val);
                ++nbAdded;
                continue;
            }
            if (this.isHR == null) {
                this.isHR = false;
                this.values.add(val);
                ++nbAdded;
                continue;
            }
            if (!this.isHR.booleanValue()) {
                if (this.contains(val)) continue;
                this.values.add(val);
                ++nbAdded;
                continue;
            }
            ClientStringValue csv = new ClientStringValue();
            csv.set(StringTools.utf8ToString((byte[])val.get()));
            if (this.contains(csv)) continue;
            this.values.add(csv);
            ++nbAdded;
        }
        if (nullValueAdded) {
            if (this.isHR.booleanValue()) {
                this.values.remove(nullBinaryValue);
            } else {
                this.values.remove(nullStringValue);
            }
        }
        return nbAdded;
    }

    @Override
    public int add(String ... vals) {
        int nbAdded = 0;
        if (this.isHR == null) {
            this.isHR = true;
        }
        if (this.isHR.booleanValue()) {
            for (String val : vals) {
                if (this.contains(val) || this.add(new ClientStringValue(val)) != 1) continue;
                ++nbAdded;
            }
        } else {
            for (String val : vals) {
                byte[] valBytes = null;
                if (val != null) {
                    valBytes = StringTools.getBytesUtf8(val);
                }
                if (this.add(new ClientBinaryValue(valBytes)) != 1) continue;
                ++nbAdded;
            }
        }
        return nbAdded;
    }

    @Override
    public int add(byte[] ... vals) {
        int nbAdded = 0;
        if (this.isHR == null) {
            this.isHR = false;
        }
        if (this.isHR.booleanValue()) {
            for (byte[] val : vals) {
                String valString = null;
                if (val != null) {
                    valString = StringTools.utf8ToString(val);
                }
                if (this.contains(new byte[][]{val}) || this.add(new ClientStringValue(valString)) != 1) continue;
                ++nbAdded;
            }
        } else {
            for (byte[] val : vals) {
                if (this.add(new ClientBinaryValue(val)) != 1) continue;
                ++nbAdded;
            }
        }
        return nbAdded;
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public boolean contains(Value<?> ... vals) {
        if (this.isHR == null) {
            return false;
        }
        if (this.isHR.booleanValue()) {
            for (Value<?> val : vals) {
                byte[] binaryVal;
                if (!(val instanceof ClientStringValue ? !this.values.contains(val) : !this.values.contains(new ClientStringValue(StringTools.utf8ToString(binaryVal = (byte[])val.get()))))) continue;
                return false;
            }
        } else {
            for (Value<?> val : vals) {
                String stringVal;
                if (!(val instanceof ClientBinaryValue ? !this.values.contains(val) : !this.values.contains(new ClientBinaryValue(StringTools.getBytesUtf8(stringVal = (String)val.get()))))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean contains(String ... vals) {
        if (this.isHR == null) {
            return false;
        }
        if (this.isHR.booleanValue()) {
            for (String val : vals) {
                if (this.contains(new ClientStringValue(val))) continue;
                return false;
            }
        } else {
            for (String val : vals) {
                byte[] binaryVal = StringTools.getBytesUtf8(val);
                if (this.contains(new ClientBinaryValue(binaryVal))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean contains(byte[] ... vals) {
        if (this.isHR == null) {
            return false;
        }
        if (!this.isHR.booleanValue()) {
            for (byte[] val : vals) {
                if (this.contains(new ClientBinaryValue(val))) continue;
                return false;
            }
        } else {
            for (byte[] val : vals) {
                String stringVal = StringTools.utf8ToString(val);
                if (this.contains(new ClientStringValue(stringVal))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean contains(Object ... vals) {
        boolean isHR = true;
        boolean seen = false;
        for (Object val : vals) {
            if (val instanceof String) {
                if (!seen) {
                    isHR = true;
                    seen = true;
                }
                if (isHR) {
                    if (this.contains((String)val)) continue;
                    return false;
                }
                return false;
            }
            if (!seen) {
                isHR = false;
                seen = true;
            }
            if (!isHR) {
                if (this.contains(new byte[][]{(byte[])val})) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public Value<?> get() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.iterator().next();
    }

    @Override
    public Iterator<Value<?>> getAll() {
        return this.iterator();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean remove(Value<?> ... vals) {
        if (this.isHR == null || this.values.size() == 0) {
            return false;
        }
        boolean removed = true;
        if (this.isHR.booleanValue()) {
            for (Value<?> val : vals) {
                if (val instanceof ClientStringValue) {
                    removed &= this.values.remove(val);
                    continue;
                }
                byte[] binaryVal = (byte[])val.get();
                removed &= this.values.remove(new ClientStringValue(StringTools.utf8ToString(binaryVal)));
            }
        } else {
            for (Value<?> val : vals) {
                if (val instanceof ClientBinaryValue) {
                    removed &= this.values.remove(val);
                    continue;
                }
                String stringVal = (String)val.get();
                removed &= this.values.remove(new ClientBinaryValue(StringTools.getBytesUtf8(stringVal)));
            }
        }
        return removed;
    }

    @Override
    public boolean remove(byte[] ... vals) {
        if (this.isHR == null || this.values.size() == 0) {
            return false;
        }
        boolean removed = true;
        if (!this.isHR.booleanValue()) {
            for (byte[] val : vals) {
                ClientBinaryValue value = new ClientBinaryValue(val);
                removed &= this.values.remove(value);
            }
        } else {
            for (byte[] val : vals) {
                ClientStringValue value = new ClientStringValue(StringTools.utf8ToString(val));
                removed &= this.values.remove(value);
            }
        }
        return removed;
    }

    @Override
    public boolean remove(String ... vals) {
        if (this.isHR == null || this.values.size() == 0) {
            return false;
        }
        boolean removed = true;
        if (this.isHR.booleanValue()) {
            for (String val : vals) {
                ClientStringValue value = new ClientStringValue(val);
                removed &= this.values.remove(value);
            }
        } else {
            for (String val : vals) {
                ClientBinaryValue value = new ClientBinaryValue(StringTools.getBytesUtf8(val));
                removed &= this.values.remove(value);
            }
        }
        return removed;
    }

    @Override
    public Iterator<Value<?>> iterator() {
        return this.values.iterator();
    }

    @Override
    public int put(String ... vals) {
        this.values.clear();
        return this.add(vals);
    }

    @Override
    public int put(byte[] ... vals) {
        this.values.clear();
        return this.add(vals);
    }

    @Override
    public int put(Value<?> ... vals) {
        this.values.clear();
        return this.add(vals);
    }

    @Override
    public int put(List<Value<?>> vals) {
        this.values.clear();
        Value[] valArray = new Value[vals.size()];
        return this.add(vals.toArray(valArray));
    }

    public int hashCode() {
        int h = 37;
        if (this.isHR != null) {
            h = h * 17 + this.isHR.hashCode();
        }
        if (this.id != null) {
            h = h * 17 + this.id.hashCode();
        }
        for (Value<?> value : this.values) {
            h = h * 17 + value.hashCode();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntryAttribute)) {
            return false;
        }
        EntryAttribute other = (EntryAttribute)obj;
        if (this.id == null) {
            if (other.getId() != null) {
                return false;
            }
        } else {
            if (other.getId() == null) {
                return false;
            }
            if (!this.id.equals(other.getId())) {
                return false;
            }
        }
        if (this.isHR() != other.isHR()) {
            return false;
        }
        if (this.values.size() != other.size()) {
            return false;
        }
        for (Value<?> val : this.values) {
            if (other.contains(val)) continue;
            return false;
        }
        return true;
    }

    @Override
    public EntryAttribute clone() {
        try {
            DefaultClientAttribute attribute = (DefaultClientAttribute)super.clone();
            attribute.values = new LinkedHashSet(this.values.size());
            for (Value<?> value : this.values) {
                attribute.values.add(value.clone());
            }
            return attribute;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.values != null && this.values.size() != 0) {
            for (Value<?> value : this.values) {
                sb.append("    ").append(this.upId).append(": ");
                if (value.isNull()) {
                    sb.append("''");
                } else {
                    sb.append(value);
                }
                sb.append('\n');
            }
        } else {
            sb.append("    ").append(this.upId).append(": (null)\n");
        }
        return sb.toString();
    }
}

