/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.directory.Attribute;
import org.apache.directory.shared.ldap.aci.ACIItem;
import org.apache.directory.shared.ldap.aci.AntlrACIItemParserTokenTypes;
import org.apache.directory.shared.ldap.aci.GrantAndDenial;
import org.apache.directory.shared.ldap.aci.ItemFirstACIItem;
import org.apache.directory.shared.ldap.aci.ItemPermission;
import org.apache.directory.shared.ldap.aci.ProtectedItem;
import org.apache.directory.shared.ldap.aci.UserClass;
import org.apache.directory.shared.ldap.aci.UserFirstACIItem;
import org.apache.directory.shared.ldap.aci.UserPermission;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.filter.AbstractExprNode;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterParser;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.NotNode;
import org.apache.directory.shared.ldap.filter.OrNode;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.NameComponentNormalizer;
import org.apache.directory.shared.ldap.schema.OidNormalizer;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecificationModifier;
import org.apache.directory.shared.ldap.util.ComponentsMonitor;
import org.apache.directory.shared.ldap.util.MandatoryAndOptionalComponentsMonitor;
import org.apache.directory.shared.ldap.util.MandatoryComponentsMonitor;
import org.apache.directory.shared.ldap.util.NamespaceTools;
import org.apache.directory.shared.ldap.util.NoDuplicateKeysMap;
import org.apache.directory.shared.ldap.util.OptionalComponentsMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntlrACIItemParser
extends LLkParser
implements AntlrACIItemParserTokenTypes {
    private static final Logger log = LoggerFactory.getLogger(AntlrACIItemParser.class);
    NameComponentNormalizer normalizer;
    private String identificationTag;
    private AuthenticationLevel authenticationLevel;
    private int aciPrecedence;
    private boolean isItemFirstACIItem;
    private Set<ProtectedItem> protectedItems;
    private Map<String, ProtectedItem> protectedItemsMap;
    private Set<UserClass> userClasses;
    private Map<String, UserClass> userClassesMap;
    private Set<ItemPermission> itemPermissions;
    private int precedence;
    private Set<GrantAndDenial> grantsAndDenials;
    private Set<UserPermission> userPermissions;
    private Map<String, OidNormalizer> oidsMap;
    private Set<LdapDN> chopBeforeExclusions;
    private Set<LdapDN> chopAfterExclusions;
    private SubtreeSpecificationModifier ssModifier = null;
    private ComponentsMonitor mainACIItemComponentsMonitor;
    private ComponentsMonitor itemPermissionComponentsMonitor;
    private ComponentsMonitor userPermissionComponentsMonitor;
    private ComponentsMonitor subtreeSpecificationComponentsMonitor;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "ATTRIBUTE_VALUE_CANDIDATE", "RANGE_OF_VALUES_CANDIDATE", "SP", "OPEN_CURLY", "SEP", "CLOSE_CURLY", "\"identificationTag\"", "SAFEUTF8STRING", "\"precedence\"", "INTEGER", "\"authenticationLevel\"", "\"none\"", "\"simple\"", "\"strong\"", "\"itemOrUserFirst\"", "\"itemFirst\"", "COLON", "\"userFirst\"", "\"protectedItems\"", "\"entry\"", "\"allUserAttributeTypes\"", "\"attributeType\"", "\"allAttributeValues\"", "\"allUserAttributeTypesAndValues\"", "\"selfValue\"", "\"maxValueCount\"", "\"type\"", "\"maxCount\"", "\"maxImmSub\"", "\"restrictedBy\"", "\"valuesIn\"", "\"classes\"", "\"itemPermissions\"", "\"grantsAndDenials\"", "\"grantAdd\"", "\"denyAdd\"", "\"grantDiscloseOnError\"", "\"denyDiscloseOnError\"", "\"grantRead\"", "\"denyRead\"", "\"grantRemove\"", "\"denyRemove\"", "\"grantBrowse\"", "\"denyBrowse\"", "\"grantExport\"", "\"denyExport\"", "\"grantImport\"", "\"denyImport\"", "\"grantModify\"", "\"denyModify\"", "\"grantRename\"", "\"denyRename\"", "\"grantReturnDN\"", "\"denyReturnDN\"", "\"grantCompare\"", "\"denyCompare\"", "\"grantFilterMatch\"", "\"denyFilterMatch\"", "\"grantInvoke\"", "\"denyInvoke\"", "\"userClasses\"", "\"allUsers\"", "\"thisEntry\"", "\"name\"", "\"userGroup\"", "\"subtree\"", "\"userPermissions\"", "\"base\"", "\"specificExclusions\"", "\"chopBefore\"", "\"chopAfter\"", "\"minimum\"", "\"maximum\"", "DESCR", "NUMERICOID", "\"item\"", "\"and\"", "\"or\"", "\"not\"", "\"FALSE\"", "\"TRUE\"", "\"level\"", "\"basicLevels\"", "\"localQualifier\"", "\"signed\"", "\"rangeOfValues\"", "\"specificationFilter\"", "SAFEUTF8CHAR", "DIGIT", "LDIGIT", "ALPHA", "HYPHEN", "DOT", "INTEGER_OR_NUMERICOID", "FILTER", "FILTER_VALUE"};

    public void init(Map<String, OidNormalizer> oidsMap) {
        this.oidsMap = oidsMap;
    }

    public void setNormalizer(NameComponentNormalizer normalizer) {
        this.normalizer = normalizer;
    }

    private int token2Integer(Token token) throws RecognitionException {
        int i = 0;
        try {
            i = Integer.parseInt(token.getText());
        }
        catch (NumberFormatException e) {
            throw new RecognitionException("Value of INTEGER token " + token.getText() + " cannot be converted to an Integer");
        }
        return i;
    }

    protected AntlrACIItemParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public AntlrACIItemParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 1);
    }

    protected AntlrACIItemParser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public AntlrACIItemParser(TokenStream lexer) {
        this(lexer, 1);
    }

    public AntlrACIItemParser(ParserSharedInputState state) {
        super(state, 1);
        this.tokenNames = _tokenNames;
    }

    public final ACIItem wrapperEntryPoint() throws RecognitionException, TokenStreamException {
        log.debug("entered wrapperEntryPoint()");
        ACIItem l_ACIItem = null;
        while (this.LA(1) == 6) {
            this.match(6);
        }
        l_ACIItem = this.theACIItem();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(1);
        return l_ACIItem;
    }

    public final ACIItem theACIItem() throws RecognitionException, TokenStreamException {
        log.debug("entered theACIItem()");
        ACIItem ACIItem2 = null;
        this.mainACIItemComponentsMonitor = new MandatoryComponentsMonitor(new String[]{"identificationTag", "precedence", "authenticationLevel", "itemOrUserFirst"});
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.mainACIItemComponent();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        while (this.LA(1) == 8) {
            this.match(8);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            this.mainACIItemComponent();
            while (this.LA(1) == 6) {
                this.match(6);
            }
        }
        this.match(9);
        if (!this.mainACIItemComponentsMonitor.finalStateValid()) {
            throw new RecognitionException("Missing mandatory ACIItem components: " + this.mainACIItemComponentsMonitor.getRemainingComponents());
        }
        ACIItem2 = this.isItemFirstACIItem ? new ItemFirstACIItem(this.identificationTag, this.precedence, this.authenticationLevel, this.protectedItems, this.itemPermissions) : new UserFirstACIItem(this.identificationTag, this.aciPrecedence, this.authenticationLevel, this.userClasses, this.userPermissions);
        return ACIItem2;
    }

    public final void mainACIItemComponent() throws RecognitionException, TokenStreamException {
        log.debug("entered mainACIItemComponent()");
        try {
            switch (this.LA(1)) {
                case 10: {
                    this.aci_identificationTag();
                    this.mainACIItemComponentsMonitor.useComponent("identificationTag");
                    break;
                }
                case 12: {
                    this.aci_precedence();
                    this.mainACIItemComponentsMonitor.useComponent("precedence");
                    break;
                }
                case 14: {
                    this.aci_authenticationLevel();
                    this.mainACIItemComponentsMonitor.useComponent("authenticationLevel");
                    break;
                }
                case 18: {
                    this.aci_itemOrUserFirst();
                    this.mainACIItemComponentsMonitor.useComponent("itemOrUserFirst");
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new RecognitionException(e.getMessage());
        }
    }

    public final void aci_identificationTag() throws RecognitionException, TokenStreamException {
        Token token = null;
        log.debug("entered aci_identificationTag()");
        this.match(10);
        int _cnt20 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt20 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt20;
        }
        token = this.LT(1);
        this.match(11);
        this.identificationTag = token.getText();
    }

    public final void aci_precedence() throws RecognitionException, TokenStreamException {
        log.debug("entered aci_precedence()");
        this.precedence();
        this.aciPrecedence = this.precedence;
    }

    public final void aci_authenticationLevel() throws RecognitionException, TokenStreamException {
        log.debug("entered aci_authenticationLevel()");
        this.match(14);
        int _cnt27 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt27 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt27;
        }
        this.authenticationLevel();
    }

    public final void aci_itemOrUserFirst() throws RecognitionException, TokenStreamException {
        log.debug("entered aci_itemOrUserFirst()");
        this.match(18);
        int _cnt31 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt31 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt31;
        }
        this.itemOrUserFirst();
    }

    public final void precedence() throws RecognitionException, TokenStreamException {
        Token token = null;
        log.debug("entered precedence()");
        this.match(12);
        int _cnt24 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt24 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt24;
        }
        token = this.LT(1);
        this.match(13);
        this.precedence = this.token2Integer(token);
        if (this.precedence < 0 || this.precedence > 255) {
            throw new RecognitionException("Expecting INTEGER token having an Integer value between 0 and 255, found " + this.precedence);
        }
    }

    public final void authenticationLevel() throws RecognitionException, TokenStreamException {
        log.debug("entered authenticationLevel()");
        switch (this.LA(1)) {
            case 15: {
                this.match(15);
                this.authenticationLevel = AuthenticationLevel.NONE;
                break;
            }
            case 16: {
                this.match(16);
                this.authenticationLevel = AuthenticationLevel.SIMPLE;
                break;
            }
            case 17: {
                this.match(17);
                this.authenticationLevel = AuthenticationLevel.STRONG;
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void itemOrUserFirst() throws RecognitionException, TokenStreamException {
        log.debug("entered itemOrUserFirst()");
        switch (this.LA(1)) {
            case 19: {
                this.itemFirst();
                break;
            }
            case 21: {
                this.userFirst();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void itemFirst() throws RecognitionException, TokenStreamException {
        log.debug("entered itemFirst()");
        this.match(19);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(20);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 22: {
                this.protectedItems();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.match(8);
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.itemPermissions();
                break;
            }
            case 36: {
                this.itemPermissions();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.match(8);
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.protectedItems();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(9);
        this.isItemFirstACIItem = true;
    }

    public final void userFirst() throws RecognitionException, TokenStreamException {
        log.debug("entered userFirst()");
        this.match(21);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(20);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 64: {
                this.userClasses();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.match(8);
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.userPermissions();
                break;
            }
            case 70: {
                this.userPermissions();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.match(8);
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.userClasses();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(9);
        this.isItemFirstACIItem = false;
    }

    public final void protectedItems() throws RecognitionException, TokenStreamException {
        log.debug("entered protectedItems()");
        this.protectedItemsMap = new NoDuplicateKeysMap();
        try {
            this.match(22);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            this.match(7);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            switch (this.LA(1)) {
                case 4: 
                case 5: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 32: 
                case 33: 
                case 35: {
                    this.protectedItem();
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    while (this.LA(1) == 8) {
                        this.match(8);
                        while (this.LA(1) == 6) {
                            this.match(6);
                        }
                        this.protectedItem();
                        while (this.LA(1) == 6) {
                            this.match(6);
                        }
                    }
                    break;
                }
                case 9: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(9);
            this.protectedItems = new HashSet<ProtectedItem>(this.protectedItemsMap.values());
        }
        catch (IllegalArgumentException e) {
            throw new RecognitionException("Protected Items cannot be duplicated. " + e.getMessage());
        }
    }

    public final void itemPermissions() throws RecognitionException, TokenStreamException {
        log.debug("entered itemPermissions()");
        this.itemPermissions = new HashSet<ItemPermission>();
        ItemPermission itemPermission = null;
        this.match(36);
        int _cnt187 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt187 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt187;
        }
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 7: {
                itemPermission = this.itemPermission();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.itemPermissions.add(itemPermission);
                while (this.LA(1) == 8) {
                    this.match(8);
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    itemPermission = this.itemPermission();
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    this.itemPermissions.add(itemPermission);
                }
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(9);
    }

    public final void userClasses() throws RecognitionException, TokenStreamException {
        log.debug("entered userClasses()");
        this.userClassesMap = new NoDuplicateKeysMap();
        try {
            this.match(64);
            int _cnt228 = 0;
            while (true) {
                if (this.LA(1) != 6) {
                    if (_cnt228 >= 1) break;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.match(6);
                ++_cnt228;
            }
            this.match(7);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            switch (this.LA(1)) {
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: {
                    this.userClass();
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    while (this.LA(1) == 8) {
                        this.match(8);
                        while (this.LA(1) == 6) {
                            this.match(6);
                        }
                        this.userClass();
                        while (this.LA(1) == 6) {
                            this.match(6);
                        }
                    }
                    break;
                }
                case 9: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(9);
            this.userClasses = new HashSet<UserClass>(this.userClassesMap.values());
        }
        catch (IllegalArgumentException e) {
            throw new RecognitionException("User Classes cannot be duplicated. " + e.getMessage());
        }
    }

    public final void userPermissions() throws RecognitionException, TokenStreamException {
        log.debug("entered userPermissions()");
        this.userPermissions = new HashSet<UserPermission>();
        UserPermission userPermission = null;
        this.match(70);
        int _cnt284 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt284 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt284;
        }
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 7: {
                userPermission = this.userPermission();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.userPermissions.add(userPermission);
                while (this.LA(1) == 8) {
                    this.match(8);
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    userPermission = this.userPermission();
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    this.userPermissions.add(userPermission);
                }
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(9);
    }

    public final void protectedItem() throws RecognitionException, TokenStreamException {
        log.debug("entered protectedItem()");
        switch (this.LA(1)) {
            case 23: {
                this.entry();
                break;
            }
            case 24: {
                this.allUserAttributeTypes();
                break;
            }
            case 25: {
                this.attributeType();
                break;
            }
            case 26: {
                this.allAttributeValues();
                break;
            }
            case 27: {
                this.allUserAttributeTypesAndValues();
                break;
            }
            case 4: {
                this.attributeValue();
                break;
            }
            case 28: {
                this.selfValue();
                break;
            }
            case 5: {
                this.rangeOfValues();
                break;
            }
            case 29: {
                this.maxValueCount();
                break;
            }
            case 32: {
                this.maxImmSub();
                break;
            }
            case 33: {
                this.restrictedBy();
                break;
            }
            case 35: {
                this.classes();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void entry() throws RecognitionException, TokenStreamException {
        log.debug("entered entry()");
        this.match(23);
        this.protectedItemsMap.put("entry", ProtectedItem.ENTRY);
    }

    public final void allUserAttributeTypes() throws RecognitionException, TokenStreamException {
        log.debug("entered allUserAttributeTypes()");
        this.match(24);
        this.protectedItemsMap.put("allUserAttributeTypes", ProtectedItem.ALL_USER_ATTRIBUTE_TYPES);
    }

    public final void attributeType() throws RecognitionException, TokenStreamException {
        log.debug("entered attributeType()");
        Set<String> attributeTypeSet = null;
        this.match(25);
        int _cnt88 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt88 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt88;
        }
        attributeTypeSet = this.attributeTypeSet();
        this.protectedItemsMap.put("attributeType", new ProtectedItem.AttributeType(attributeTypeSet));
    }

    public final void allAttributeValues() throws RecognitionException, TokenStreamException {
        log.debug("entered allAttributeValues()");
        Set<String> attributeTypeSet = null;
        this.match(26);
        int _cnt91 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt91 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt91;
        }
        attributeTypeSet = this.attributeTypeSet();
        this.protectedItemsMap.put("allAttributeValues", new ProtectedItem.AllAttributeValues(attributeTypeSet));
    }

    public final void allUserAttributeTypesAndValues() throws RecognitionException, TokenStreamException {
        log.debug("entered allUserAttributeTypesAndValues()");
        this.match(27);
        this.protectedItemsMap.put("allUserAttributeTypesAndValues", ProtectedItem.ALL_USER_ATTRIBUTE_TYPES_AND_VALUES);
    }

    public final void attributeValue() throws RecognitionException, TokenStreamException {
        Token token = null;
        log.debug("entered attributeValue()");
        String attributeTypeAndValue = null;
        String attributeType = null;
        String attributeValue = null;
        HashSet<Attribute> attributeSet = new HashSet<Attribute>();
        try {
            token = this.LT(1);
            this.match(4);
            LdapDN attributeTypeAndValueSetAsDn = new LdapDN(token.getText());
            if (this.oidsMap != null) {
                attributeTypeAndValueSetAsDn.normalize(this.oidsMap);
            }
            Enumeration<String> attributeTypeAndValueSet = attributeTypeAndValueSetAsDn.getAll();
            while (attributeTypeAndValueSet.hasMoreElements()) {
                attributeTypeAndValue = attributeTypeAndValueSet.nextElement();
                attributeType = NamespaceTools.getRdnAttribute(attributeTypeAndValue);
                attributeValue = NamespaceTools.getRdnValue(attributeTypeAndValue);
                attributeSet.add(new AttributeImpl(attributeType, attributeValue));
                log.debug("An attributeTypeAndValue from the set: " + attributeType + "=" + attributeValue);
            }
            this.protectedItemsMap.put("attributeValue", new ProtectedItem.AttributeValue(attributeSet));
        }
        catch (Exception e) {
            throw new RecognitionException("dnParser failed for " + token.getText() + " , " + e.getMessage());
        }
    }

    public final void selfValue() throws RecognitionException, TokenStreamException {
        log.debug("entered selfValue()");
        Set<String> attributeTypeSet = null;
        this.match(28);
        int _cnt96 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt96 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt96;
        }
        attributeTypeSet = this.attributeTypeSet();
        this.protectedItemsMap.put("sefValue", new ProtectedItem.SelfValue(attributeTypeSet));
    }

    public final void rangeOfValues() throws RecognitionException, TokenStreamException {
        Token token = null;
        log.debug("entered rangeOfValues()");
        try {
            token = this.LT(1);
            this.match(5);
            this.protectedItemsMap.put("rangeOfValues", new ProtectedItem.RangeOfValues(FilterParser.parse(token.getText())));
            log.debug("filterParser parsed " + token.getText());
        }
        catch (Exception e) {
            throw new RecognitionException("filterParser failed. " + e.getMessage());
        }
    }

    public final void maxValueCount() throws RecognitionException, TokenStreamException {
        log.debug("entered maxValueCount()");
        ProtectedItem.MaxValueCountItem maxValueCount = null;
        HashSet<ProtectedItem.MaxValueCountItem> maxValueCountSet = new HashSet<ProtectedItem.MaxValueCountItem>();
        this.match(29);
        int _cnt100 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt100 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt100;
        }
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        maxValueCount = this.aMaxValueCount();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        maxValueCountSet.add(maxValueCount);
        while (this.LA(1) == 8) {
            this.match(8);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            maxValueCount = this.aMaxValueCount();
            while (this.LA(1) == 6) {
                this.match(6);
            }
            maxValueCountSet.add(maxValueCount);
        }
        this.match(9);
        this.protectedItemsMap.put("maxValueCount", new ProtectedItem.MaxValueCount(maxValueCountSet));
    }

    public final void maxImmSub() throws RecognitionException, TokenStreamException {
        Token token = null;
        log.debug("entered maxImmSub()");
        this.match(32);
        int _cnt135 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt135 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt135;
        }
        token = this.LT(1);
        this.match(13);
        this.protectedItemsMap.put("maxImmSub", new ProtectedItem.MaxImmSub(this.token2Integer(token)));
    }

    public final void restrictedBy() throws RecognitionException, TokenStreamException {
        log.debug("entered restrictedBy()");
        ProtectedItem.RestrictedByItem restrictedValue = null;
        HashSet<ProtectedItem.RestrictedByItem> restrictedBy = new HashSet<ProtectedItem.RestrictedByItem>();
        this.match(33);
        int _cnt138 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt138 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt138;
        }
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        restrictedValue = this.restrictedValue();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        restrictedBy.add(restrictedValue);
        while (this.LA(1) == 8) {
            this.match(8);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            restrictedValue = this.restrictedValue();
            while (this.LA(1) == 6) {
                this.match(6);
            }
            restrictedBy.add(restrictedValue);
        }
        this.match(9);
        this.protectedItemsMap.put("restrictedBy", new ProtectedItem.RestrictedBy(restrictedBy));
    }

    public final void classes() throws RecognitionException, TokenStreamException {
        log.debug("entered classes()");
        ExprNode classes = null;
        this.match(35);
        int _cnt184 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt184 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt184;
        }
        classes = this.refinement();
        this.protectedItemsMap.put("classes", new ProtectedItem.Classes(classes));
    }

    public final Set<String> attributeTypeSet() throws RecognitionException, TokenStreamException {
        log.debug("entered attributeTypeSet()");
        String oid = null;
        HashSet<String> attributeTypeSet = new HashSet<String>();
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        oid = this.oid();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        attributeTypeSet.add(oid);
        while (this.LA(1) == 8) {
            this.match(8);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            oid = this.oid();
            while (this.LA(1) == 6) {
                this.match(6);
            }
            attributeTypeSet.add(oid);
        }
        this.match(9);
        return attributeTypeSet;
    }

    public final ProtectedItem.MaxValueCountItem aMaxValueCount() throws RecognitionException, TokenStreamException {
        Token token1 = null;
        Token token2 = null;
        log.debug("entered aMaxValueCount()");
        ProtectedItem.MaxValueCountItem maxValueCount = null;
        String oid = null;
        Token token = null;
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 30: {
                this.match(30);
                int _cnt116 = 0;
                while (true) {
                    if (this.LA(1) != 6) {
                        if (_cnt116 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(6);
                    ++_cnt116;
                }
                oid = this.oid();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.match(8);
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.match(31);
                int _cnt122 = 0;
                while (true) {
                    if (this.LA(1) != 6) {
                        if (_cnt122 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(6);
                    ++_cnt122;
                }
                token1 = this.LT(1);
                this.match(13);
                token = token1;
                break;
            }
            case 31: {
                this.match(31);
                int _cnt124 = 0;
                while (true) {
                    if (this.LA(1) != 6) {
                        if (_cnt124 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(6);
                    ++_cnt124;
                }
                token2 = this.LT(1);
                this.match(13);
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.match(8);
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.match(30);
                int _cnt130 = 0;
                while (true) {
                    if (this.LA(1) != 6) {
                        if (_cnt130 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(6);
                    ++_cnt130;
                }
                oid = this.oid();
                token = token2;
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(9);
        maxValueCount = new ProtectedItem.MaxValueCountItem(oid, this.token2Integer(token));
        return maxValueCount;
    }

    public final String oid() throws RecognitionException, TokenStreamException {
        log.debug("entered oid()");
        String result = null;
        Token token = null;
        token = this.LT(1);
        switch (this.LA(1)) {
            case 77: {
                this.match(77);
                break;
            }
            case 78: {
                this.match(78);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        result = token.getText();
        log.debug("recognized an oid: " + result);
        return result;
    }

    public final ProtectedItem.RestrictedByItem restrictedValue() throws RecognitionException, TokenStreamException {
        log.debug("entered restrictedValue()");
        String typeOid = null;
        String valuesInOid = null;
        ProtectedItem.RestrictedByItem restrictedValue = null;
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 30: {
                this.match(30);
                int _cnt154 = 0;
                while (true) {
                    if (this.LA(1) != 6) {
                        if (_cnt154 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(6);
                    ++_cnt154;
                }
                typeOid = this.oid();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.match(8);
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.match(34);
                int _cnt160 = 0;
                while (true) {
                    if (this.LA(1) != 6) {
                        if (_cnt160 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(6);
                    ++_cnt160;
                }
                valuesInOid = this.oid();
                break;
            }
            case 34: {
                this.match(34);
                int _cnt162 = 0;
                while (true) {
                    if (this.LA(1) != 6) {
                        if (_cnt162 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(6);
                    ++_cnt162;
                }
                valuesInOid = this.oid();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.match(8);
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.match(30);
                int _cnt168 = 0;
                while (true) {
                    if (this.LA(1) != 6) {
                        if (_cnt168 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(6);
                    ++_cnt168;
                }
                typeOid = this.oid();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(9);
        restrictedValue = new ProtectedItem.RestrictedByItem(typeOid, valuesInOid);
        return restrictedValue;
    }

    public final ExprNode refinement() throws RecognitionException, TokenStreamException {
        log.debug("entered refinement()");
        AbstractExprNode node = null;
        switch (this.LA(1)) {
            case 79: {
                node = this.item();
                break;
            }
            case 80: {
                node = this.and();
                break;
            }
            case 81: {
                node = this.or();
                break;
            }
            case 82: {
                node = this.not();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return node;
    }

    public final ItemPermission itemPermission() throws RecognitionException, TokenStreamException {
        log.debug("entered itemPermission()");
        ItemPermission itemPermission = null;
        this.itemPermissionComponentsMonitor = new MandatoryAndOptionalComponentsMonitor(new String[]{"userClasses", "grantsAndDenials"}, new String[]{"precedence"});
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.anyItemPermission();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        while (this.LA(1) == 8) {
            this.match(8);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            this.anyItemPermission();
            while (this.LA(1) == 6) {
                this.match(6);
            }
        }
        this.match(9);
        if (!this.itemPermissionComponentsMonitor.finalStateValid()) {
            throw new RecognitionException("Missing mandatory itemPermission components: " + this.itemPermissionComponentsMonitor.getRemainingComponents());
        }
        itemPermission = new ItemPermission(this.precedence, this.grantsAndDenials, this.userClasses);
        return itemPermission;
    }

    public final void anyItemPermission() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 12: {
                    this.precedence();
                    this.itemPermissionComponentsMonitor.useComponent("precedence");
                    break;
                }
                case 64: {
                    this.userClasses();
                    this.itemPermissionComponentsMonitor.useComponent("userClasses");
                    break;
                }
                case 37: {
                    this.grantsAndDenials();
                    this.itemPermissionComponentsMonitor.useComponent("grantsAndDenials");
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new RecognitionException(e.getMessage());
        }
    }

    public final void grantsAndDenials() throws RecognitionException, TokenStreamException {
        log.debug("entered grantsAndDenials()");
        this.grantsAndDenials = new HashSet<GrantAndDenial>();
        GrantAndDenial grantAndDenial = null;
        this.match(37);
        int _cnt213 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt213 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt213;
        }
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                grantAndDenial = this.grantAndDenial();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                if (!this.grantsAndDenials.add(grantAndDenial)) {
                    throw new RecognitionException("Duplicated GrantAndDenial bit: " + grantAndDenial);
                }
                while (this.LA(1) == 8) {
                    this.match(8);
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    grantAndDenial = this.grantAndDenial();
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    if (this.grantsAndDenials.add(grantAndDenial)) continue;
                    throw new RecognitionException("Duplicated GrantAndDenial bit: " + grantAndDenial);
                }
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(9);
    }

    public final GrantAndDenial grantAndDenial() throws RecognitionException, TokenStreamException {
        log.debug("entered grantAndDenialsBit()");
        GrantAndDenial l_grantAndDenial = null;
        switch (this.LA(1)) {
            case 38: {
                this.match(38);
                l_grantAndDenial = GrantAndDenial.GRANT_ADD;
                break;
            }
            case 39: {
                this.match(39);
                l_grantAndDenial = GrantAndDenial.DENY_ADD;
                break;
            }
            case 40: {
                this.match(40);
                l_grantAndDenial = GrantAndDenial.GRANT_DISCLOSE_ON_ERROR;
                break;
            }
            case 41: {
                this.match(41);
                l_grantAndDenial = GrantAndDenial.DENY_DISCLOSE_ON_ERROR;
                break;
            }
            case 42: {
                this.match(42);
                l_grantAndDenial = GrantAndDenial.GRANT_READ;
                break;
            }
            case 43: {
                this.match(43);
                l_grantAndDenial = GrantAndDenial.DENY_READ;
                break;
            }
            case 44: {
                this.match(44);
                l_grantAndDenial = GrantAndDenial.GRANT_REMOVE;
                break;
            }
            case 45: {
                this.match(45);
                l_grantAndDenial = GrantAndDenial.DENY_REMOVE;
                break;
            }
            case 46: {
                this.match(46);
                l_grantAndDenial = GrantAndDenial.GRANT_BROWSE;
                break;
            }
            case 47: {
                this.match(47);
                l_grantAndDenial = GrantAndDenial.DENY_BROWSE;
                break;
            }
            case 48: {
                this.match(48);
                l_grantAndDenial = GrantAndDenial.GRANT_EXPORT;
                break;
            }
            case 49: {
                this.match(49);
                l_grantAndDenial = GrantAndDenial.DENY_EXPORT;
                break;
            }
            case 50: {
                this.match(50);
                l_grantAndDenial = GrantAndDenial.GRANT_IMPORT;
                break;
            }
            case 51: {
                this.match(51);
                l_grantAndDenial = GrantAndDenial.DENY_IMPORT;
                break;
            }
            case 52: {
                this.match(52);
                l_grantAndDenial = GrantAndDenial.GRANT_MODIFY;
                break;
            }
            case 53: {
                this.match(53);
                l_grantAndDenial = GrantAndDenial.DENY_MODIFY;
                break;
            }
            case 54: {
                this.match(54);
                l_grantAndDenial = GrantAndDenial.GRANT_RENAME;
                break;
            }
            case 55: {
                this.match(55);
                l_grantAndDenial = GrantAndDenial.DENY_RENAME;
                break;
            }
            case 56: {
                this.match(56);
                l_grantAndDenial = GrantAndDenial.GRANT_RETURN_DN;
                break;
            }
            case 57: {
                this.match(57);
                l_grantAndDenial = GrantAndDenial.DENY_RETURN_DN;
                break;
            }
            case 58: {
                this.match(58);
                l_grantAndDenial = GrantAndDenial.GRANT_COMPARE;
                break;
            }
            case 59: {
                this.match(59);
                l_grantAndDenial = GrantAndDenial.DENY_COMPARE;
                break;
            }
            case 60: {
                this.match(60);
                l_grantAndDenial = GrantAndDenial.GRANT_FILTER_MATCH;
                break;
            }
            case 61: {
                this.match(61);
                l_grantAndDenial = GrantAndDenial.DENY_FILTER_MATCH;
                break;
            }
            case 62: {
                this.match(62);
                l_grantAndDenial = GrantAndDenial.GRANT_INVOKE;
                break;
            }
            case 63: {
                this.match(63);
                l_grantAndDenial = GrantAndDenial.DENY_INVOKE;
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return l_grantAndDenial;
    }

    public final void userClass() throws RecognitionException, TokenStreamException {
        log.debug("entered userClasses()");
        switch (this.LA(1)) {
            case 65: {
                this.allUsers();
                break;
            }
            case 66: {
                this.thisEntry();
                break;
            }
            case 67: {
                this.name();
                break;
            }
            case 68: {
                this.userGroup();
                break;
            }
            case 69: {
                this.subtree();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void allUsers() throws RecognitionException, TokenStreamException {
        log.debug("entered allUsers()");
        this.match(65);
        this.userClassesMap.put("allUsers", UserClass.ALL_USERS);
    }

    public final void thisEntry() throws RecognitionException, TokenStreamException {
        log.debug("entered thisEntry()");
        this.match(66);
        this.userClassesMap.put("thisEntry", UserClass.THIS_ENTRY);
    }

    public final void name() throws RecognitionException, TokenStreamException {
        log.debug("entered name()");
        HashSet<LdapDN> names = new HashSet<LdapDN>();
        LdapDN distinguishedName = null;
        this.match(67);
        int _cnt245 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt245 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt245;
        }
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        distinguishedName = this.distinguishedName();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        names.add(distinguishedName);
        while (this.LA(1) == 8) {
            this.match(8);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            distinguishedName = this.distinguishedName();
            while (this.LA(1) == 6) {
                this.match(6);
            }
            names.add(distinguishedName);
        }
        this.match(9);
        this.userClassesMap.put("name", new UserClass.Name(names));
    }

    public final void userGroup() throws RecognitionException, TokenStreamException {
        log.debug("entered userGroup()");
        HashSet<LdapDN> userGroup = new HashSet<LdapDN>();
        LdapDN distinguishedName = null;
        this.match(68);
        int _cnt258 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt258 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt258;
        }
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        distinguishedName = this.distinguishedName();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        userGroup.add(distinguishedName);
        while (this.LA(1) == 8) {
            this.match(8);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            distinguishedName = this.distinguishedName();
            while (this.LA(1) == 6) {
                this.match(6);
            }
            userGroup.add(distinguishedName);
        }
        this.match(9);
        this.userClassesMap.put("userGroup", new UserClass.UserGroup(userGroup));
    }

    public final void subtree() throws RecognitionException, TokenStreamException {
        log.debug("entered subtree()");
        HashSet<SubtreeSpecification> subtrees = new HashSet<SubtreeSpecification>();
        SubtreeSpecification subtreeSpecification = null;
        this.match(69);
        int _cnt271 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt271 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt271;
        }
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        subtreeSpecification = this.subtreeSpecification();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        subtrees.add(subtreeSpecification);
        while (this.LA(1) == 8) {
            this.match(8);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            subtreeSpecification = this.subtreeSpecification();
            while (this.LA(1) == 6) {
                this.match(6);
            }
            subtrees.add(subtreeSpecification);
        }
        this.match(9);
        this.userClassesMap.put("subtree", new UserClass.Subtree(subtrees));
    }

    public final LdapDN distinguishedName() throws RecognitionException, TokenStreamException {
        Token token = null;
        log.debug("entered distinguishedName()");
        LdapDN name = null;
        try {
            token = this.LT(1);
            this.match(11);
            name = new LdapDN(token.getText());
            if (this.oidsMap != null) {
                name.normalize(this.oidsMap);
            }
            log.debug("recognized a DistinguishedName: " + token.getText());
        }
        catch (Exception e) {
            throw new RecognitionException("dnParser failed for " + token.getText() + " " + e.getMessage());
        }
        return name;
    }

    public final SubtreeSpecification subtreeSpecification() throws RecognitionException, TokenStreamException {
        log.debug("entered subtreeSpecification()");
        SubtreeSpecification ss = null;
        this.ssModifier = new SubtreeSpecificationModifier();
        this.chopBeforeExclusions = new HashSet<LdapDN>();
        this.chopAfterExclusions = new HashSet<LdapDN>();
        this.subtreeSpecificationComponentsMonitor = new OptionalComponentsMonitor(new String[]{"base", "specificExclusions", "minimum", "maximum"});
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 71: 
            case 72: 
            case 75: 
            case 76: {
                this.subtreeSpecificationComponent();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                while (this.LA(1) == 8) {
                    this.match(8);
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    this.subtreeSpecificationComponent();
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                }
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(9);
        ss = this.ssModifier.getSubtreeSpecification();
        return ss;
    }

    public final UserPermission userPermission() throws RecognitionException, TokenStreamException {
        log.debug("entered userPermission()");
        UserPermission userPermission = null;
        this.userPermissionComponentsMonitor = new MandatoryAndOptionalComponentsMonitor(new String[]{"protectedItems", "grantsAndDenials"}, new String[]{"precedence"});
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.anyUserPermission();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        while (this.LA(1) == 8) {
            this.match(8);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            this.anyUserPermission();
            while (this.LA(1) == 6) {
                this.match(6);
            }
        }
        this.match(9);
        if (!this.userPermissionComponentsMonitor.finalStateValid()) {
            throw new RecognitionException("Missing mandatory userPermission components: " + this.userPermissionComponentsMonitor.getRemainingComponents());
        }
        userPermission = new UserPermission(this.aciPrecedence, this.grantsAndDenials, this.protectedItems);
        return userPermission;
    }

    public final void anyUserPermission() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 12: {
                    this.precedence();
                    this.userPermissionComponentsMonitor.useComponent("precedence");
                    break;
                }
                case 22: {
                    this.protectedItems();
                    this.userPermissionComponentsMonitor.useComponent("protectedItems");
                    break;
                }
                case 37: {
                    this.grantsAndDenials();
                    this.userPermissionComponentsMonitor.useComponent("grantsAndDenials");
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new RecognitionException(e.getMessage());
        }
    }

    public final void subtreeSpecificationComponent() throws RecognitionException, TokenStreamException {
        log.debug("entered subtreeSpecification()");
        try {
            switch (this.LA(1)) {
                case 71: {
                    this.ss_base();
                    this.subtreeSpecificationComponentsMonitor.useComponent("base");
                    break;
                }
                case 72: {
                    this.ss_specificExclusions();
                    this.subtreeSpecificationComponentsMonitor.useComponent("specificExclusions");
                    break;
                }
                case 75: {
                    this.ss_minimum();
                    this.subtreeSpecificationComponentsMonitor.useComponent("minimum");
                    break;
                }
                case 76: {
                    this.ss_maximum();
                    this.subtreeSpecificationComponentsMonitor.useComponent("maximum");
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new RecognitionException(e.getMessage());
        }
    }

    public final void ss_base() throws RecognitionException, TokenStreamException {
        log.debug("entered ss_base()");
        LdapDN base = null;
        this.match(71);
        int _cnt323 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt323 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt323;
        }
        base = this.distinguishedName();
        this.ssModifier.setBase(base);
    }

    public final void ss_specificExclusions() throws RecognitionException, TokenStreamException {
        log.debug("entered ss_specificExclusions()");
        this.match(72);
        int _cnt326 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt326 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt326;
        }
        this.specificExclusions();
        this.ssModifier.setChopBeforeExclusions(this.chopBeforeExclusions);
        this.ssModifier.setChopAfterExclusions(this.chopAfterExclusions);
    }

    public final void ss_minimum() throws RecognitionException, TokenStreamException {
        log.debug("entered ss_minimum()");
        int minimum = 0;
        this.match(75);
        int _cnt352 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt352 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt352;
        }
        minimum = this.baseDistance();
        this.ssModifier.setMinBaseDistance(minimum);
    }

    public final void ss_maximum() throws RecognitionException, TokenStreamException {
        log.debug("entered ss_maximum()");
        int maximum = 0;
        this.match(76);
        int _cnt355 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt355 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt355;
        }
        maximum = this.baseDistance();
        this.ssModifier.setMaxBaseDistance(maximum);
    }

    public final void specificExclusions() throws RecognitionException, TokenStreamException {
        log.debug("entered specificExclusions()");
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 73: 
            case 74: {
                this.specificExclusion();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                while (this.LA(1) == 8) {
                    this.match(8);
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    this.specificExclusion();
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                }
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(9);
    }

    public final void specificExclusion() throws RecognitionException, TokenStreamException {
        log.debug("entered specificExclusion()");
        switch (this.LA(1)) {
            case 73: {
                this.chopBefore();
                break;
            }
            case 74: {
                this.chopAfter();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void chopBefore() throws RecognitionException, TokenStreamException {
        log.debug("entered chopBefore()");
        LdapDN chopBeforeExclusion = null;
        this.match(73);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(20);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        chopBeforeExclusion = this.distinguishedName();
        this.chopBeforeExclusions.add(chopBeforeExclusion);
    }

    public final void chopAfter() throws RecognitionException, TokenStreamException {
        log.debug("entered chopAfter()");
        LdapDN chopAfterExclusion = null;
        this.match(74);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(20);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        chopAfterExclusion = this.distinguishedName();
        this.chopAfterExclusions.add(chopAfterExclusion);
    }

    public final int baseDistance() throws RecognitionException, TokenStreamException {
        Token token = null;
        log.debug("entered baseDistance()");
        int distance = 0;
        token = this.LT(1);
        this.match(13);
        distance = this.token2Integer(token);
        return distance;
    }

    public final LeafNode item() throws RecognitionException, TokenStreamException {
        log.debug("entered item()");
        EqualityNode node = null;
        String oid = null;
        this.match(79);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(20);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        oid = this.oid();
        node = new EqualityNode("objectClass", oid);
        return node;
    }

    public final BranchNode and() throws RecognitionException, TokenStreamException {
        log.debug("entered and()");
        AndNode node = null;
        List<ExprNode> children = null;
        this.match(80);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(20);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        children = this.refinements();
        node = new AndNode(children);
        return node;
    }

    public final BranchNode or() throws RecognitionException, TokenStreamException {
        log.debug("entered or()");
        OrNode node = null;
        List<ExprNode> children = null;
        this.match(81);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(20);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        children = this.refinements();
        node = new OrNode(children);
        return node;
    }

    public final BranchNode not() throws RecognitionException, TokenStreamException {
        log.debug("entered not()");
        NotNode node = null;
        List<ExprNode> children = null;
        this.match(82);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(20);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        children = this.refinements();
        node = new NotNode(children);
        return node;
    }

    public final List<ExprNode> refinements() throws RecognitionException, TokenStreamException {
        log.debug("entered refinements()");
        ArrayList<ExprNode> children = null;
        ExprNode child = null;
        ArrayList<ExprNode> tempChildren = new ArrayList<ExprNode>();
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                child = this.refinement();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                tempChildren.add(child);
                while (this.LA(1) == 8) {
                    this.match(8);
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    child = this.refinement();
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    tempChildren.add(child);
                }
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(9);
        children = tempChildren;
        return children;
    }
}

