/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import org.apache.directory.shared.ldap.filter.AbstractExprNode;
import org.apache.directory.shared.ldap.filter.FilterVisitor;
import org.apache.directory.shared.ldap.message.AliasDerefMode;

public class ScopeNode
extends AbstractExprNode {
    private final int scope;
    private final String baseDn;
    private final AliasDerefMode aliasDerefAliases;

    public ScopeNode(AliasDerefMode aliasDerefAliases, String baseDn, int scope) {
        this.scope = scope;
        this.baseDn = baseDn;
        this.aliasDerefAliases = aliasDerefAliases;
    }

    public boolean isLeaf() {
        return true;
    }

    public int getScope() {
        return this.scope;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public AliasDerefMode getDerefAliases() {
        return this.aliasDerefAliases;
    }

    public StringBuilder printRefinementToBuffer(StringBuilder buf) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ScopeNode can't be part of a refinement");
    }

    public Object accept(FilterVisitor visitor) {
        if (visitor.canVisit(this)) {
            return visitor.visit(this);
        }
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(#{");
        switch (this.scope) {
            case 0: {
                buf.append("OBJECT_SCOPE");
                break;
            }
            case 1: {
                buf.append("ONE_LEVEL_SCOPE");
                break;
            }
            case 2: {
                buf.append("SUBTREE_SCOPE (Estimated)");
                break;
            }
            default: {
                buf.append("UNKNOWN");
            }
        }
        buf.append(", '");
        buf.append(this.baseDn);
        buf.append("', ");
        buf.append((Object)this.aliasDerefAliases);
        buf.append("}");
        buf.append(super.toString());
        buf.append(')');
        return buf.toString();
    }
}

