/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.util.StringTools;

public class ExtensibleNode
extends LeafNode {
    private byte[] value;
    private String matchingRuleId;
    private boolean dnAttributes = false;

    public ExtensibleNode(String attribute) {
        super(attribute);
        this.dnAttributes = false;
    }

    public ExtensibleNode(String attribute, String value, String matchingRuleId, boolean dnAttributes) {
        this(attribute, StringTools.getBytesUtf8(value), matchingRuleId, dnAttributes);
    }

    public ExtensibleNode(String attribute, byte[] value, String matchingRuleId, boolean dnAttributes) {
        super(attribute);
        if (value != null) {
            this.value = new byte[value.length];
            System.arraycopy(value, 0, this.value, 0, value.length);
        } else {
            this.value = null;
        }
        this.matchingRuleId = matchingRuleId;
        this.dnAttributes = dnAttributes;
    }

    public boolean hasDnAttributes() {
        return this.dnAttributes;
    }

    public void setDnAttributes(boolean dnAttributes) {
        this.dnAttributes = dnAttributes;
    }

    public String getMatchingRuleId() {
        return this.matchingRuleId;
    }

    public void setMatchingRuleId(String matchingRuleId) {
        this.matchingRuleId = matchingRuleId;
    }

    public final byte[] getValue() {
        if (this.value == null) {
            return null;
        }
        byte[] copy = new byte[this.value.length];
        System.arraycopy(this.value, 0, copy, 0, this.value.length);
        return copy;
    }

    public final void setValue(String value) {
        this.value = StringTools.getBytesUtf8(value);
    }

    public StringBuilder printRefinementToBuffer(StringBuilder buf) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ExtensibleNode can't be part of a refinement");
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('(').append(this.getAttribute());
        buf.append("-");
        buf.append(this.dnAttributes);
        buf.append("-EXTENSIBLE-");
        buf.append(this.matchingRuleId);
        buf.append("-");
        buf.append(StringTools.utf8ToString(this.value));
        buf.append("/");
        buf.append(StringTools.dumpBytes(this.value));
        buf.append(super.toString());
        buf.append(')');
        return buf.toString();
    }
}

