/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import org.apache.directory.shared.ldap.filter.AssertionEnum;
import org.apache.directory.shared.ldap.filter.FilterVisitor;
import org.apache.directory.shared.ldap.filter.LeafNode;

public final class PresenceNode
extends LeafNode {
    public PresenceNode(String attribute) {
        super(attribute, AssertionEnum.PRESENCE);
    }

    public StringBuffer printToBuffer(StringBuffer buf) {
        buf.append('(').append(this.getAttribute()).append("=*");
        buf.append(')');
        if (null != this.getAnnotations() && this.getAnnotations().containsKey("count")) {
            buf.append('[');
            buf.append(this.getAnnotations().get("count").toString());
            buf.append("] ");
        } else {
            buf.append(' ');
        }
        return buf;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.printToBuffer(buf);
        return buf.toString();
    }

    public StringBuffer printRefinementToBuffer(StringBuffer a_buf) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("PresenceNode can't be part of a refinement");
    }

    public void accept(FilterVisitor visitor) {
        if (visitor.canVisit(this)) {
            visitor.visit(this);
        }
    }
}

