/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.InvalidNameException;
import javax.naming.directory.Attributes;
import org.apache.commons.collections.MultiHashMap;
import org.apache.directory.shared.ldap.message.LockableAttributeImpl;
import org.apache.directory.shared.ldap.message.LockableAttributesImpl;
import org.apache.directory.shared.ldap.name.AttributeTypeAndValue;
import org.apache.directory.shared.ldap.name.RdnParser;
import org.apache.directory.shared.ldap.util.StringTools;

public class Rdn
implements Cloneable,
Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String upName = null;
    private String normName = null;
    private int start;
    private int length;
    private Set atavs = null;
    private Map atavTypes = new MultiHashMap();
    private String atavType = null;
    private AttributeTypeAndValue atav = null;
    private int nbAtavs = 0;
    public static final int UNDEFINED = Integer.MAX_VALUE;
    public static final int SUPERIOR = 1;
    public static final int INFERIOR = -1;
    public static final int EQUALS = 0;

    public Rdn() {
        this.upName = "";
        this.normName = "";
    }

    public Rdn(String rdn) throws InvalidNameException {
        this.start = 0;
        if (StringTools.isNotEmpty(rdn)) {
            RdnParser.parse(rdn, this);
            this.normalize();
            this.upName = rdn;
            this.length = rdn.length();
        } else {
            this.upName = "";
            this.normName = "";
            this.length = 0;
        }
    }

    public Rdn(String type, String value) throws InvalidNameException {
        this.addAttributeTypeAndValue(type, value);
        this.upName = type + '=' + value;
        this.start = 0;
        this.length = this.upName.length();
        this.normalize();
    }

    public Rdn(Rdn rdn) {
        this.nbAtavs = rdn.getNbAtavs();
        this.normName = new String(rdn.normName);
        this.upName = new String(rdn.getUpName());
        this.start = rdn.start;
        this.length = rdn.length;
        switch (rdn.getNbAtavs()) {
            case 0: {
                return;
            }
            case 1: {
                this.atav = (AttributeTypeAndValue)rdn.atav.clone();
                return;
            }
        }
        Iterator iter = rdn.atavs.iterator();
        this.atavs = new TreeSet();
        this.atavTypes = new MultiHashMap();
        while (iter.hasNext()) {
            AttributeTypeAndValue currentAtav = (AttributeTypeAndValue)iter.next();
            this.atavs.add((AttributeTypeAndValue)currentAtav.clone());
            this.atavTypes.put(currentAtav.getUpType(), currentAtav);
        }
    }

    void normalize() {
        switch (this.nbAtavs) {
            case 0: {
                this.normName = "";
                break;
            }
            case 1: {
                if (this.atav.getValue() instanceof String) {
                    this.normName = this.atav.getNormalizedValue();
                    break;
                }
                this.normName = this.atav.getNormType() + "=#" + StringTools.dumpHexPairs((byte[])this.atav.getValue());
                break;
            }
            default: {
                StringBuffer sb = new StringBuffer();
                boolean isFirst = true;
                Iterator ataIter = this.atavs.iterator();
                while (ataIter.hasNext()) {
                    AttributeTypeAndValue ata = (AttributeTypeAndValue)ataIter.next();
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append('+');
                    }
                    sb.append(ata.normalize());
                }
                this.normName = sb.toString();
            }
        }
    }

    void addAttributeTypeAndValue(String type, Object value) throws InvalidNameException {
        String normalizedType = type.toLowerCase();
        Object normalizedValue = value;
        switch (this.nbAtavs) {
            case 0: {
                this.atav = new AttributeTypeAndValue(type, value);
                this.nbAtavs = 1;
                this.atavType = normalizedType;
                return;
            }
            case 1: {
                this.atavs = new TreeSet();
                this.atavs.add(this.atav);
                this.atavTypes = new MultiHashMap();
                this.atavTypes.put(this.atavType, this.atav);
                this.atav = null;
            }
        }
        AttributeTypeAndValue newAtav = new AttributeTypeAndValue(type, value);
        this.atavs.add(newAtav);
        this.atavTypes.put(normalizedType, newAtav);
        ++this.nbAtavs;
    }

    public void clear() {
        this.atav = null;
        this.atavs = null;
        this.atavType = null;
        this.atavTypes.clear();
        this.nbAtavs = 0;
        this.normName = "";
        this.upName = "";
        this.start = -1;
        this.length = 0;
    }

    public Object getValue(String type) throws InvalidNameException {
        String normalizedType = StringTools.lowerCase(StringTools.trim(type));
        switch (this.nbAtavs) {
            case 0: {
                return "";
            }
            case 1: {
                if (StringTools.equals(this.atav.getNormType(), normalizedType)) {
                    return this.atav.getValue();
                }
                return "";
            }
        }
        if (this.atavTypes.containsKey(normalizedType)) {
            Object obj = this.atavTypes.get(normalizedType);
            if (obj instanceof AttributeTypeAndValue) {
                return ((AttributeTypeAndValue)obj).getValue();
            }
            if (obj instanceof List) {
                StringBuffer sb = new StringBuffer();
                boolean isFirst = true;
                for (int i = 0; i < ((List)obj).size(); ++i) {
                    AttributeTypeAndValue elem = (AttributeTypeAndValue)((List)obj).get(i);
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append(elem.getValue());
                }
                return sb.toString();
            }
            throw new InvalidNameException("Bad object stored in the RDN");
        }
        return "";
    }

    public AttributeTypeAndValue getAttributeTypeAndValue(String type) {
        String normalizedType = StringTools.lowerCase(StringTools.trim(type));
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.atav.getNormType().equals(normalizedType)) {
                    return this.atav;
                }
                return null;
            }
        }
        if (this.atavTypes.containsKey(normalizedType)) {
            return (AttributeTypeAndValue)this.atavTypes.get(normalizedType);
        }
        return null;
    }

    public Iterator iterator() {
        if (this.nbAtavs == 1) {
            return new Iterator(){
                private boolean hasMoreElement = true;

                public boolean hasNext() {
                    return this.hasMoreElement;
                }

                public Object next() {
                    AttributeTypeAndValue obj = Rdn.this.atav;
                    this.hasMoreElement = false;
                    return obj;
                }

                public void remove() {
                }
            };
        }
        return this.atavs.iterator();
    }

    public Object clone() {
        try {
            Rdn rdn = (Rdn)super.clone();
            switch (rdn.getNbAtavs()) {
                case 0: {
                    break;
                }
                case 1: {
                    rdn.atav = (AttributeTypeAndValue)this.atav.clone();
                    rdn.atavTypes = this.atavTypes;
                    break;
                }
                default: {
                    rdn.atavTypes = new MultiHashMap();
                    rdn.atavs = new TreeSet();
                    Iterator ataIter = this.atavs.iterator();
                    while (ataIter.hasNext()) {
                        AttributeTypeAndValue currentAtav = (AttributeTypeAndValue)ataIter.next();
                        rdn.atavs.add((AttributeTypeAndValue)currentAtav.clone());
                        rdn.atavTypes.put(currentAtav.getUpType(), currentAtav);
                    }
                    break block1;
                }
            }
            return rdn;
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error("Assertion failure");
        }
    }

    public int compareTo(Object object) {
        if (object instanceof Rdn) {
            Rdn rdn = (Rdn)object;
            if (rdn == null) {
                return 1;
            }
            if (rdn.nbAtavs != this.nbAtavs) {
                return this.nbAtavs - rdn.nbAtavs;
            }
            switch (this.nbAtavs) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return this.atav.compareTo(rdn.atav);
                }
            }
            Iterator ataIter = this.atavs.iterator();
            if (ataIter.hasNext()) {
                AttributeTypeAndValue current = (AttributeTypeAndValue)ataIter.next();
                String type = current.getUpType();
                if (rdn.atavTypes.containsKey(type)) {
                    List atavLocalList = (List)this.atavTypes.get(type);
                    List atavParamList = (List)rdn.atavTypes.get(type);
                    if (atavLocalList.size() == 1) {
                        AttributeTypeAndValue atavLocal = (AttributeTypeAndValue)atavLocalList.get(0);
                        AttributeTypeAndValue atavParam = (AttributeTypeAndValue)atavParamList.get(0);
                        return atavLocal.compareTo(atavParam);
                    }
                    Iterator atavLocals = atavLocalList.iterator();
                    while (atavLocals.hasNext()) {
                        AttributeTypeAndValue atavLocal = (AttributeTypeAndValue)atavLocals.next();
                        Iterator atavParams = atavParamList.iterator();
                        boolean found = false;
                        while (atavParams.hasNext()) {
                            AttributeTypeAndValue atavParam = (AttributeTypeAndValue)atavParams.next();
                            if (atavLocal.compareTo(atavParam) != 0) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        return 1;
                    }
                    return 0;
                }
                return 1;
            }
            return 0;
        }
        return object != null ? Integer.MAX_VALUE : 1;
    }

    public String toString() {
        return this.normName == null ? "" : this.normName;
    }

    public String getUpName() {
        return this.upName;
    }

    public void setUpName(String upName) {
        this.upName = upName;
    }

    public int getNbAtavs() {
        return this.nbAtavs;
    }

    public AttributeTypeAndValue getAtav() {
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                return this.atav;
            }
        }
        return (AttributeTypeAndValue)((TreeSet)this.atavs).first();
    }

    public String getUpType() {
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                return this.atav.getUpType();
            }
        }
        return ((AttributeTypeAndValue)((TreeSet)this.atavs).first()).getUpType();
    }

    public String getNormType() {
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                return this.atav.getNormType();
            }
        }
        return ((AttributeTypeAndValue)((TreeSet)this.atavs).first()).getNormType();
    }

    public Object getValue() {
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                return this.atav.getValue();
            }
        }
        return ((AttributeTypeAndValue)((TreeSet)this.atavs).first()).getValue();
    }

    public boolean equals(Object rdn) {
        if (this == rdn) {
            return true;
        }
        if (!(rdn instanceof Rdn)) {
            return false;
        }
        return this.compareTo((Rdn)rdn) == 0;
    }

    public int size() {
        return this.nbAtavs;
    }

    public Attributes toAttributes() {
        LockableAttributesImpl attributes = new LockableAttributesImpl(true);
        LockableAttributeImpl attribute = null;
        switch (this.nbAtavs) {
            case 0: {
                break;
            }
            case 1: {
                attribute = new LockableAttributeImpl(this.atavType);
                attribute.add(this.atav.getValue());
                attributes.put(attribute);
                break;
            }
            default: {
                Iterator types = this.atavTypes.keySet().iterator();
                while (types.hasNext()) {
                    String type = (String)types.next();
                    List values = (List)this.atavTypes.get(type);
                    attribute = new LockableAttributeImpl(type);
                    Iterator iterValues = values.iterator();
                    while (iterValues.hasNext()) {
                        AttributeTypeAndValue value = (AttributeTypeAndValue)iterValues.next();
                        attribute.add(value.getValue());
                    }
                    attributes.put(attribute);
                }
                break block0;
            }
        }
        return attributes;
    }

    public static Object unescapeValue(String value) throws IllegalArgumentException {
        if (StringTools.isEmpty(value)) {
            return "";
        }
        char[] chars = value.toCharArray();
        if (chars[0] == '#') {
            if (chars.length == 1) {
                return StringTools.EMPTY_BYTES;
            }
            if (chars.length % 2 != 1) {
                throw new IllegalArgumentException("This value is not in hex form, we have an odd number of hex chars");
            }
            byte[] hexValue = new byte[(chars.length - 1) / 2];
            int pos = 0;
            for (int i = 1; i < chars.length; i += 2) {
                if (!StringTools.isHex(chars, i) || !StringTools.isHex(chars, i + 1)) {
                    throw new IllegalArgumentException("This value is not in hex form");
                }
                hexValue[pos++] = (byte)((StringTools.HEX_VALUE[chars[i]] << 4) + StringTools.HEX_VALUE[chars[i + 1]]);
            }
            return hexValue;
        }
        boolean escaped = false;
        boolean isHex = false;
        int pair = -1;
        int pos = 0;
        byte[] bytes = new byte[chars.length * 6];
        block8: for (int i = 0; i < chars.length; ++i) {
            if (escaped) {
                escaped = false;
                switch (chars[i]) {
                    case ' ': 
                    case '\"': 
                    case '#': 
                    case '+': 
                    case ',': 
                    case ';': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '\\': {
                        bytes[pos++] = (byte)chars[i];
                        break;
                    }
                    default: {
                        if (!StringTools.isHex(chars, i)) continue block8;
                        isHex = true;
                        pair = (byte)(StringTools.HEX_VALUE[chars[i]] << 4);
                        break;
                    }
                }
                continue;
            }
            if (isHex) {
                if (!StringTools.isHex(chars, i)) continue;
                pair = (byte)(pair + StringTools.HEX_VALUE[chars[i]]);
                bytes[pos++] = pair;
                continue;
            }
            switch (chars[i]) {
                case '\\': {
                    escaped = true;
                    continue block8;
                }
                case ' ': 
                case '\"': 
                case '#': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': {
                    throw new IllegalArgumentException("Unescaped special characters are not allowed");
                }
                default: {
                    byte[] result = StringTools.charToBytes(chars[i]);
                    for (int j = 0; j < result.length; ++j) {
                        bytes[pos++] = result[j];
                    }
                }
            }
        }
        return StringTools.utf8ToString(bytes, pos);
    }

    public static String escapeValue(Object attrValue) {
        if (StringTools.isEmpty((byte[])attrValue)) {
            return "";
        }
        String value = StringTools.utf8ToString((byte[])attrValue);
        char[] chars = value.toCharArray();
        char[] newChars = new char[chars.length * 3];
        int pos = 0;
        block6: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case ' ': 
                case '\"': 
                case '#': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '\\': {
                    newChars[pos++] = 92;
                    newChars[pos++] = chars[i];
                    continue block6;
                }
                case '\u007f': {
                    newChars[pos++] = 92;
                    newChars[pos++] = 55;
                    newChars[pos++] = 70;
                    continue block6;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': {
                    newChars[pos++] = 92;
                    newChars[pos++] = 48;
                    newChars[pos++] = StringTools.dumpHex((byte)(chars[i] & 0xF));
                    continue block6;
                }
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    newChars[pos++] = 92;
                    newChars[pos++] = 49;
                    newChars[pos++] = StringTools.dumpHex((byte)(chars[i] & 0xF));
                    continue block6;
                }
                default: {
                    newChars[pos++] = chars[i];
                }
            }
        }
        return new String(newChars, 0, pos);
    }

    public int hashCode() {
        int result = 17;
        switch (this.nbAtavs) {
            case 0: {
                break;
            }
            case 1: {
                result = result * 37 + this.atav.hashCode();
                break;
            }
            default: {
                Iterator ataIter = this.atavs.iterator();
                while (ataIter.hasNext()) {
                    AttributeTypeAndValue ata = (AttributeTypeAndValue)ataIter.next();
                    result = result * 37 + ata.hashCode();
                }
                break block0;
            }
        }
        return result;
    }
}

