/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.add;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.message.LockableAttributeImpl;
import org.apache.directory.shared.ldap.message.LockableAttributesImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddRequest
extends LdapMessage {
    private static final transient Logger log = LoggerFactory.getLogger((Class)AddRequest.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private LdapDN entry;
    private Attributes attributes;
    private transient Attribute currentAttribute;
    private transient int addRequestLength;
    private transient int attributesLength;
    private transient List attributeLength;
    private transient List valuesLength;

    public int getMessageType() {
        return 1;
    }

    public void initAttributes() {
        this.attributes = new LockableAttributesImpl(true);
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void addAttributeType(String type) {
        if (this.attributes.get(type.toLowerCase()) != null) {
            this.currentAttribute = this.attributes.get(type.toLowerCase());
            return;
        }
        this.currentAttribute = new LockableAttributeImpl(type.toLowerCase());
        this.attributes.put(this.currentAttribute);
    }

    public void addAttributeValue(Object value) {
        this.currentAttribute.add(value);
    }

    public LdapDN getEntry() {
        return this.entry;
    }

    public void setEntry(LdapDN entry) {
        this.entry = entry;
    }

    public int computeLength() {
        this.addRequestLength = 1 + TLV.getNbBytes((int)LdapDN.getNbBytes(this.entry)) + LdapDN.getNbBytes(this.entry);
        this.attributesLength = 0;
        if (this.attributes != null && this.attributes.size() != 0) {
            NamingEnumeration<? extends Attribute> attributeIterator = this.attributes.getAll();
            this.attributeLength = new LinkedList();
            this.valuesLength = new LinkedList();
            while (attributeIterator.hasMoreElements()) {
                Attribute attribute = (Attribute)attributeIterator.nextElement();
                int localAttributeLength = 0;
                int localValuesLength = 0;
                int idLength = attribute.getID().getBytes().length;
                localAttributeLength = 1 + TLV.getNbBytes((int)idLength) + idLength;
                try {
                    NamingEnumeration<?> values = attribute.getAll();
                    if (values.hasMoreElements()) {
                        localValuesLength = 0;
                        while (values.hasMoreElements()) {
                            int valueLength;
                            Object value = values.next();
                            if (value instanceof String) {
                                valueLength = StringTools.getBytesUtf8((String)value).length;
                                localValuesLength += 1 + TLV.getNbBytes((int)valueLength) + valueLength;
                                continue;
                            }
                            valueLength = ((byte[])value).length;
                            localValuesLength += 1 + TLV.getNbBytes((int)valueLength) + valueLength;
                        }
                        localAttributeLength += 1 + TLV.getNbBytes((int)localValuesLength) + localValuesLength;
                    }
                }
                catch (NamingException ne) {
                    return 0;
                }
                this.attributesLength += 1 + TLV.getNbBytes((int)localAttributeLength) + localAttributeLength;
                this.attributeLength.add(new Integer(localAttributeLength));
                this.valuesLength.add(new Integer(localValuesLength));
            }
        }
        this.addRequestLength += 1 + TLV.getNbBytes((int)this.attributesLength) + this.attributesLength;
        int result = 1 + TLV.getNbBytes((int)this.addRequestLength) + this.addRequestLength;
        if (IS_DEBUG) {
            log.debug("AddRequest PDU length = {}", (Object)new Integer(result));
        }
        return result;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        block10: {
            if (buffer == null) {
                throw new EncoderException("Cannot put a PDU in a null buffer !");
            }
            try {
                buffer.put((byte)104);
                buffer.put(TLV.getBytes((int)this.addRequestLength));
                Value.encode((ByteBuffer)buffer, (byte[])LdapDN.getBytes(this.entry));
                buffer.put((byte)48);
                buffer.put(TLV.getBytes((int)this.attributesLength));
                if (this.attributes == null || this.attributes.size() == 0) break block10;
                NamingEnumeration<? extends Attribute> attributeIterator = this.attributes.getAll();
                int attributeNumber = 0;
                while (attributeIterator.hasMoreElements()) {
                    Attribute attribute = (Attribute)attributeIterator.nextElement();
                    buffer.put((byte)48);
                    int localAttributeLength = (Integer)this.attributeLength.get(attributeNumber);
                    buffer.put(TLV.getBytes((int)localAttributeLength));
                    Value.encode((ByteBuffer)buffer, (String)attribute.getID());
                    buffer.put((byte)49);
                    int localValuesLength = (Integer)this.valuesLength.get(attributeNumber);
                    buffer.put(TLV.getBytes((int)localValuesLength));
                    try {
                        NamingEnumeration<?> values = attribute.getAll();
                        if (values.hasMoreElements()) {
                            while (values.hasMoreElements()) {
                                Object value = values.next();
                                if (value instanceof byte[]) {
                                    Value.encode((ByteBuffer)buffer, (byte[])((byte[])value));
                                    continue;
                                }
                                Value.encode((ByteBuffer)buffer, (String)((String)value));
                            }
                        }
                    }
                    catch (NamingException ne) {
                        throw new EncoderException("Cannot enumerate the values");
                    }
                    ++attributeNumber;
                }
            }
            catch (BufferOverflowException boe) {
                throw new EncoderException("The PDU buffer size is too small !");
            }
        }
        if (IS_DEBUG) {
            log.debug("AddRequest encoding : {}", (Object)StringTools.dumpBytes(buffer.array()));
            log.debug("AddRequest initial value : {}", (Object)this.toString());
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Add Request\n");
        sb.append("        Entry : '").append(this.entry).append("'\n");
        sb.append("        Attributes\n");
        if (this.attributes == null || this.attributes.size() == 0) {
            sb.append("            No attributes\n");
        } else {
            sb.append(AttributeUtils.toString("            ", this.attributes));
        }
        return sb.toString();
    }

    public String getCurrentAttributeType() {
        return this.currentAttribute.getID();
    }
}

