/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.directory.shared.ldap.util.ClassUtils;

public abstract class Enum
implements Comparable,
Serializable {
    private static final long serialVersionUID = -487045951170455942L;
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap(0));
    private static final Map cEnumClasses = new HashMap();
    private final String iName;
    private final transient int iHashCode;
    protected transient String iToString = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected Enum(String name) {
        this.init(name);
        this.iName = name;
        this.iHashCode = 7 + this.getEnumClass().hashCode() + 3 * name.hashCode();
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init(String name) {
        Class<?> clazz;
        if (Enum.isEmpty(name)) {
            throw new IllegalArgumentException("The Enum name must not be empty or null");
        }
        Class enumClass = this.getEnumClass();
        if (enumClass == null) {
            throw new IllegalArgumentException("getEnumClass() must not be null");
        }
        Class<?> cls = this.getClass();
        boolean ok = false;
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                if (cls == enumClass) {
                    ok = true;
                    break;
                }
                cls = cls.getSuperclass();
            }
            if (cls == null) break;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.apache.directory.shared.ldap.util.Enum");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (cls == clazz2) break;
            clazz = class$1;
            if (clazz != null) continue;
            try {
                clazz = Class.forName("org.apache.directory.shared.ldap.util.ValuedEnum");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (cls != clazz);
        if (!ok) {
            throw new IllegalArgumentException("getEnumClass() must return a superclass of this class");
        }
        Entry entry = (Entry)cEnumClasses.get(enumClass);
        if (entry == null) {
            entry = Enum.createEntry(enumClass);
            cEnumClasses.put(enumClass, entry);
        }
        if (entry.map.containsKey(name)) {
            throw new IllegalArgumentException("The Enum name must be unique, '" + name + "' has already been added");
        }
        entry.map.put(name, this);
        entry.list.add(this);
    }

    protected Object readResolve() {
        Entry entry = (Entry)cEnumClasses.get(this.getEnumClass());
        if (entry == null) {
            return null;
        }
        return (Enum)entry.map.get(this.getName());
    }

    protected static Enum getEnum(Class enumClass, String name) {
        Entry entry = Enum.getEntry(enumClass);
        if (entry == null) {
            return null;
        }
        return (Enum)entry.map.get(name);
    }

    protected static Map getEnumMap(Class enumClass) {
        Entry entry = Enum.getEntry(enumClass);
        if (entry == null) {
            return EMPTY_MAP;
        }
        return entry.unmodifiableMap;
    }

    protected static List getEnumList(Class enumClass) {
        Entry entry = Enum.getEntry(enumClass);
        if (entry == null) {
            return Collections.EMPTY_LIST;
        }
        return entry.unmodifiableList;
    }

    protected static Iterator iterator(Class enumClass) {
        return Enum.getEnumList(enumClass).iterator();
    }

    private static Entry getEntry(Class enumClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException("The Enum Class must not be null");
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.directory.shared.ldap.util.Enum");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException("The Class must be a subclass of Enum");
        }
        Entry entry = (Entry)cEnumClasses.get(enumClass);
        return entry;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Entry createEntry(Class enumClass) {
        Class<?> clazz;
        Entry entry = new Entry();
        Class cls = enumClass.getSuperclass();
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                Entry loopEntry = (Entry)cEnumClasses.get(cls);
                if (loopEntry != null) {
                    entry.list.addAll(loopEntry.list);
                    entry.map.putAll(loopEntry.map);
                    return entry;
                }
                cls = cls.getSuperclass();
            }
            if (cls == null) return entry;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.apache.directory.shared.ldap.util.Enum");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (cls == clazz2) return entry;
            clazz = class$1;
            if (clazz != null) continue;
            try {
                clazz = Class.forName("org.apache.directory.shared.ldap.util.ValuedEnum");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (cls != clazz);
        return entry;
    }

    public final String getName() {
        return this.iName;
    }

    public Class getEnumClass() {
        return this.getClass();
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() == this.getClass()) {
            return this.iName.equals(((Enum)other).iName);
        }
        try {
            Method mth = other.getClass().getMethod("getName", null);
            String name = (String)mth.invoke(other, null);
            return this.iName.equals(name);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    public final int hashCode() {
        return this.iHashCode;
    }

    public int compareTo(Object other) {
        if (other == this) {
            return 0;
        }
        return this.iName.compareTo(((Enum)other).iName);
    }

    public String toString() {
        if (this.iToString == null) {
            String shortName = ClassUtils.getShortClassName(this.getEnumClass());
            this.iToString = String.valueOf(shortName) + "[" + this.getName() + "]";
        }
        return this.iToString;
    }

    private static class Entry {
        final Map map = new HashMap();
        final Map unmodifiableMap = Collections.unmodifiableMap(this.map);
        final List list = new ArrayList(25);
        final List unmodifiableList = Collections.unmodifiableList(this.list);

        private Entry() {
        }
    }
}

