/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.extended.operations;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IAction;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.ldap.codec.extended.operations.GracefulDisconnect;
import org.apache.directory.shared.ldap.codec.extended.operations.GracefulDisconnectContainer;
import org.apache.directory.shared.ldap.codec.extended.operations.GracefulDisconnectStatesEnum;
import org.apache.directory.shared.ldap.codec.util.LdapURL;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulDisconnectGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log;
    private static final boolean IS_DEBUG;
    private static IGrammar instance;
    GrammarAction storeDelay = new GrammarAction("Set Graceful Disconnect Delay"){

        public void action(IAsn1Container container) throws DecoderException {
            GracefulDisconnectContainer gracefulDisconnectContainer = (GracefulDisconnectContainer)container;
            Value value = gracefulDisconnectContainer.getCurrentTLV().getValue();
            try {
                int delay = IntegerDecoder.parse((Value)value, (int)0, (int)86400);
                if (IS_DEBUG) {
                    log.debug("Delay = " + delay);
                }
                gracefulDisconnectContainer.getGracefulDisconnect().setDelay(delay);
                gracefulDisconnectContainer.grammarEndAllowed(true);
            }
            catch (IntegerDecoderException e) {
                String msg = "failed to decode the delay, the value should be between 0 and 86400 seconds, it is '" + StringTools.dumpBytes(value.getData()) + "'";
                log.error(msg);
                throw new DecoderException(msg);
            }
        }
    };
    GrammarAction storeReferral = new GrammarAction("Stores a referral"){

        public void action(IAsn1Container container) throws DecoderException {
            GracefulDisconnectContainer gracefulDisconnectContainer = (GracefulDisconnectContainer)container;
            Value value = gracefulDisconnectContainer.getCurrentTLV().getValue();
            try {
                LdapURL url = new LdapURL(value.getData());
                gracefulDisconnectContainer.getGracefulDisconnect().addReplicatedContexts(url);
                gracefulDisconnectContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("Stores a referral : {}", (Object)url);
                }
            }
            catch (LdapURLEncodingException e) {
                String msg = "failed to decode the URL '" + StringTools.dumpBytes(value.getData()) + "'";
                log.error(msg);
                throw new DecoderException(msg);
            }
        }
    };
    GrammarAction storeTimeOffline = new GrammarAction("Set Graceful Disconnect time offline"){

        public void action(IAsn1Container container) throws DecoderException {
            GracefulDisconnectContainer gracefulDisconnectContainer = (GracefulDisconnectContainer)container;
            Value value = gracefulDisconnectContainer.getCurrentTLV().getValue();
            try {
                int timeOffline = IntegerDecoder.parse((Value)value, (int)0, (int)720);
                if (IS_DEBUG) {
                    log.debug("Time Offline = " + timeOffline);
                }
                gracefulDisconnectContainer.getGracefulDisconnect().setTimeOffline(timeOffline);
                gracefulDisconnectContainer.grammarEndAllowed(true);
            }
            catch (IntegerDecoderException e) {
                String msg = "failed to decode the timeOffline, the value should be between 0 and 720 minutes, it is '" + StringTools.dumpBytes(value.getData()) + "'";
                log.error(msg);
                throw new DecoderException(msg);
            }
        }
    };
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.directory.shared.ldap.codec.extended.operations.GracefulDisconnectGrammar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        IS_DEBUG = log.isDebugEnabled();
        instance = new GracefulDisconnectGrammar();
    }

    private GracefulDisconnectGrammar() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.directory.shared.ldap.codec.extended.operations.GracefulDisconnectGrammar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.name = clazz.getName();
        this.statesEnum = GracefulDisconnectStatesEnum.getInstance();
        this.transitions = new GrammarTransition[GracefulDisconnectStatesEnum.LAST_GRACEFUL_DISCONNECT_STATE][256];
        this.transitions[0][48] = new GrammarTransition(0, GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_STATE, 48, (IAction)new GrammarAction("Init Graceful Disconnect"){

            public void action(IAsn1Container container) {
                GracefulDisconnectContainer gracefulDisconnectContainer = (GracefulDisconnectContainer)container;
                GracefulDisconnect gracefulDisconnect = new GracefulDisconnect();
                gracefulDisconnectContainer.setGracefulDisconnect(gracefulDisconnect);
                gracefulDisconnectContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_STATE][2] = new GrammarTransition(GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_STATE, GracefulDisconnectStatesEnum.TIME_OFFLINE_STATE, 2, (IAction)this.storeTimeOffline);
        this.transitions[GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_STATE][128] = new GrammarTransition(GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_STATE, GracefulDisconnectStatesEnum.DELAY_STATE, 128, (IAction)this.storeDelay);
        this.transitions[GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_STATE][48] = new GrammarTransition(GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_STATE, GracefulDisconnectStatesEnum.REPLICATED_CONTEXTS_STATE, 48, null);
        this.transitions[GracefulDisconnectStatesEnum.TIME_OFFLINE_STATE][128] = new GrammarTransition(GracefulDisconnectStatesEnum.TIME_OFFLINE_STATE, GracefulDisconnectStatesEnum.DELAY_STATE, 128, (IAction)this.storeDelay);
        this.transitions[GracefulDisconnectStatesEnum.TIME_OFFLINE_STATE][48] = new GrammarTransition(GracefulDisconnectStatesEnum.TIME_OFFLINE_STATE, GracefulDisconnectStatesEnum.REPLICATED_CONTEXTS_STATE, 48, null);
        this.transitions[GracefulDisconnectStatesEnum.DELAY_STATE][48] = new GrammarTransition(GracefulDisconnectStatesEnum.DELAY_STATE, GracefulDisconnectStatesEnum.REPLICATED_CONTEXTS_STATE, 48, null);
        this.transitions[GracefulDisconnectStatesEnum.REPLICATED_CONTEXTS_STATE][4] = new GrammarTransition(GracefulDisconnectStatesEnum.REPLICATED_CONTEXTS_STATE, GracefulDisconnectStatesEnum.REFERRAL_STATE, 4, (IAction)this.storeReferral);
        this.transitions[GracefulDisconnectStatesEnum.REFERRAL_STATE][4] = new GrammarTransition(GracefulDisconnectStatesEnum.REFERRAL_STATE, GracefulDisconnectStatesEnum.REFERRAL_STATE, 4, (IAction)this.storeReferral);
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

