/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.bind;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.bind.LdapAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAuthentication
extends LdapAuthentication {
    private static Logger log;
    private static final boolean IS_DEBUG;
    private byte[] simple;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.directory.shared.ldap.codec.bind.SimpleAuthentication");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        IS_DEBUG = log.isDebugEnabled();
    }

    public byte[] getSimple() {
        return this.simple;
    }

    public void setSimple(byte[] simple) {
        this.simple = simple;
    }

    public int computeLength() {
        int length = 1;
        length += TLV.getNbBytes((int)this.simple.length) + this.simple.length;
        if (IS_DEBUG) {
            log.debug("Simple Authentication length : {}", (Object)new Integer(length));
        }
        return length;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            log.error("Cannot put a PDU in a null buffer !");
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)-128);
            buffer.put(TLV.getBytes((int)this.simple.length));
            if (this.simple.length != 0) {
                buffer.put(this.simple);
            }
        }
        catch (BufferOverflowException boe) {
            log.error("The PDU buffer size is too small !");
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        return this.simple == null ? "null" : this.simple.toString();
    }
}

