/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.bind;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.bind.LdapAuthentication;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslCredentials
extends LdapAuthentication {
    private static Logger log;
    private static final boolean IS_DEBUG;
    private String mechanism;
    private transient byte[] mechanismBytes;
    private byte[] credentials;
    private transient int mechanismLength;
    private transient int credentialsLength;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.directory.shared.ldap.codec.bind.SimpleAuthentication");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        IS_DEBUG = log.isDebugEnabled();
    }

    public byte[] getCredentials() {
        return this.credentials;
    }

    public void setCredentials(byte[] credentials) {
        this.credentials = credentials;
    }

    public String getMechanism() {
        return this.mechanism == null ? null : this.mechanism;
    }

    public void setMechanism(String mechanism) {
        this.mechanism = mechanism;
    }

    public int computeLength() {
        this.mechanismBytes = StringTools.getBytesUtf8(this.mechanism);
        this.mechanismLength = 1 + TLV.getNbBytes((int)this.mechanismBytes.length) + this.mechanismBytes.length;
        this.credentialsLength = 0;
        if (this.credentials != null) {
            this.credentialsLength = 1 + TLV.getNbBytes((int)this.credentials.length) + this.credentials.length;
        }
        int saslLength = 1 + TLV.getNbBytes((int)(this.mechanismLength + this.credentialsLength)) + this.mechanismLength + this.credentialsLength;
        if (IS_DEBUG) {
            log.debug("SASL Authentication length : {}", (Object)new Integer(saslLength));
        }
        return saslLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            log.error("Cannot put a PDU in a null buffer !");
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)-93);
            buffer.put(TLV.getBytes((int)(this.mechanismLength + this.credentialsLength)));
            Value.encode((ByteBuffer)buffer, (String)this.mechanism);
            if (this.credentials != null) {
                Value.encode((ByteBuffer)buffer, (byte[])this.credentials);
            }
        }
        catch (BufferOverflowException boe) {
            log.error("The PDU buffer size is too small !");
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("        Sasl credentials\n");
        sb.append("            Mechanism :'").append(this.mechanism).append("'\n");
        if (this.credentials != null) {
            sb.append("            Credentials :'").append(StringTools.dumpBytes(this.credentials)).append("'\n");
        }
        return sb.toString();
    }
}

