/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.search.SearchResultReference;
import org.apache.directory.shared.ldap.codec.util.LdapURL;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreReferenceAction
extends GrammarAction {
    private static final Logger log;
    private static final boolean IS_DEBUG;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.directory.shared.ldap.codec.actions.StoreReferenceAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        IS_DEBUG = log.isDebugEnabled();
    }

    public StoreReferenceAction() {
        super("Store a reference");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        SearchResultReference searchResultReference = ldapMessageContainer.getLdapMessage().getSearchResultReference();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        LdapURL url = LdapURL.EMPTY_URL;
        if (tlv.getLength() == 0) {
            searchResultReference.addSearchResultReference(url);
        } else {
            try {
                url = new LdapURL(tlv.getValue().getData());
                searchResultReference.addSearchResultReference(url);
            }
            catch (LdapURLEncodingException luee) {
                String badUrl = new String(tlv.getValue().getData());
                log.error("The URL {} is not valid : {}", (Object)badUrl, (Object)luee.getMessage());
                throw new DecoderException("Invalid URL : " + luee.getMessage());
            }
        }
        if (IS_DEBUG) {
            log.debug("Search reference URL found : {}", (Object)url);
        }
        ldapMessageContainer.grammarEndAllowed(true);
    }
}

