/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.codec.stateful.DecoderCallback;
import org.apache.directory.shared.asn1.codec.stateful.DecoderMonitor;
import org.apache.directory.shared.ldap.RuntimeMultiException;
import org.apache.directory.shared.ldap.codec.LdapDecoder;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.message.spi.Provider;
import org.apache.directory.shared.ldap.message.spi.ProviderDecoder;
import org.apache.directory.shared.ldap.message.spi.ProviderException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwixDecoder
implements ProviderDecoder {
    private static Logger log;
    private static final boolean IS_DEBUG;
    private final Provider provider;
    private final LdapMessageContainer ldapMessageContainer;
    private final Asn1Decoder ldapDecoder;
    private DecoderCallback decoderCallback;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.directory.shared.ldap.codec.TwixDecoder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        IS_DEBUG = log.isDebugEnabled();
    }

    public TwixDecoder(Provider provider, Set binaries) {
        this.provider = provider;
        this.ldapMessageContainer = new LdapMessageContainer(binaries);
        this.ldapDecoder = new LdapDecoder();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void decode(Object encoded) throws DecoderException {
        ByteBuffer buf;
        int position = 0;
        if (encoded instanceof ByteBuffer) {
            buf = (ByteBuffer)encoded;
        } else {
            if (!(encoded instanceof byte[])) {
                throw new DecoderException("Expected either a byte[] or ByteBuffer argument but got a " + encoded.getClass());
            }
            buf = ByteBuffer.wrap((byte[])encoded);
        }
        while (buf.hasRemaining()) {
            try {
                this.ldapDecoder.decode(buf, (IAsn1Container)this.ldapMessageContainer);
                if (IS_DEBUG) {
                    log.debug("Decoding the PDU : ");
                    int size = buf.position();
                    buf.flip();
                    byte[] array = new byte[size - position];
                    int i = position;
                    while (true) {
                        if (i >= size) {
                            position = size;
                            log.debug(StringTools.dumpBytes(array));
                            break;
                        }
                        array[i] = buf.get();
                        ++i;
                    }
                }
                if (this.ldapMessageContainer.getState() != 1024) continue;
                if (IS_DEBUG) {
                    log.debug("Decoded LdapMessage : " + (Object)((Object)this.ldapMessageContainer.getLdapMessage()));
                    buf.mark();
                }
                this.decoderCallback.decodeOccurred(null, (Object)this.ldapMessageContainer.getLdapMessage());
                this.ldapMessageContainer.clean();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    private void digest(InputStream in) throws ProviderException {
        try {
            while (in.available() > 0) {
                byte[] buf = new byte[in.available()];
                int amount = in.read(buf);
                if (amount != -1) {
                    this.ldapDecoder.decode(ByteBuffer.wrap(buf, 0, amount), (IAsn1Container)this.ldapMessageContainer);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error("Twix decoder failure : " + e.getMessage());
            ProviderException pe = new ProviderException(this.provider, "Twix decoder failure!");
            pe.addThrowable(e);
            throw pe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(Object lock, InputStream in) throws ProviderException {
        Object pe2;
        if (lock == null) {
            this.digest(in);
            if (this.ldapMessageContainer.getState() == 1024) {
                if (IS_DEBUG) {
                    log.debug("Decoded LdapMessage : " + (Object)((Object)this.ldapMessageContainer.getLdapMessage()));
                }
                return this.ldapMessageContainer.getLdapMessage();
            }
            log.error("Twix decoder failure, PDU does not contain enough data");
            ProviderException pe2 = new ProviderException(this.provider, "Twix decoder failure!");
            pe2.addThrowable(new DecoderException("The input stream does not contain a full PDU"));
            throw pe2;
        }
        try {
            pe2 = lock;
            synchronized (pe2) {
                this.digest(in);
                lock.notifyAll();
            }
        }
        catch (Exception e) {
            log.error("Twix decoder failure : " + e.getMessage());
            ProviderException pe3 = new ProviderException(this.provider, "Twix decoder failure!");
            pe3.addThrowable(e);
            throw pe3;
        }
        if (this.ldapMessageContainer.getState() == 1024) {
            if (IS_DEBUG) {
                log.debug("Decoded LdapMessage : " + (Object)((Object)this.ldapMessageContainer.getLdapMessage()));
            }
            return this.ldapMessageContainer.getLdapMessage();
        }
        log.error("Twix decoder failure : The input stream does not contain a full PDU");
        pe2 = new ProviderException(this.provider, "Twix decoder failure!");
        ((RuntimeMultiException)pe2).addThrowable(new DecoderException("The input stream does not contain a full PDU"));
        throw pe2;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setDecoderMonitor(DecoderMonitor monitor) {
    }

    public void setCallback(DecoderCallback cb) {
        this.decoderCallback = cb;
    }
}

