/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;

public abstract class UserClass
implements Serializable {
    public static final AllUsers ALL_USERS = new AllUsers();
    public static final ThisEntry THIS_ENTRY = new ThisEntry();

    protected UserClass() {
    }

    public static class AllUsers
    extends UserClass {
        private static final long serialVersionUID = 8967984720792510292L;

        private AllUsers() {
        }

        public String toString() {
            return "allUsers";
        }
    }

    public static class ThisEntry
    extends UserClass {
        private static final long serialVersionUID = -8189325270233754470L;

        private ThisEntry() {
        }

        public String toString() {
            return "thisEntry";
        }
    }

    private static abstract class NamedUserClass
    extends UserClass {
        protected final Set names;

        protected NamedUserClass(Set names) {
            Iterator i = names.iterator();
            while (i.hasNext()) {
                Object val = i.next();
                if (val instanceof javax.naming.Name) continue;
                throw new IllegalArgumentException("names contains a wrong element.");
            }
            this.names = Collections.unmodifiableSet(new HashSet(names));
        }

        public Set getNames() {
            return this.names;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass().isAssignableFrom(o.getClass())) {
                Name that = (Name)o;
                return this.names.equals(that.names);
            }
            return false;
        }

        public String toString() {
            return this.names.toString();
        }
    }

    public static class Name
    extends NamedUserClass {
        private static final long serialVersionUID = -4168412030168359882L;

        public Name(Set usernames) {
            super(usernames);
        }

        public String toString() {
            return "name: " + super.toString();
        }
    }

    public static class UserGroup
    extends NamedUserClass {
        private static final long serialVersionUID = 8887107815072965807L;

        public UserGroup(Set groupNames) {
            super(groupNames);
        }

        public String toString() {
            return "userGroup: " + super.toString();
        }
    }

    public static class Subtree
    extends UserClass {
        private static final long serialVersionUID = 3949337699049701332L;
        protected final Collection subtreeSpecifications;

        public Subtree(Collection subtreeSpecs) {
            Iterator i = subtreeSpecs.iterator();
            while (i.hasNext()) {
                Object val = i.next();
                if (val instanceof SubtreeSpecification) continue;
                throw new IllegalArgumentException("subtreeSpecs contains a wrong element.");
            }
            this.subtreeSpecifications = Collections.unmodifiableCollection(new ArrayList(subtreeSpecs));
        }

        public Collection getSubtreeSpecifications() {
            return this.subtreeSpecifications;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Subtree) {
                Subtree that = (Subtree)o;
                return this.subtreeSpecifications.equals(that.subtreeSpecifications);
            }
            return false;
        }

        public String toString() {
            return "subtree: " + this.subtreeSpecifications;
        }
    }
}

