/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import org.apache.directory.shared.ldap.aci.MicroOperation;

public class GrantAndDenial {
    public static final GrantAndDenial GRANT_ADD = new GrantAndDenial(MicroOperation.ADD, 0, true);
    public static final GrantAndDenial DENY_ADD = new GrantAndDenial(MicroOperation.ADD, 1, false);
    public static final GrantAndDenial GRANT_DISCLOSE_ON_ERROR = new GrantAndDenial(MicroOperation.DISCLOSE_ON_ERROR, 2, true);
    public static final GrantAndDenial DENY_DISCLOSE_ON_ERROR = new GrantAndDenial(MicroOperation.DISCLOSE_ON_ERROR, 3, false);
    public static final GrantAndDenial GRANT_READ = new GrantAndDenial(MicroOperation.READ, 4, true);
    public static final GrantAndDenial DENY_READ = new GrantAndDenial(MicroOperation.READ, 5, false);
    public static final GrantAndDenial GRANT_REMOVE = new GrantAndDenial(MicroOperation.REMOVE, 6, true);
    public static final GrantAndDenial DENY_REMOVE = new GrantAndDenial(MicroOperation.REMOVE, 7, false);
    public static final GrantAndDenial GRANT_BROWSE = new GrantAndDenial(MicroOperation.BROWSE, 8, true);
    public static final GrantAndDenial DENY_BROWSE = new GrantAndDenial(MicroOperation.BROWSE, 9, false);
    public static final GrantAndDenial GRANT_EXPORT = new GrantAndDenial(MicroOperation.EXPORT, 10, true);
    public static final GrantAndDenial DENY_EXPORT = new GrantAndDenial(MicroOperation.EXPORT, 11, false);
    public static final GrantAndDenial GRANT_IMPORT = new GrantAndDenial(MicroOperation.IMPORT, 12, true);
    public static final GrantAndDenial DENY_IMPORT = new GrantAndDenial(MicroOperation.IMPORT, 13, false);
    public static final GrantAndDenial GRANT_MODIFY = new GrantAndDenial(MicroOperation.MODIFY, 14, true);
    public static final GrantAndDenial DENY_MODIFY = new GrantAndDenial(MicroOperation.MODIFY, 15, false);
    public static final GrantAndDenial GRANT_RENAME = new GrantAndDenial(MicroOperation.RENAME, 16, true);
    public static final GrantAndDenial DENY_RENAME = new GrantAndDenial(MicroOperation.RENAME, 17, false);
    public static final GrantAndDenial GRANT_RETURN_DN = new GrantAndDenial(MicroOperation.RETURN_DN, 18, true);
    public static final GrantAndDenial DENY_RETURN_DN = new GrantAndDenial(MicroOperation.RETURN_DN, 19, false);
    public static final GrantAndDenial GRANT_COMPARE = new GrantAndDenial(MicroOperation.COMPARE, 20, true);
    public static final GrantAndDenial DENY_COMPARE = new GrantAndDenial(MicroOperation.COMPARE, 21, false);
    public static final GrantAndDenial GRANT_FILTER_MATCH = new GrantAndDenial(MicroOperation.FILTER_MATCH, 22, true);
    public static final GrantAndDenial DENY_FILTER_MATCH = new GrantAndDenial(MicroOperation.FILTER_MATCH, 23, false);
    public static final GrantAndDenial GRANT_INVOKE = new GrantAndDenial(MicroOperation.INVOKE, 24, true);
    public static final GrantAndDenial DENY_INVOKE = new GrantAndDenial(MicroOperation.INVOKE, 25, false);
    private final MicroOperation microOperation;
    private final int code;
    private final String name;
    private final boolean grant;

    private GrantAndDenial(MicroOperation microOperation, int code, boolean grant) {
        this.microOperation = microOperation;
        this.code = code;
        this.name = String.valueOf(grant ? "grant" : "deny") + microOperation.getName();
        this.grant = grant;
    }

    public MicroOperation getMicroOperation() {
        return this.microOperation;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public boolean isGrant() {
        return this.grant;
    }

    public String toString() {
        return "[" + this.code + "] " + this.name;
    }
}

