/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import net.sf.retrotranslator.runtime.java.util._Arrays;
import org.apache.directory.shared.ldap.message.IteratorNamingEnumeration;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockableAttributeImpl
implements Attribute {
    private static final Logger log;
    private static final long serialVersionUID = -5158233254341746514L;
    private final String upId;
    private Object value;
    private List list;
    private int size = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.directory.shared.ldap.message.LockableAttributeImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public LockableAttributeImpl(String id) {
        this.upId = id;
        this.value = null;
        this.list = null;
        this.size = 0;
    }

    public LockableAttributeImpl(String id, Object value) {
        this.upId = id;
        this.list = null;
        this.value = AttributeUtils.cloneValue(value);
        this.size = 1;
    }

    public LockableAttributeImpl(String id, byte[] value) {
        this.upId = id;
        this.list = null;
        this.value = AttributeUtils.cloneValue(value);
        this.size = 1;
    }

    public NamingEnumeration getAll() {
        if (this.size < 2) {
            return new IteratorNamingEnumeration(new Iterator(){
                private boolean more;
                {
                    this.more = LockableAttributeImpl.this.size != 0;
                }

                public boolean hasNext() {
                    return this.more;
                }

                public Object next() {
                    this.more = false;
                    return LockableAttributeImpl.this.value;
                }

                public void remove() {
                    LockableAttributeImpl.this.value = null;
                    this.more = true;
                    LockableAttributeImpl.this.size = 0;
                }
            });
        }
        return new IteratorNamingEnumeration(this.list.iterator());
    }

    public Object get() {
        if (this.size < 2) {
            return this.value;
        }
        return this.list.get(0);
    }

    public int size() {
        return this.size;
    }

    public String getID() {
        return this.upId;
    }

    public boolean contains(Object attrVal) {
        switch (this.size) {
            case 0: {
                return false;
            }
            case 1: {
                return AttributeUtils.equals(this.value, attrVal);
            }
        }
        Iterator values = this.list.iterator();
        while (values.hasNext()) {
            if (!AttributeUtils.equals(values.next(), attrVal)) continue;
            return true;
        }
        return false;
    }

    public boolean add(Object attrVal) {
        boolean exists = false;
        if (this.contains(attrVal)) {
            return true;
        }
        attrVal = AttributeUtils.cloneValue(attrVal);
        switch (this.size) {
            case 0: {
                this.value = attrVal;
                ++this.size;
                return true;
            }
            case 1: {
                exists = this.value.equals(attrVal);
                if (exists) {
                    return true;
                }
                this.list = new ArrayList();
                this.list.add(this.value);
                this.list.add(attrVal);
                ++this.size;
                this.value = null;
                return true;
            }
        }
        exists = this.list.contains(attrVal);
        this.list.add(attrVal);
        ++this.size;
        return exists;
    }

    public boolean remove(Object attrVal) {
        switch (this.size) {
            case 0: {
                return false;
            }
            case 1: {
                this.value = null;
                --this.size;
                return true;
            }
            case 2: {
                this.list.remove(attrVal);
                this.value = this.list.get(0);
                this.size = 1;
                this.list = null;
                return true;
            }
        }
        this.list.remove(attrVal);
        --this.size;
        return true;
    }

    public void clear() {
        switch (this.size) {
            case 0: {
                return;
            }
            case 1: {
                this.value = null;
                this.size = 0;
                return;
            }
        }
        this.list = null;
        this.size = 0;
    }

    public DirContext getAttributeSyntaxDefinition() throws NamingException {
        throw new OperationNotSupportedException("Extending subclasses may override this if they like!");
    }

    public DirContext getAttributeDefinition() throws NamingException {
        throw new OperationNotSupportedException("Extending subclasses may override this if they like!");
    }

    public Object clone() {
        try {
            LockableAttributeImpl clone = (LockableAttributeImpl)super.clone();
            if (this.size < 2) {
                clone.value = AttributeUtils.cloneValue(this.value);
            } else {
                clone.list = new ArrayList(this.size);
                int i = 0;
                while (i < this.size) {
                    Object newValue = AttributeUtils.cloneValue(this.list.get(i));
                    clone.list.add(newValue);
                    ++i;
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public boolean isOrdered() {
        return true;
    }

    public Object get(int index) {
        if (index < 0 || index > this.size + 1) {
            return null;
        }
        switch (this.size) {
            case 0: {
                return null;
            }
            case 1: {
                return this.value;
            }
        }
        return this.list.get(index);
    }

    public Object remove(int index) {
        if (index < 0 || index > this.size + 1) {
            return null;
        }
        switch (this.size) {
            case 0: {
                return null;
            }
            case 1: {
                Object result = this.value;
                this.value = null;
                this.size = 0;
                return result;
            }
            case 2: {
                Object removed = this.list.remove(index);
                this.value = this.list.get(0);
                this.size = 1;
                this.list = null;
                return removed;
            }
        }
        --this.size;
        return this.list.remove(index);
    }

    public void add(int index, Object attrVal) {
        attrVal = AttributeUtils.cloneValue(attrVal);
        switch (this.size) {
            case 0: {
                ++this.size;
                this.value = attrVal;
                return;
            }
            case 1: {
                this.list = new ArrayList();
                if (index == 0) {
                    this.list.add(attrVal);
                    this.list.add(this.value);
                } else {
                    this.list.add(this.value);
                    this.list.add(attrVal);
                }
                ++this.size;
                this.value = null;
                return;
            }
        }
        this.list.add(index, attrVal);
        ++this.size;
    }

    public Object set(int index, Object attrVal) {
        attrVal = AttributeUtils.cloneValue(attrVal);
        switch (this.size) {
            case 0: {
                ++this.size;
                this.value = attrVal;
                return null;
            }
            case 1: {
                if (index == 0) {
                    Object result = this.value;
                    this.value = attrVal;
                    return result;
                }
                this.list = new ArrayList();
                this.list.add(this.value);
                this.list.add(attrVal);
                this.size = 2;
                this.value = null;
                return null;
            }
        }
        Object oldValue = this.list.get(index);
        this.list.set(index, attrVal);
        return oldValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof LockableAttributeImpl)) {
            return false;
        }
        Attribute attr = (Attribute)obj;
        if (!this.upId.equals(attr.getID())) {
            return false;
        }
        if (attr.size() != this.size) {
            return false;
        }
        if (this.size == 0) {
            return true;
        }
        if (this.size == 1) {
            try {
                return this.value.equals(attr.get(0));
            }
            catch (NamingException ne) {
                log.warn("Failed to get an attribute from the specifid attribute: " + attr, (Throwable)ne);
                return false;
            }
        }
        HashMap hash = new HashMap();
        Iterator values = this.list.iterator();
        while (values.hasNext()) {
            Object v = values.next();
            int h = 0;
            if (v instanceof String) {
                h = v.hashCode();
            } else {
                if (!(v instanceof byte[])) {
                    return false;
                }
                byte[] bv = (byte[])v;
                h = _Arrays.hashCode((byte[])bv);
            }
            hash.put(_Integer.valueOf((int)h), v);
        }
        try {
            NamingEnumeration<?> attrValues = attr.getAll();
            while (true) {
                Object val2;
                Integer h;
                if (!attrValues.hasMoreElements()) {
                    return hash.size() == 0;
                }
                Object val = attrValues.next();
                if (val instanceof String) {
                    h = _Integer.valueOf((int)val.hashCode());
                    if (!hash.containsKey(h)) {
                        return false;
                    }
                    val2 = hash.remove(h);
                    if (val.equals(val2)) continue;
                    return false;
                }
                if (!(val instanceof byte[])) {
                    return false;
                }
                h = _Integer.valueOf((int)_Arrays.hashCode((byte[])((byte[])val)));
                if (!hash.containsKey(h)) {
                    return false;
                }
                val2 = hash.remove(h);
                if (!Arrays.equals((byte[])val, (byte[])val2)) break;
            }
            return false;
        }
        catch (NamingException ne) {
            log.warn("Failed to get an attribute from the specifid attribute: " + attr, (Throwable)ne);
            return false;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Attribute id : '").append(this.upId).append("', ");
        sb.append(" Values : [");
        switch (this.size) {
            case 0: {
                sb.append("]\n");
                break;
            }
            case 1: {
                if (this.value instanceof String) {
                    sb.append('\'').append(this.value).append('\'');
                } else {
                    sb.append(StringTools.dumpBytes((byte[])this.value));
                }
                sb.append("]\n");
                break;
            }
            default: {
                boolean isFirst = true;
                Iterator values = this.list.iterator();
                while (values.hasNext()) {
                    Object v = values.next();
                    if (!isFirst) {
                        sb.append(", ");
                    } else {
                        isFirst = false;
                    }
                    if (v instanceof String) {
                        sb.append('\'').append(v).append('\'');
                        continue;
                    }
                    sb.append(StringTools.dumpBytes((byte[])v));
                }
                sb.append("]\n");
            }
        }
        return sb.toString();
    }
}

