/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.name.AttributeTypeAndValue;
import org.apache.directory.shared.ldap.name.DefaultStringNormalizer;
import org.apache.directory.shared.ldap.name.LdapDnParser;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.OidNormalizer;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapDN
implements Name {
    private static Logger log = LoggerFactory.getLogger((Class)LdapDN.class);
    private static final long serialVersionUID = 1L;
    public static final int NOT_EQUALS = -1;
    public static final int EQUALS = 0;
    private List rdns = new ArrayList(5);
    private String upName;
    private String normName;
    private byte[] bytes;
    public static final LdapDN EMPTY_LDAPDN = new LdapDN();

    public LdapDN() {
        this.upName = "";
        this.normName = "";
    }

    public LdapDN(Name name) throws InvalidNameException {
        if (name != null && name.size() != 0) {
            for (int ii = 0; ii < name.size(); ++ii) {
                String nameComponent = name.get(ii);
                this.add(nameComponent);
            }
        }
    }

    LdapDN(List list) throws InvalidNameException {
        if (list != null && list.size() != 0) {
            Iterator nameComponents = list.iterator();
            while (nameComponents.hasNext()) {
                String nameComponent = (String)nameComponents.next();
                this.add(0, nameComponent);
            }
        }
    }

    LdapDN(Iterator nameComponents) throws InvalidNameException {
        if (nameComponents != null) {
            while (nameComponents.hasNext()) {
                String nameComponent = (String)nameComponents.next();
                this.add(0, nameComponent);
            }
        }
    }

    public LdapDN(String upName) throws InvalidNameException {
        if (upName != null) {
            LdapDnParser.parseInternal(upName, this.rdns);
        }
        this.normalizeInternal();
        this.upName = upName;
    }

    public LdapDN(byte[] bytes) throws InvalidNameException {
        try {
            this.upName = new String(bytes, "UTF-8");
            LdapDnParser.parseInternal(this.upName, this.rdns);
            this.normName = this.toNormName();
        }
        catch (UnsupportedEncodingException uee) {
            log.error("The byte array is not an UTF-8 encoded Unicode String : " + uee.getMessage());
            throw new InvalidNameException("The byte array is not an UTF-8 encoded Unicode String : " + uee.getMessage());
        }
    }

    private void normalizeInternal() {
        this.normName = this.toNormName();
    }

    public String toNormName() {
        if (this.rdns == null || this.rdns.size() == 0) {
            this.bytes = null;
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        for (int i = 0; i < this.rdns.size(); ++i) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            sb.append((Rdn)this.rdns.get(i));
        }
        String newNormName = sb.toString();
        if (this.normName != newNormName) {
            this.bytes = StringTools.getBytesUtf8(newNormName);
            this.normName = newNormName;
        }
        return this.normName;
    }

    public String toString() {
        return this.normName == null ? "" : this.normName;
    }

    private String toUpName() {
        if (this.rdns == null || this.rdns.size() == 0) {
            this.upName = "";
        } else {
            StringBuffer sb = new StringBuffer();
            boolean isFirst = true;
            for (int i = 0; i < this.rdns.size(); ++i) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(',');
                }
                sb.append(((Rdn)this.rdns.get(i)).getUpName());
            }
            this.upName = sb.toString();
        }
        return this.upName;
    }

    private String getUpNamePrefix(int posn) {
        if (posn == 0) {
            return "";
        }
        if (posn > this.rdns.size()) {
            String message = "Impossible to get the position " + posn + ", the DN only has " + this.rdns.size() + " RDNs";
            log.error(message);
            throw new ArrayIndexOutOfBoundsException(message);
        }
        int start = this.rdns.size() - posn;
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        for (int i = start; i < this.rdns.size(); ++i) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            sb.append(((Rdn)this.rdns.get(i)).getUpName());
        }
        return sb.toString();
    }

    private String getUpNameSuffix(int posn) {
        if (posn > this.rdns.size()) {
            return "";
        }
        int end = this.rdns.size() - posn;
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        for (int i = 0; i < end; ++i) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            sb.append(((Rdn)this.rdns.get(i)).getUpName());
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 17;
        if (this.rdns != null || this.rdns.size() == 0) {
            Iterator rdnsIter = this.rdns.iterator();
            while (rdnsIter.hasNext()) {
                result = result * 37 + rdnsIter.next().hashCode();
            }
        }
        return result;
    }

    public String getUpName() {
        return this.upName == null ? "" : this.upName;
    }

    public String getNormName() {
        return this.normName == null ? "" : this.normName;
    }

    public int size() {
        return this.rdns.size();
    }

    public static int getNbBytes(Name dn) {
        LdapDN ldapDn = (LdapDN)dn;
        return ldapDn.bytes == null ? 0 : ldapDn.bytes.length;
    }

    public static byte[] getBytes(LdapDN dn) {
        return dn == null ? null : dn.bytes;
    }

    public boolean startsWith(Name name) {
        if (name instanceof LdapDN) {
            LdapDN nameDN = (LdapDN)name;
            if (nameDN.size() == 0) {
                return true;
            }
            if (nameDN.size() > this.size()) {
                return false;
            }
            for (int i = nameDN.size() - 1; i >= 0; --i) {
                Rdn ldapRdn;
                Rdn nameRdn = (Rdn)nameDN.rdns.get(nameDN.rdns.size() - i - 1);
                if (nameRdn.compareTo(ldapRdn = (Rdn)this.rdns.get(this.rdns.size() - i - 1)) == 0) continue;
                return false;
            }
            return true;
        }
        if (name instanceof Name) {
            if (name.size() == 0) {
                return true;
            }
            if (name.size() > this.size()) {
                return false;
            }
            for (int i = name.size() - 1; i >= 0; --i) {
                Rdn ldapRdn = (Rdn)this.rdns.get(this.rdns.size() - i - 1);
                Rdn nameRdn = null;
                try {
                    nameRdn = new Rdn(name.get(name.size() - i - 1));
                }
                catch (InvalidNameException e) {
                    e.printStackTrace();
                    log.error("Failed to parse RDN for name " + name.toString(), (Throwable)e);
                }
                if (nameRdn.compareTo(ldapRdn) == 0) continue;
                return false;
            }
            return true;
        }
        return name == null;
    }

    public boolean endsWith(Name name) {
        if (name instanceof LdapDN) {
            LdapDN nameDN = (LdapDN)name;
            if (nameDN.size() == 0) {
                return true;
            }
            if (nameDN.size() > this.size()) {
                return false;
            }
            for (int i = 0; i < nameDN.size(); ++i) {
                Rdn ldapRdn;
                Rdn nameRdn = (Rdn)nameDN.rdns.get(i);
                if (nameRdn.compareTo(ldapRdn = (Rdn)this.rdns.get(i)) == 0) continue;
                return false;
            }
            return true;
        }
        return name == null;
    }

    public boolean isEmpty() {
        return this.rdns.size() == 0;
    }

    public String get(int posn) {
        if (this.rdns.size() == 0) {
            return "";
        }
        Rdn rdn = (Rdn)this.rdns.get(this.rdns.size() - posn - 1);
        return rdn.toString();
    }

    public Rdn getRdn(int posn) {
        if (this.rdns.size() == 0) {
            return null;
        }
        Rdn rdn = (Rdn)this.rdns.get(this.rdns.size() - posn - 1);
        return rdn;
    }

    public Rdn getRdn() {
        if (this.rdns.size() == 0) {
            return null;
        }
        Rdn rdn = (Rdn)this.rdns.get(0);
        return rdn;
    }

    public List getRdns() {
        ArrayList<Object> newRdns = new ArrayList<Object>();
        for (int i = 0; i < this.rdns.size(); ++i) {
            newRdns.add(i, ((Rdn)this.rdns.get(i)).clone());
        }
        return newRdns;
    }

    public Enumeration getAll() {
        return new Enumeration(){
            private int pos;

            public boolean hasMoreElements() {
                return this.pos < LdapDN.this.rdns.size();
            }

            public Object nextElement() {
                if (this.pos >= LdapDN.this.rdns.size()) {
                    log.error("Exceeded number of elements in the current object");
                    throw new NoSuchElementException();
                }
                Object obj = LdapDN.this.rdns.get(LdapDN.this.rdns.size() - this.pos - 1);
                ++this.pos;
                return obj.toString();
            }
        };
    }

    public Enumeration getAllRdn() {
        return new Enumeration(){
            private int pos;

            public boolean hasMoreElements() {
                return this.pos < LdapDN.this.rdns.size();
            }

            public Object nextElement() {
                if (this.pos >= LdapDN.this.rdns.size()) {
                    log.error("Exceeded number of elements in the current object");
                    throw new NoSuchElementException();
                }
                Object obj = LdapDN.this.rdns.get(LdapDN.this.rdns.size() - this.pos - 1);
                ++this.pos;
                return obj;
            }
        };
    }

    public Name getPrefix(int posn) {
        if (this.rdns.size() == 0) {
            return EMPTY_LDAPDN;
        }
        if (posn < 0 || posn > this.rdns.size()) {
            String message = "The posn(" + posn + ") should be in the range [0, " + this.rdns.size() + "]";
            log.error(message);
            throw new ArrayIndexOutOfBoundsException(message);
        }
        LdapDN newLdapDN = new LdapDN();
        for (int i = this.rdns.size() - posn; i < this.rdns.size(); ++i) {
            newLdapDN.rdns.add(((Rdn)this.rdns.get(i)).clone());
        }
        newLdapDN.normName = newLdapDN.toNormName();
        newLdapDN.upName = this.getUpNamePrefix(posn);
        return newLdapDN;
    }

    public Name getSuffix(int posn) {
        if (this.rdns.size() == 0) {
            return EMPTY_LDAPDN;
        }
        if (posn < 0 || posn > this.rdns.size()) {
            String message = "The posn(" + posn + ") should be in the range [0, " + this.rdns.size() + "]";
            log.error(message);
            throw new ArrayIndexOutOfBoundsException(message);
        }
        LdapDN newLdapDN = new LdapDN();
        for (int i = 0; i < this.size() - posn; ++i) {
            newLdapDN.rdns.add(((Rdn)this.rdns.get(i)).clone());
        }
        newLdapDN.normName = newLdapDN.toNormName();
        newLdapDN.upName = this.getUpNameSuffix(posn);
        return newLdapDN;
    }

    public Name addAll(Name suffix) throws InvalidNameException {
        this.addAll(this.rdns.size(), suffix);
        this.normalizeInternal();
        this.toUpName();
        return this;
    }

    public Name addAll(int posn, Name name) throws InvalidNameException {
        if (name instanceof LdapDN) {
            if (name == null || name.size() == 0) {
                return this;
            }
            this.rdns.addAll(this.size() - posn, ((LdapDN)name).rdns);
            this.normalizeInternal();
            this.toUpName();
        } else {
            if (name == null || name.size() == 0) {
                return this;
            }
            for (int ii = name.size() - 1; ii >= 0; --ii) {
                Rdn rdn = new Rdn(name.get(ii));
                this.rdns.add(this.size() - posn, rdn);
            }
            this.normalizeInternal();
            this.toUpName();
        }
        return this;
    }

    public Name add(String comp) throws InvalidNameException {
        Rdn newRdn = new Rdn(comp);
        this.rdns.add(0, newRdn);
        this.normalizeInternal();
        this.toUpName();
        return this;
    }

    public Name add(Rdn newRdn) throws InvalidNameException {
        this.rdns.add(0, newRdn);
        this.normalizeInternal();
        this.toUpName();
        return this;
    }

    public Name add(int posn, String comp) throws InvalidNameException {
        if (posn < 0 || posn > this.size()) {
            String message = "The posn(" + posn + ") should be in the range [0, " + this.rdns.size() + "]";
            log.error(message);
            throw new ArrayIndexOutOfBoundsException(message);
        }
        Rdn newRdn = new Rdn(comp);
        int realPos = this.size() - posn;
        this.rdns.add(realPos, newRdn);
        this.normalizeInternal();
        this.toUpName();
        return this;
    }

    public Object remove(int posn) throws InvalidNameException {
        if (this.rdns.size() == 0) {
            return EMPTY_LDAPDN;
        }
        if (posn < 0 || posn >= this.rdns.size()) {
            String message = "The posn(" + posn + ") should be in the range [0, " + this.rdns.size() + "]";
            log.error(message);
            throw new ArrayIndexOutOfBoundsException(message);
        }
        int realPos = this.size() - posn - 1;
        Rdn rdn = (Rdn)this.rdns.remove(realPos);
        this.normalizeInternal();
        this.toUpName();
        return rdn;
    }

    public Object clone() {
        try {
            LdapDN dn = (LdapDN)super.clone();
            dn.rdns = new ArrayList();
            for (int i = 0; i < this.rdns.size(); ++i) {
                dn.rdns.add(i, ((Rdn)this.rdns.get(i)).clone());
            }
            return dn;
        }
        catch (CloneNotSupportedException cnse) {
            log.error("The clone operation has failed");
            throw new Error("Assertion failure : cannot clone the object");
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.normName.equals(obj);
        }
        if (obj instanceof LdapDN) {
            LdapDN name = (LdapDN)obj;
            if (name.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (((Rdn)name.rdns.get(i)).compareTo(this.rdns.get(i)) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareTo(Object obj) {
        if (obj instanceof LdapDN) {
            LdapDN ldapDN = (LdapDN)obj;
            if (ldapDN.size() != this.size()) {
                return this.size() - ldapDN.size();
            }
            for (int i = this.rdns.size(); i > 0; --i) {
                Rdn rdn2;
                Rdn rdn1 = (Rdn)this.rdns.get(i - 1);
                int res = rdn1.compareTo(rdn2 = (Rdn)ldapDN.rdns.get(i - 1));
                if (res == 0) continue;
                return res;
            }
            return 0;
        }
        return 1;
    }

    private static AttributeTypeAndValue atavOidToName(AttributeTypeAndValue atav, Map oidsMap) throws InvalidNameException, NamingException {
        String type = StringTools.trim(atav.getType());
        if (type.startsWith("oid.") || type.startsWith("OID.")) {
            type = type.substring(4);
        }
        if (StringTools.isNotEmpty(StringTools.lowerCase(type))) {
            if (oidsMap == null) {
                return atav;
            }
            OidNormalizer oidNormalizer = (OidNormalizer)oidsMap.get(type);
            if (oidNormalizer != null) {
                return new AttributeTypeAndValue(oidNormalizer.getAttributeTypeOid(), (String)oidNormalizer.getNormalizer().normalize(atav.getValue()));
            }
            return atav;
        }
        log.error("Empty type not allowed in a DN");
        throw new InvalidNameException("Empty type not allowed in a DN");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void rdnOidToName(Rdn rdn, Map oidsMap) throws InvalidNameException, NamingException {
        if (rdn.getNbAtavs() > 1) {
            Rdn rdnCopy = (Rdn)rdn.clone();
            rdn.clear();
            Iterator atavs = rdnCopy.iterator();
            while (atavs.hasNext()) {
                Object val = atavs.next();
                AttributeTypeAndValue newAtav = LdapDN.atavOidToName((AttributeTypeAndValue)val, oidsMap);
                rdn.addAttributeTypeAndValue(newAtav.getType(), newAtav.getValue());
            }
            return;
        } else {
            String type = StringTools.trim(rdn.getType());
            if (type.startsWith("oid.") || type.startsWith("OID.")) {
                type = type.substring(4);
            }
            if (StringTools.isNotEmpty(StringTools.lowerCase(type))) {
                if (oidsMap == null) {
                    return;
                }
                OidNormalizer oidNormalizer = (OidNormalizer)oidsMap.get(type);
                if (oidNormalizer == null) return;
                Rdn rdnCopy = (Rdn)rdn.clone();
                rdn.clear();
                Object value = rdnCopy.getValue();
                value = DefaultStringNormalizer.normalizeString((String)value);
                rdn.addAttributeTypeAndValue(oidNormalizer.getAttributeTypeOid(), (String)oidNormalizer.getNormalizer().normalize(value));
                return;
            } else {
                log.error("We should not have an empty DN");
                throw new InvalidNameException("Empty type not allowed in a DN");
            }
        }
    }

    public static LdapDN normalize(LdapDN dn, Map oidsMap) throws InvalidNameException, NamingException {
        if (dn == null || dn.size() == 0 || oidsMap == null || oidsMap.size() == 0) {
            return dn;
        }
        LdapDN newDn = (LdapDN)dn.clone();
        Enumeration rdns = newDn.getAllRdn();
        while (rdns.hasMoreElements()) {
            Rdn rdn = (Rdn)rdns.nextElement();
            String upName = rdn.getUpName();
            LdapDN.rdnOidToName(rdn, oidsMap);
            rdn.normalizeString();
            rdn.setUpName(upName);
        }
        newDn.normalizeInternal();
        return newDn;
    }

    public void normalize(Map oidsMap) throws InvalidNameException, NamingException {
        if (oidsMap == null || oidsMap.size() == 0) {
            return;
        }
        Enumeration rdns = this.getAllRdn();
        while (rdns.hasMoreElements()) {
            Rdn rdn = (Rdn)rdns.nextElement();
            String upName = rdn.getUpName();
            LdapDN.rdnOidToName(rdn, oidsMap);
            rdn.normalizeString();
            rdn.setUpName(upName);
        }
        this.normalizeInternal();
    }
}

