/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.search.ConnectorFilter;

public class AndFilter
extends ConnectorFilter {
    public ArrayList getAndFilter() {
        return this.filterSet;
    }

    public int computeLength() {
        this.filtersLength = super.computeLength();
        return 1 + TLV.getNbBytes((int)this.filtersLength) + this.filtersLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)-96);
            buffer.put(TLV.getBytes((int)this.filtersLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        super.encode(buffer);
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('&').append(super.toString());
        return sb.toString();
    }
}

