/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.bind.BindResponse;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSASLCredsAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger((Class)ServerSASLCredsAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public ServerSASLCredsAction() {
        super("Store server sasl credentials value");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        BindResponse bindResponseMessage = ldapMessageContainer.getLdapMessage().getBindResponse();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            bindResponseMessage.setServerSaslCreds(StringTools.EMPTY_BYTES);
        } else {
            bindResponseMessage.setServerSaslCreds(tlv.getValue().getData());
        }
        ldapMessageContainer.grammarEndAllowed(true);
        if (IS_DEBUG) {
            log.debug("The SASL credentials value is : {}", (Object)bindResponseMessage.getServerSaslCreds().toString());
        }
    }
}

