/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import org.apache.directory.shared.ldap.filter.FilterVisitor;
import org.apache.directory.shared.ldap.filter.LeafNode;

public class SimpleNode
extends LeafNode {
    private Object value;

    public SimpleNode(String attribute, byte[] value, int type) {
        super(attribute, type);
        this.value = value;
        switch (type) {
            case 5: {
                break;
            }
            case 0: {
                break;
            }
            case 6: {
                throw new IllegalArgumentException("Assertion type supplied is extensible.  Use ExtensibleNode instead.");
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                throw new IllegalArgumentException("Assertion type supplied is presence.  Use PresenceNode instead.");
            }
            case 2: {
                throw new IllegalArgumentException("Assertion type supplied is substring.  Use SubstringNode instead.");
            }
            default: {
                throw new IllegalArgumentException("Attribute value assertion type is undefined.");
            }
        }
    }

    public SimpleNode(String attribute, String value, int type) {
        super(attribute, type);
        this.value = value;
        switch (type) {
            case 5: {
                break;
            }
            case 0: {
                break;
            }
            case 6: {
                throw new IllegalArgumentException("Assertion type supplied is extensible.  Use ExtensibleNode instead.");
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                throw new IllegalArgumentException("Assertion type supplied is presence.  Use PresenceNode instead.");
            }
            case 2: {
                throw new IllegalArgumentException("Assertion type supplied is substring.  Use SubstringNode instead.");
            }
            default: {
                throw new IllegalArgumentException("Attribute value assertion type is undefined.");
            }
        }
    }

    public final Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public StringBuffer printToBuffer(StringBuffer buf) {
        buf.append('(').append(this.getAttribute());
        switch (this.getAssertionType()) {
            case 5: {
                buf.append("~=");
                break;
            }
            case 0: {
                buf.append("=");
                break;
            }
            case 3: {
                buf.append(">=");
                break;
            }
            case 4: {
                buf.append("<=");
                break;
            }
            default: {
                buf.append("UNKNOWN");
            }
        }
        buf.append(this.value);
        buf.append(')');
        if (null != this.getAnnotations() && this.getAnnotations().containsKey("count")) {
            buf.append('[');
            buf.append(this.getAnnotations().get("count").toString());
            buf.append("] ");
        } else {
            buf.append(' ');
        }
        return buf;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.printToBuffer(buf);
        return buf.toString();
    }

    public void accept(FilterVisitor visitor) {
        if (visitor.canVisit(this)) {
            visitor.visit(this);
        }
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleNode)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        return this.value.equals(((SimpleNode)other).getValue());
    }
}

