/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.search.SearchResultReference;
import org.apache.directory.shared.ldap.codec.util.LdapURL;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResultReferenceGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)SearchResultReferenceGrammar.class);
    private static IGrammar instance = new SearchResultReferenceGrammar();

    private SearchResultReferenceGrammar() {
        this.name = SearchResultReferenceGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_SEARCH_RESULT_REFERENCE_STATE_STATE][256];
        this.transitions[LdapStatesEnum.SEARCH_RESULT_REFERENCE_TAG][115] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_REFERENCE_TAG, LdapStatesEnum.SEARCH_RESULT_REFERENCE_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_REFERENCE_VALUE][115] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_REFERENCE_VALUE, LdapStatesEnum.SEARCH_RESULT_REFERENCE_LDAP_URL_TAG, new GrammarAction("Init SearchResultReference"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchResultReference searchResultReference = new SearchResultReference();
                searchResultReference.setParent(ldapMessage);
                ldapMessage.setProtocolOP(searchResultReference);
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_RESULT_REFERENCE_LDAP_URL_TAG][4] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_REFERENCE_LDAP_URL_TAG, LdapStatesEnum.SEARCH_RESULT_REFERENCE_LDAP_URL_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_REFERENCE_LOOP_OR_END_TAG][4] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_REFERENCE_LOOP_OR_END_TAG, LdapStatesEnum.SEARCH_RESULT_REFERENCE_LDAP_URL_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_REFERENCE_LDAP_URL_VALUE][4] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_REFERENCE_LDAP_URL_VALUE, LdapStatesEnum.SEARCH_RESULT_REFERENCE_LOOP_OR_END_TAG, new GrammarAction("Store ldapUrl value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchResultReference searchResultReference = ldapMessageContainer.getLdapMessage().getSearchResultReference();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapURL url = LdapURL.EMPTY_URL;
                if (tlv.getLength().getLength() == 0) {
                    searchResultReference.addSearchResultReference(url);
                } else {
                    try {
                        url = new LdapURL(tlv.getValue().getData());
                        searchResultReference.addSearchResultReference(url);
                    }
                    catch (LdapURLEncodingException luee) {
                        String badUrl = new String(tlv.getValue().getData());
                        log.error("The URL {} is not valid : {}", (Object)badUrl, (Object)luee.getMessage());
                        throw new DecoderException("Invalid URL : " + luee.getMessage());
                    }
                }
                log.debug("Search reference URL found : {}", (Object)url);
                ldapMessageContainer.grammarEndAllowed(true);
                ldapMessageContainer.grammarPopAllowed(true);
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

