/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.modifyDn;

import javax.naming.InvalidNameException;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.BooleanDecoder;
import org.apache.directory.shared.asn1.util.BooleanDecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.ResponseCarryingException;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNRequest;
import org.apache.directory.shared.ldap.message.ModifyDnResponseImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyDNRequestGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)ModifyDNRequestGrammar.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private static IGrammar instance = new ModifyDNRequestGrammar();

    private ModifyDNRequestGrammar() {
        this.name = ModifyDNRequestGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_MODIFY_DN_REQUEST_STATE][256];
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_TAG][108] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_TAG, LdapStatesEnum.MODIFY_DN_REQUEST_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_VALUE][108] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_VALUE, LdapStatesEnum.MODIFY_DN_REQUEST_ENTRY_TAG, new GrammarAction("Init Modify DN Request"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new ModifyDNRequest());
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_ENTRY_TAG][4] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_ENTRY_TAG, LdapStatesEnum.MODIFY_DN_REQUEST_ENTRY_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_ENTRY_VALUE][4] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_ENTRY_VALUE, LdapStatesEnum.MODIFY_DN_REQUEST_NEW_RDN_TAG, new GrammarAction("Store entry"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyDNRequest modifyDNRequest = ldapMessage.getModifyDNRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapDN entry = null;
                if (tlv.getLength().getLength() == 0) {
                    throw new DecoderException("The entry must nut be null");
                }
                byte[] dnBytes = tlv.getValue().getData();
                try {
                    entry = new LdapDN(dnBytes);
                }
                catch (InvalidNameException ine) {
                    String msg = "Invalid DN given : " + StringTools.utf8ToString(dnBytes) + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                    log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                    ModifyDnResponseImpl response = new ModifyDnResponseImpl(ldapMessage.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDDNSYNTAX, LdapDN.EMPTY_LDAPDN, ine);
                }
                modifyDNRequest.setEntry(entry);
                if (IS_DEBUG) {
                    log.debug("Modifying DN {}", (Object)entry);
                }
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_NEW_RDN_TAG][4] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_NEW_RDN_TAG, LdapStatesEnum.MODIFY_DN_REQUEST_NEW_RDN_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_NEW_RDN_VALUE][4] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_NEW_RDN_VALUE, LdapStatesEnum.MODIFY_DN_REQUEST_DELETE_OLD_RDN_TAG, new GrammarAction("Store new RDN"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyDNRequest modifyDNRequest = ldapMessage.getModifyDNRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Rdn newRdn = null;
                if (tlv.getLength().getLength() == 0) {
                    String msg = "The newrdn must not be null";
                    log.error(msg);
                    ModifyDnResponseImpl response = new ModifyDnResponseImpl(ldapMessage.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDDNSYNTAX, modifyDNRequest.getEntry(), null);
                }
                byte[] dnBytes = tlv.getValue().getData();
                try {
                    LdapDN dn = new LdapDN(dnBytes);
                    newRdn = dn.getRdn(0);
                }
                catch (InvalidNameException ine) {
                    String msg = "Invalid new RDN given : " + StringTools.utf8ToString(dnBytes) + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                    log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                    ModifyDnResponseImpl response = new ModifyDnResponseImpl(ldapMessage.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDDNSYNTAX, modifyDNRequest.getEntry(), ine);
                }
                modifyDNRequest.setNewRDN(newRdn);
                if (IS_DEBUG) {
                    log.debug("Modifying with new RDN {}", (Object)newRdn);
                }
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_DELETE_OLD_RDN_TAG][1] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_DELETE_OLD_RDN_TAG, LdapStatesEnum.MODIFY_DN_REQUEST_DELETE_OLD_RDN_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_DELETE_OLD_RDN_VALUE][1] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_DELETE_OLD_RDN_VALUE, LdapStatesEnum.MODIFY_DN_REQUEST_NEW_SUPERIOR_TAG, new GrammarAction("Store matching dnAttributes Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                ModifyDNRequest modifyDNRequest = ldapMessage.getModifyDNRequest();
                Value value = tlv.getValue();
                try {
                    modifyDNRequest.setDeleteOldRDN(BooleanDecoder.parse((Value)value));
                }
                catch (BooleanDecoderException bde) {
                    log.error("The oldRDN flag {} is invalid : {}. It should be 0 or 255", (Object)StringTools.dumpBytes(value.getData()), (Object)bde.getMessage());
                    throw new DecoderException(bde.getMessage());
                }
                ldapMessageContainer.grammarEndAllowed(true);
                ldapMessageContainer.grammarPopAllowed(true);
                if (IS_DEBUG) {
                    if (modifyDNRequest.isDeleteOldRDN()) {
                        log.debug(" Old RDN attributes will be deleted");
                    } else {
                        log.debug(" Old RDN attributes will be retained");
                    }
                }
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_NEW_SUPERIOR_TAG][128] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_NEW_SUPERIOR_TAG, LdapStatesEnum.MODIFY_DN_REQUEST_NEW_SUPERIOR_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_NEW_SUPERIOR_VALUE][128] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_NEW_SUPERIOR_VALUE, -1, new GrammarAction("Store new superior"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyDNRequest modifyDNRequest = ldapMessage.getModifyDNRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapDN newSuperior = LdapDN.EMPTY_LDAPDN;
                if (tlv.getLength().getLength() == 0) {
                    if (modifyDNRequest.isDeleteOldRDN()) {
                        throw new DecoderException("The new superior must nut be null if the flag 'delete old DN' is set to true");
                    }
                    log.warn("The new superior is null, so we will change the entry");
                    modifyDNRequest.setNewSuperior(newSuperior);
                } else {
                    byte[] dnBytes = tlv.getValue().getData();
                    try {
                        newSuperior = new LdapDN(dnBytes);
                    }
                    catch (InvalidNameException ine) {
                        String msg = "Invalid new superior DN given : " + StringTools.utf8ToString(dnBytes) + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                        log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        ModifyDnResponseImpl response = new ModifyDnResponseImpl(ldapMessage.getMessageId());
                        throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDDNSYNTAX, modifyDNRequest.getEntry(), ine);
                    }
                    modifyDNRequest.setNewSuperior(newSuperior);
                }
                ldapMessageContainer.grammarEndAllowed(true);
                ldapMessageContainer.grammarPopAllowed(true);
                if (IS_DEBUG) {
                    log.debug("New superior DN {}", (Object)newSuperior);
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

