/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.extended.operations;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.shared.asn1.ber.tlv.Length;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.extended.operations.GracefulAction;
import org.apache.directory.shared.ldap.codec.util.LdapURL;

public class GracefulDisconnect
extends GracefulAction {
    private List replicatedContexts = new ArrayList(2);
    private transient int gracefulDisconnectSequenceLength;
    private transient int replicatedContextsLength;

    public GracefulDisconnect(int timeOffline, int delay) {
        super(timeOffline, delay);
    }

    public GracefulDisconnect() {
    }

    public List getReplicatedContexts() {
        return this.replicatedContexts;
    }

    public void addReplicatedContexts(LdapURL replicatedContext) {
        this.replicatedContexts.add(replicatedContext);
    }

    public int computeLength() {
        this.gracefulDisconnectSequenceLength = 0;
        if (this.timeOffline != 0) {
            this.gracefulDisconnectSequenceLength += 2 + Value.getNbBytes((int)this.timeOffline);
        }
        if (this.delay != 0) {
            this.gracefulDisconnectSequenceLength += 2 + Value.getNbBytes((int)this.delay);
        }
        if (this.replicatedContexts.size() > 0) {
            this.replicatedContextsLength = 0;
            Iterator replicatedContextIterator = this.replicatedContexts.iterator();
            while (replicatedContextIterator.hasNext()) {
                int ldapUrlLength = ((LdapURL)replicatedContextIterator.next()).getNbBytes();
                this.replicatedContextsLength += 1 + Length.getNbBytes((int)ldapUrlLength) + ldapUrlLength;
            }
            this.gracefulDisconnectSequenceLength += 1 + Length.getNbBytes((int)this.replicatedContextsLength) + this.replicatedContextsLength;
        }
        return 1 + Length.getNbBytes((int)this.gracefulDisconnectSequenceLength) + this.gracefulDisconnectSequenceLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        bb.put((byte)48);
        bb.put(Length.getBytes((int)this.gracefulDisconnectSequenceLength));
        if (this.timeOffline != 0) {
            Value.encode((ByteBuffer)bb, (int)this.timeOffline);
        }
        if (this.delay != 0) {
            bb.put((byte)-128);
            bb.put((byte)Length.getNbBytes((int)this.delay));
            bb.put(Value.getBytes((int)this.delay));
        }
        if (this.replicatedContexts.size() != 0) {
            bb.put((byte)48);
            bb.put(Length.getBytes((int)this.replicatedContextsLength));
            Iterator replicatedContextIterator = this.replicatedContexts.iterator();
            while (replicatedContextIterator.hasNext()) {
                LdapURL url = (LdapURL)replicatedContextIterator.next();
                Value.encode((ByteBuffer)bb, (byte[])url.getBytes());
            }
        }
        return bb;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Graceful Disconnect extended operation");
        sb.append("    TimeOffline : ").append(this.timeOffline).append('\n');
        sb.append("    Delay : ").append(this.delay).append('\n');
        if (this.replicatedContexts.size() != 0) {
            Iterator replicatedContextIterator = this.replicatedContexts.iterator();
            sb.append("    Replicated contexts :");
            while (replicatedContextIterator.hasNext()) {
                LdapURL url = (LdapURL)replicatedContextIterator.next();
                sb.append("\n        ").append(url.toString());
            }
        }
        return sb.toString();
    }
}

