/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.extended;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.extended.ExtendedRequest;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedRequestGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)ExtendedRequestGrammar.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private static IGrammar instance = new ExtendedRequestGrammar();

    private ExtendedRequestGrammar() {
        this.name = ExtendedRequestGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_EXTENDED_REQUEST_STATE][256];
        this.transitions[LdapStatesEnum.EXTENDED_REQUEST_TAG][119] = new GrammarTransition(LdapStatesEnum.EXTENDED_REQUEST_TAG, LdapStatesEnum.EXTENDED_REQUEST_VALUE, null);
        this.transitions[LdapStatesEnum.EXTENDED_REQUEST_VALUE][119] = new GrammarTransition(LdapStatesEnum.EXTENDED_REQUEST_VALUE, LdapStatesEnum.EXTENDED_REQUEST_NAME_TAG, new GrammarAction("Init Extended Request"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new ExtendedRequest());
            }
        });
        this.transitions[LdapStatesEnum.EXTENDED_REQUEST_NAME_TAG][128] = new GrammarTransition(LdapStatesEnum.EXTENDED_REQUEST_NAME_TAG, LdapStatesEnum.EXTENDED_REQUEST_NAME_VALUE, null);
        this.transitions[LdapStatesEnum.EXTENDED_REQUEST_NAME_VALUE][128] = new GrammarTransition(LdapStatesEnum.EXTENDED_REQUEST_NAME_VALUE, LdapStatesEnum.EXTENDED_REQUEST_VALUE_TAG, new GrammarAction("Store name"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ExtendedRequest extendedRequest = ldapMessage.getExtendedRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    log.error("The name must not be null");
                    throw new DecoderException("The name must not be null");
                }
                byte[] requestNameBytes = tlv.getValue().getData();
                try {
                    OID oid = new OID(StringTools.utf8ToString(requestNameBytes));
                    extendedRequest.setRequestName(oid);
                }
                catch (DecoderException de) {
                    String msg = "The Request name is not a valid OID : " + StringTools.utf8ToString(requestNameBytes) + " (" + StringTools.dumpBytes(requestNameBytes) + ") is invalid";
                    log.error("{} : {}", (Object)msg, (Object)de.getMessage());
                    throw de;
                }
                ldapMessageContainer.grammarEndAllowed(true);
                ldapMessageContainer.grammarPopAllowed(true);
                if (IS_DEBUG) {
                    log.debug("OID read : {}", (Object)extendedRequest.getRequestName());
                }
            }
        });
        this.transitions[LdapStatesEnum.EXTENDED_REQUEST_VALUE_TAG][129] = new GrammarTransition(LdapStatesEnum.EXTENDED_REQUEST_VALUE_TAG, LdapStatesEnum.EXTENDED_REQUEST_VALUE_VALUE, null);
        this.transitions[LdapStatesEnum.EXTENDED_REQUEST_VALUE_VALUE][129] = new GrammarTransition(LdapStatesEnum.EXTENDED_REQUEST_VALUE_VALUE, -1, new GrammarAction("Store value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ExtendedRequest extendedRequest = ldapMessage.getExtendedRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    extendedRequest.setRequestValue(new byte[0]);
                } else {
                    extendedRequest.setRequestValue(tlv.getValue().getData());
                }
                ldapMessageContainer.grammarEndAllowed(true);
                ldapMessageContainer.grammarPopAllowed(true);
                if (IS_DEBUG) {
                    log.debug("Extended value : {}", (Object)extendedRequest.getRequestValue());
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

