/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.bind;

import javax.naming.InvalidNameException;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.ResponseCarryingException;
import org.apache.directory.shared.ldap.codec.bind.BindRequest;
import org.apache.directory.shared.ldap.codec.bind.SaslCredentials;
import org.apache.directory.shared.ldap.codec.bind.SimpleAuthentication;
import org.apache.directory.shared.ldap.codec.util.LdapString;
import org.apache.directory.shared.ldap.codec.util.LdapStringEncodingException;
import org.apache.directory.shared.ldap.message.BindResponseImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindRequestGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)BindRequestGrammar.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private static IGrammar instance = new BindRequestGrammar();

    public static IGrammar getInstance() {
        return instance;
    }

    private BindRequestGrammar() {
        this.name = BindRequestGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_BIND_REQUEST_STATE][256];
        this.transitions[LdapStatesEnum.BIND_REQUEST_TAG][96] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_TAG, LdapStatesEnum.BIND_REQUEST_VALUE, null);
        this.transitions[LdapStatesEnum.BIND_REQUEST_VALUE][96] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_VALUE, LdapStatesEnum.BIND_REQUEST_VERSION_TAG, new GrammarAction("Init BindRequest"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    String msg = "The BindRequest must not be null";
                    log.error(msg);
                    throw new DecoderException(msg);
                }
                ldapMessage.setProtocolOP(new BindRequest());
            }
        });
        this.transitions[LdapStatesEnum.BIND_REQUEST_VERSION_TAG][2] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_VERSION_TAG, LdapStatesEnum.BIND_REQUEST_VERSION_VALUE, null);
        this.transitions[LdapStatesEnum.BIND_REQUEST_VERSION_VALUE][2] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_VERSION_VALUE, LdapStatesEnum.BIND_REQUEST_NAME_TAG, new GrammarAction("Store version"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                BindRequest bindRequestMessage = ldapMessageContainer.getLdapMessage().getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                try {
                    int version = IntegerDecoder.parse((Value)value, (int)1, (int)127);
                    if (IS_DEBUG) {
                        log.debug("Ldap version ", (Object)new Integer(version));
                    }
                    bindRequestMessage.setVersion(version);
                }
                catch (IntegerDecoderException ide) {
                    log.error("The version {} is invalid : {}. The version must be between (0 .. 127)", (Object)StringTools.dumpBytes(value.getData()), (Object)ide.getMessage());
                    throw new DecoderException(ide.getMessage());
                }
            }
        });
        this.transitions[LdapStatesEnum.BIND_REQUEST_NAME_TAG][4] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_NAME_TAG, LdapStatesEnum.BIND_REQUEST_NAME_VALUE, null);
        this.transitions[LdapStatesEnum.BIND_REQUEST_NAME_VALUE][4] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_NAME_VALUE, LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CHOICE_TAG, new GrammarAction("Store Bind Name value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                BindRequest bindRequestMessage = ldapMessage.getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    bindRequestMessage.setName(LdapDN.EMPTY_LDAPDN);
                } else {
                    LdapDN name = LdapDN.EMPTY_LDAPDN;
                    byte[] dnBytes = tlv.getValue().getData();
                    try {
                        name = new LdapDN(dnBytes);
                    }
                    catch (InvalidNameException ine) {
                        String msg = "Incorrect DN given : " + StringTools.utf8ToString(dnBytes) + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                        log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        BindResponseImpl response = new BindResponseImpl(ldapMessage.getMessageId());
                        throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDDNSYNTAX, LdapDN.EMPTY_LDAPDN, ine);
                    }
                    bindRequestMessage.setName(name);
                }
                if (IS_DEBUG) {
                    log.debug(" The Bind name is {}", (Object)bindRequestMessage.getName());
                }
            }
        });
        this.transitions[LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CHOICE_TAG][128] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CHOICE_TAG, LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_SIMPLE_VALUE, null);
        this.transitions[LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_SIMPLE_VALUE][128] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_SIMPLE_VALUE, -1, new GrammarAction("Store Bind Simple Authentication value"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                BindRequest bindRequestMessage = ldapMessageContainer.getLdapMessage().getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SimpleAuthentication authentication = null;
                authentication = new SimpleAuthentication();
                authentication.setParent(bindRequestMessage);
                bindRequestMessage.setAuthentication(authentication);
                if (tlv.getLength().getLength() == 0) {
                    authentication.setSimple(new byte[0]);
                } else {
                    authentication.setSimple(tlv.getValue().getData());
                }
                ldapMessageContainer.grammarEndAllowed(true);
                ldapMessageContainer.grammarPopAllowed(true);
                if (IS_DEBUG) {
                    log.debug("The simple authentication is : {}", (Object)authentication.getSimple());
                }
            }
        });
        this.transitions[LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CHOICE_TAG][163] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CHOICE_TAG, LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_SASL_VALUE, null);
        this.transitions[LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_SASL_VALUE][163] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CHOICE_TAG, LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_MECHANISM_TAG, new GrammarAction("Create Bind sasl Authentication Object"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                BindRequest bindRequestMessage = ldapMessage.getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    String msg = "The SaslCredential must not be null";
                    log.error(msg);
                    BindResponseImpl response = new BindResponseImpl(ldapMessage.getMessageId());
                    throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDCREDENTIALS, bindRequestMessage.getName(), null);
                }
                SaslCredentials authentication = new SaslCredentials();
                authentication.setParent(bindRequestMessage);
                bindRequestMessage.setAuthentication(authentication);
                if (IS_DEBUG) {
                    log.debug("The SaslCredential has been created");
                }
            }
        });
        this.transitions[LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_MECHANISM_TAG][4] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_MECHANISM_TAG, LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_MECHANISM_VALUE, null);
        this.transitions[LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_MECHANISM_VALUE][4] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_MECHANISM_VALUE, LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CREDENTIALS_TAG, new GrammarAction("Create Bind sasl Authentication Object"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                BindRequest bindRequestMessage = ldapMessage.getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SaslCredentials authentication = bindRequestMessage.getSaslAuthentication();
                if (tlv.getLength().getLength() == 0) {
                    authentication.setMechanism(LdapString.EMPTY_STRING);
                } else {
                    try {
                        authentication.setMechanism(new LdapString(tlv.getValue().getData()));
                    }
                    catch (LdapStringEncodingException lsee) {
                        String msg = "Invalid mechanism : " + StringTools.dumpBytes(tlv.getValue().getData());
                        log.error("{} : {}", (Object)msg, (Object)lsee.getMessage());
                        BindResponseImpl response = new BindResponseImpl(ldapMessage.getMessageId());
                        throw new ResponseCarryingException(msg, response, ResultCodeEnum.INAPPROPRIATEAUTHENTICATION, bindRequestMessage.getName(), lsee);
                    }
                }
                ldapMessageContainer.grammarEndAllowed(true);
                ldapMessageContainer.grammarPopAllowed(true);
                if (IS_DEBUG) {
                    log.debug("The mechanism is : {}", (Object)authentication.getMechanism());
                }
            }
        });
        this.transitions[LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CREDENTIALS_TAG][4] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CREDENTIALS_TAG, LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CREDENTIALS_VALUE, null);
        this.transitions[LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CREDENTIALS_VALUE][4] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CREDENTIALS_VALUE, -1, new GrammarAction("Store Bind sasl Authentication credentials value"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                BindRequest bindRequestMessage = ldapMessageContainer.getLdapMessage().getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SaslCredentials credentials = bindRequestMessage.getSaslAuthentication();
                if (tlv.getLength().getLength() == 0) {
                    credentials.setCredentials(new byte[0]);
                } else {
                    credentials.setCredentials(tlv.getValue().getData());
                }
                ldapMessageContainer.grammarEndAllowed(true);
                ldapMessageContainer.grammarPopAllowed(true);
                if (IS_DEBUG) {
                    log.debug("The credentials are : {}", (Object)credentials.getCredentials());
                }
            }
        });
    }
}

