/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema;

import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.name.DnParser;
import org.apache.directory.shared.ldap.name.NameComponentNormalizer;
import org.apache.directory.shared.ldap.name.SimpleNameComponentNormalizer;
import org.apache.directory.shared.ldap.schema.DeepTrimToLowerNormalizer;
import org.apache.directory.shared.ldap.schema.Normalizer;

public class DnNormalizer
implements Normalizer {
    private NameParser parser = null;

    public DnNormalizer() throws NamingException {
        this(new SimpleNameComponentNormalizer(new DeepTrimToLowerNormalizer()));
    }

    public DnNormalizer(Normalizer normalizer) throws NamingException {
        this(new SimpleNameComponentNormalizer(normalizer));
    }

    public DnNormalizer(NameComponentNormalizer normalizer) throws NamingException {
        this.parser = new DnParser(normalizer);
    }

    public Object normalize(Object value) throws NamingException {
        if (value == null) {
            return null;
        }
        String str = null;
        if (value instanceof Name) {
            str = value.toString();
        } else if (value instanceof String) {
            str = (String)value;
        }
        return this.parser.parse(str).toString();
    }
}

