/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.ldif;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifParser;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.util.Base64;

public class LdifParserImpl
implements LdifParser {
    public byte[] base64decode(String attrValue) {
        return Base64.decode(attrValue.toCharArray());
    }

    public synchronized void parse(Attributes attributes, String ldif) throws NamingException {
        boolean isBase64Encoded = false;
        int lineCount = 0;
        StringReader strIn = new StringReader(ldif);
        BufferedReader in = new BufferedReader(strIn);
        try {
            String line;
            while ((line = in.readLine()) != null) {
                String attrValue;
                int asteriskIndex = line.indexOf(35);
                if (asteriskIndex != -1 && (asteriskIndex < 3 || (line = line.substring(0, asteriskIndex).trim()).equals(""))) continue;
                int index = line.indexOf(58);
                if (index == -1) {
                    throw new LdapNamingException("Line " + lineCount + " [" + line + "] does not correspond to an LDIF entry " + "attribute value pair.\n{" + ldif + "}", ResultCodeEnum.OTHER);
                }
                String attrName = line.substring(0, index).trim();
                if (line.length() <= index + 1) continue;
                if (line.charAt(++index) == ':') {
                    isBase64Encoded = true;
                }
                try {
                    while (line.length() <= index + 1 && line.charAt(++index) == ' ') {
                    }
                    attrValue = line.substring(index + 1);
                }
                catch (StringIndexOutOfBoundsException e) {
                    attrValue = "";
                }
                if (isBase64Encoded && attrValue != null) {
                    byte[] value = this.base64decode(attrValue);
                    if (attributes.get(attrName) == null) {
                        attributes.put(attrName, value);
                    } else {
                        Attribute attribute = attributes.get(attrName);
                        attribute.add(value);
                    }
                    isBase64Encoded = false;
                    continue;
                }
                if (attributes.get(attrName) == null) {
                    attributes.put(attrName, attrValue);
                    continue;
                }
                Attribute attribute = attributes.get(attrName);
                attribute.add(attrValue);
            }
        }
        catch (IOException e) {
            throw new LdapNamingException(ResultCodeEnum.OTHER);
        }
    }

    public LdifEntry parse(String an_ldif) throws NamingException {
        boolean l_isBase64Encoded = false;
        int l_lineCount = 0;
        String l_attrName = new String();
        String l_attrValue = new String();
        String l_prevAttrValue = null;
        StringReader l_strIn = new StringReader(an_ldif);
        BufferedReader l_in = new BufferedReader(l_strIn);
        LdifEntry l_entry = new LdifEntry();
        int l_currentModOp = -1;
        try {
            String l_line;
            while ((l_line = l_in.readLine()) != null) {
                if (l_line.equalsIgnoreCase("-")) {
                    if (l_prevAttrValue != null) {
                        if (l_entry.getModType().equalsIgnoreCase("modify")) {
                            if (l_currentModOp == -1) {
                                throw new LdapNamingException("A modification type must be supplied for a change type of modify", ResultCodeEnum.OTHER);
                            }
                            l_entry.addModificationItem(l_currentModOp, l_attrName, l_attrValue);
                        } else if (l_isBase64Encoded && l_attrValue != null) {
                            l_entry.addAttribute(l_attrName, this.base64decode(l_attrValue));
                            l_isBase64Encoded = false;
                        } else {
                            l_entry.addAttribute(l_attrName, l_attrValue);
                        }
                    }
                    l_currentModOp = -1;
                    l_prevAttrValue = null;
                    continue;
                }
                int l_index = l_line.indexOf(58);
                if (l_index == -1) {
                    throw new LdapNamingException("Line " + l_lineCount + " [" + l_line + "] does not correspond to an LDIF entry " + "attribute value pair.\n{" + an_ldif + "}", ResultCodeEnum.OTHER);
                }
                l_attrName = l_line.substring(0, l_index).trim();
                if (l_line.charAt(++l_index) == ':') {
                    l_isBase64Encoded = true;
                }
                try {
                    while (l_line.charAt(++l_index) == ' ') {
                    }
                    l_attrValue = l_line.substring(l_index);
                }
                catch (StringIndexOutOfBoundsException e) {
                    l_attrValue = "";
                }
                if (l_attrName.equalsIgnoreCase("dn")) {
                    l_entry.setDn(l_attrValue);
                    continue;
                }
                if (l_attrName.equalsIgnoreCase("version")) {
                    l_entry.setVersion(Integer.parseInt(l_attrValue));
                    continue;
                }
                if (l_attrName.equalsIgnoreCase("control")) continue;
                if (l_attrName.equalsIgnoreCase("changetype")) {
                    l_entry.setModType(l_attrValue);
                    continue;
                }
                if (l_attrName.equalsIgnoreCase("add")) {
                    if (!l_entry.getModType().equalsIgnoreCase("modify")) {
                        throw new LdapNamingException("Cannot use modification " + l_attrName + " identifier on " + l_entry.getModType() + " change type", ResultCodeEnum.OTHER);
                    }
                    l_currentModOp = 1;
                    continue;
                }
                if (l_attrName.equalsIgnoreCase("replace")) {
                    if (!l_entry.getModType().equalsIgnoreCase("modify")) {
                        throw new LdapNamingException("Cannot use modification " + l_attrName + " identifier on " + l_entry.getModType() + " change type", ResultCodeEnum.OTHER);
                    }
                    l_currentModOp = 2;
                    continue;
                }
                if (l_attrName.equalsIgnoreCase("delete")) {
                    if (!l_entry.getModType().equalsIgnoreCase("modify")) {
                        throw new LdapNamingException("Cannot use modification " + l_attrName + " identifier on " + l_entry.getModType() + " change type", ResultCodeEnum.OTHER);
                    }
                    l_currentModOp = 3;
                    if (l_attrValue == null) continue;
                    l_prevAttrValue = l_attrValue;
                    continue;
                }
                if (l_entry.getModType().equalsIgnoreCase("modify")) {
                    if (l_currentModOp == -1) {
                        throw new LdapNamingException("A modification type must be supplied for a change type of modify", ResultCodeEnum.OTHER);
                    }
                    l_entry.addModificationItem(l_currentModOp, l_attrName, l_attrValue);
                    continue;
                }
                if (l_isBase64Encoded && l_attrValue != null) {
                    l_entry.addAttribute(l_attrName, this.base64decode(l_attrValue));
                    l_isBase64Encoded = false;
                    continue;
                }
                l_entry.addAttribute(l_attrName, l_attrValue);
            }
            return l_entry;
        }
        catch (IOException e) {
            throw new LdapNamingException(e.getMessage(), ResultCodeEnum.OTHER);
        }
    }
}

