/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.unbind;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.unbind.UnBindRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnBindRequestGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)UnBindRequestGrammar.class);
    private static IGrammar instance = new UnBindRequestGrammar();

    public static IGrammar getInstance() {
        return instance;
    }

    private UnBindRequestGrammar() {
        this.name = UnBindRequestGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_UNBIND_REQUEST_STATE][256];
        this.transitions[LdapStatesEnum.UNBIND_REQUEST_TAG][66] = new GrammarTransition(LdapStatesEnum.UNBIND_REQUEST_TAG, LdapStatesEnum.UNBIND_REQUEST_VALUE, null);
        this.transitions[LdapStatesEnum.UNBIND_REQUEST_VALUE][66] = new GrammarTransition(LdapStatesEnum.UNBIND_REQUEST_VALUE, -1, new GrammarAction("Init UnBindRequest"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                UnBindRequest unBindRequest = new UnBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                int expectedLength = tlv.getLength().getLength();
                if (expectedLength != 0) {
                    log.error("The length of a UnBindRequest must be null, the actual value is {}", (Object)new Integer(expectedLength));
                    throw new DecoderException("The length of a UnBindRequest must be null");
                }
                unBindRequest.setParent(ldapMessage);
                ldapMessageContainer.grammarEndAllowed(true);
                ldapMessageContainer.grammarPopAllowed(true);
                ldapMessage.setProtocolOP(unBindRequest);
            }
        });
    }
}

