/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.modify;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.Length;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.LdapResponse;

public class ModifyResponse
extends LdapResponse {
    public int getMessageType() {
        return 14;
    }

    public int computeLength() {
        int ldapResponseLength = super.computeLength();
        return 1 + Length.getNbBytes((int)ldapResponseLength) + ldapResponseLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)103);
            buffer.put(Length.getBytes((int)this.getLdapResponseLength()));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return super.encode(buffer);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Modify Response\n");
        sb.append(super.toString());
        return sb.toString();
    }
}

