/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema;

import javax.naming.NamingException;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.DITContentRule;
import org.apache.directory.shared.ldap.schema.DITStructureRule;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.schema.NameForm;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.Syntax;

public class SchemaUtils {
    public static StringBuffer render(StringBuffer buf, String[] qdescrs) {
        if (qdescrs == null || qdescrs.length == 0) {
            return buf;
        }
        if (qdescrs.length == 1) {
            buf.append("'").append(qdescrs[0]).append("'");
        } else {
            buf.append("( ");
            for (int ii = 0; ii < qdescrs.length; ++ii) {
                buf.append("'").append(qdescrs[ii]).append("' ");
            }
            buf.append(")");
        }
        return buf;
    }

    public static StringBuffer render(String[] qdescrs) {
        StringBuffer buf = new StringBuffer();
        return SchemaUtils.render(buf, qdescrs);
    }

    public static StringBuffer render(ObjectClass[] ocs) {
        StringBuffer buf = new StringBuffer();
        return SchemaUtils.render(buf, ocs);
    }

    public static StringBuffer render(StringBuffer buf, ObjectClass[] ocs) {
        if (ocs == null || ocs.length == 0) {
            return buf;
        }
        if (ocs.length == 1) {
            buf.append(ocs[0].getName());
        } else {
            buf.append("( ");
            for (int ii = 0; ii < ocs.length; ++ii) {
                if (ii + 1 < ocs.length) {
                    buf.append(ocs[ii].getName()).append(" $ ");
                    continue;
                }
                buf.append(ocs[ii].getName());
            }
            buf.append(" )");
        }
        return buf;
    }

    public static StringBuffer render(AttributeType[] ats) {
        StringBuffer buf = new StringBuffer();
        return SchemaUtils.render(buf, ats);
    }

    public static StringBuffer render(StringBuffer buf, AttributeType[] ats) {
        if (ats == null || ats.length == 0) {
            return buf;
        }
        if (ats.length == 1) {
            buf.append(ats[0].getName());
        } else {
            buf.append("( ");
            for (int ii = 0; ii < ats.length; ++ii) {
                if (ii + 1 < ats.length) {
                    buf.append(ats[ii].getName()).append(" $ ");
                    continue;
                }
                buf.append(ats[ii].getName());
            }
            buf.append(" )");
        }
        return buf;
    }

    public static StringBuffer render(ObjectClass oc) throws NamingException {
        StringBuffer buf = new StringBuffer();
        buf.append("( ").append(oc.getOid()).append(" NAME ");
        SchemaUtils.render(buf, oc.getNames()).append(" ");
        if (oc.getDescription() != null) {
            buf.append("DESC ").append("'").append(oc.getDescription()).append("' ");
        }
        if (oc.isObsolete()) {
            buf.append(" OBSOLETE ");
        }
        if (oc.getSuperClasses() != null && oc.getSuperClasses().length > 0) {
            buf.append("SUP ");
            SchemaUtils.render(buf, oc.getSuperClasses());
        }
        if (oc.getType() != null) {
            buf.append(" ").append(oc.getType().getName());
        }
        if (oc.getMustList() != null && oc.getMustList().length > 0) {
            buf.append(" MUST ");
            SchemaUtils.render(buf, oc.getMustList());
        }
        if (oc.getMayList() != null && oc.getMayList().length > 0) {
            buf.append(" MAY ");
            SchemaUtils.render(buf, oc.getMayList());
        }
        buf.append(" )");
        return buf;
    }

    public static StringBuffer render(AttributeType at) throws NamingException {
        StringBuffer buf = new StringBuffer();
        buf.append("( ").append(at.getOid()).append(" NAME ");
        SchemaUtils.render(buf, at.getNames()).append(" ");
        if (at.getDescription() != null) {
            buf.append("DESC ").append("'").append(at.getDescription()).append("' ");
        }
        if (at.isObsolete()) {
            buf.append(" OBSOLETE");
        }
        if (at.getSuperior() != null) {
            buf.append(" SUP ").append(at.getSuperior().getName());
        }
        if (at.getEquality() != null) {
            buf.append(" EQUALITY ").append(at.getEquality().getName());
        }
        if (at.getOrdering() != null) {
            buf.append(" ORDERING ").append(at.getOrdering().getName());
        }
        if (at.getSubstr() != null) {
            buf.append(" SUBSTR ").append(at.getSubstr().getName());
        }
        if (at.getSyntax() != null) {
            buf.append(" SYNTAX ").append(at.getSyntax().getOid());
            if (at.getLength() > 0) {
                buf.append("{").append(at.getLength()).append("}");
            }
        }
        if (at.isSingleValue()) {
            buf.append(" SINGLE-VALUE");
        }
        if (at.isCollective()) {
            buf.append(" COLLECTIVE");
        }
        if (!at.isCanUserModify()) {
            buf.append(" NO-USER-MODIFICATION");
        }
        if (at.getUsage() != null) {
            buf.append(" USAGE ").append(at.getUsage().getName());
        }
        buf.append(" )");
        return buf;
    }

    public static StringBuffer render(MatchingRule mr) throws NamingException {
        StringBuffer buf = new StringBuffer();
        buf.append("( ").append(mr.getOid()).append(" NAME ");
        SchemaUtils.render(buf, mr.getNames()).append(" ");
        if (mr.getDescription() != null) {
            buf.append("DESC ").append("'").append(mr.getDescription()).append("' ");
        }
        if (mr.isObsolete()) {
            buf.append(" OBSOLETE");
        }
        if (mr.getSyntax() != null) {
            buf.append(" SYNTAX ").append(mr.getSyntax().getOid());
        }
        buf.append(" )");
        return buf;
    }

    public static StringBuffer render(Syntax syntax) {
        StringBuffer buf = new StringBuffer();
        buf.append("( ").append(syntax.getOid()).append(" NAME ");
        SchemaUtils.render(buf, syntax.getNames()).append(" ");
        if (syntax.getDescription() != null) {
            buf.append("DESC ").append("'").append(syntax.getDescription()).append("' ");
        }
        buf.append(" )");
        return buf;
    }

    public static StringBuffer render(MatchingRuleUse mru) {
        StringBuffer buf = new StringBuffer();
        buf.append("( ").append(mru.getOid()).append(" NAME ");
        SchemaUtils.render(buf, mru.getNames()).append(" ");
        if (mru.getDescription() != null) {
            buf.append("DESC ").append("'").append(mru.getDescription()).append("' ");
        }
        buf.append(" )");
        return buf;
    }

    public static StringBuffer render(DITContentRule dcr) {
        StringBuffer buf = new StringBuffer();
        buf.append("( ").append(dcr.getOid()).append(" NAME ");
        SchemaUtils.render(buf, dcr.getNames()).append(" ");
        if (dcr.getDescription() != null) {
            buf.append("DESC ").append("'").append(dcr.getDescription()).append("' ");
        }
        buf.append(" )");
        return buf;
    }

    public static StringBuffer render(DITStructureRule dsr) {
        StringBuffer buf = new StringBuffer();
        buf.append("( ").append(dsr.getOid()).append(" NAME ");
        SchemaUtils.render(buf, dsr.getNames()).append(" ");
        if (dsr.getDescription() != null) {
            buf.append("DESC ").append("'").append(dsr.getDescription()).append("' ");
        }
        buf.append(" )");
        return buf;
    }

    public static StringBuffer render(NameForm nf) {
        StringBuffer buf = new StringBuffer();
        buf.append("( ").append(nf.getOid()).append(" NAME ");
        SchemaUtils.render(buf, nf.getNames()).append(" ");
        if (nf.getDescription() != null) {
            buf.append("DESC ").append("'").append(nf.getDescription()).append("' ");
        }
        buf.append(" )");
        return buf;
    }
}

