/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.util.Arrays;
import org.apache.directory.shared.ldap.message.AbstractAbandonableRequest;
import org.apache.directory.shared.ldap.message.CompareRequest;
import org.apache.directory.shared.ldap.message.CompareResponse;
import org.apache.directory.shared.ldap.message.CompareResponseImpl;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ResultResponse;
import org.apache.directory.shared.ldap.util.StringTools;

public class CompareRequestImpl
extends AbstractAbandonableRequest
implements CompareRequest {
    static final long serialVersionUID = 1699731530016468977L;
    private String name;
    private String attrId;
    private byte[] attrVal;
    private CompareResponse response;

    public CompareRequestImpl(int id) {
        super(id, TYPE);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte[] getAssertionValue() {
        return this.attrVal;
    }

    public void setAssertionValue(String attrVal) {
        this.attrVal = StringTools.getBytesUtf8(attrVal);
    }

    public void setAssertionValue(byte[] attrVal) {
        this.attrVal = attrVal;
    }

    public String getAttributeId() {
        return this.attrId;
    }

    public void setAttributeId(String attrId) {
        this.attrId = attrId;
    }

    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    public ResultResponse getResultResponse() {
        if (this.response == null) {
            this.response = new CompareResponseImpl(this.getMessageId());
        }
        return this.response;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CompareRequest req = (CompareRequest)obj;
        if (this.name != null && req.getName() == null) {
            return false;
        }
        if (this.name == null && req.getName() != null) {
            return false;
        }
        if (this.name != null && req.getName() != null && !this.name.equals(req.getName())) {
            return false;
        }
        if (this.attrId != null && req.getAttributeId() == null) {
            return false;
        }
        if (this.attrId == null && req.getAttributeId() != null) {
            return false;
        }
        if (this.attrId != null && req.getAttributeId() != null && !this.attrId.equals(req.getAttributeId())) {
            return false;
        }
        if (this.attrVal != null && req.getAssertionValue() == null) {
            return false;
        }
        if (this.attrVal == null && req.getAssertionValue() != null) {
            return false;
        }
        return this.attrVal == null || req.getAssertionValue() == null || Arrays.equals(this.attrVal, req.getAssertionValue());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Compare request\n");
        sb.append("        Entry : '").append(this.name.toString()).append("'\n");
        sb.append("        Attribute description : '").append(this.attrId).append("'\n");
        sb.append("        Attribute value : '").append(StringTools.utf8ToString(this.attrVal)).append('/').append(StringTools.dumpBytes(this.attrVal)).append("'\n");
        return sb.toString();
    }
}

