/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.del;

import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.del.DelRequest;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelRequestGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)DelRequestGrammar.class);
    private static IGrammar instance = new DelRequestGrammar();

    private DelRequestGrammar() {
        this.name = DelRequestGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_DEL_REQUEST_STATE][256];
        this.transitions[LdapStatesEnum.DEL_REQUEST_TAG][74] = new GrammarTransition(LdapStatesEnum.DEL_REQUEST_TAG, LdapStatesEnum.DEL_REQUEST_VALUE, null);
        this.transitions[LdapStatesEnum.DEL_REQUEST_VALUE][74] = new GrammarTransition(LdapStatesEnum.DEL_REQUEST_VALUE, -1, new GrammarAction("Init del Request"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                DelRequest delRequest = new DelRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Name entry = null;
                if (tlv.getLength().getLength() == 0) {
                    throw new DecoderException("The entry must not be null");
                }
                try {
                    entry = new LdapDN(tlv.getValue().getData());
                    entry = LdapDN.normalize(entry);
                }
                catch (InvalidNameException ine) {
                    String msg = "The DN to delete  (" + StringTools.dumpBytes(tlv.getValue().getData()) + ") is invalid";
                    log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                    throw new DecoderException(msg, (Throwable)ine);
                }
                catch (NamingException ne) {
                    String msg = "The DN to delete  (" + StringTools.dumpBytes(tlv.getValue().getData()) + ") is invalid";
                    log.error("{} : {}", (Object)msg, (Object)ne.getMessage());
                    throw new DecoderException(msg, (Throwable)ne);
                }
                delRequest.setEntry(entry);
                ldapMessage.setProtocolOP(delRequest);
                ldapMessageContainer.grammarEndAllowed(true);
                ldapMessageContainer.grammarPopAllowed(true);
                if (log.isDebugEnabled()) {
                    log.debug("Deleting DN {}", (Object)entry);
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

