/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search.controls.subentries;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.controls.AbstractControl;
import org.apache.directory.shared.ldap.codec.search.controls.subentries.SubentriesControlDecoder;

public class SubentriesControl
extends AbstractControl {
    public static final String CONTROL_OID = "1.3.6.1.4.1.4203.1.10.1";
    private boolean visibility = false;

    public SubentriesControl() {
        super(CONTROL_OID);
        this.decoder = new SubentriesControlDecoder();
    }

    public boolean isVisible() {
        return this.visibility;
    }

    public void setVisibility(boolean visibility) {
        this.visibility = visibility;
    }

    public int computeLength() {
        int subentriesLength;
        int valueLength = subentriesLength = 3;
        return super.computeLength(valueLength);
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((String)"ERR_04023", (Object[])new Object[0]));
        }
        super.encode(buffer);
        buffer.put((byte)4);
        buffer.put(TLV.getBytes((int)this.valueLength));
        Value.encode((ByteBuffer)buffer, (boolean)this.visibility);
        return buffer;
    }

    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                Value.encode((ByteBuffer)buffer, (boolean)this.visibility);
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Subentries Control\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        Visibility   : '").append(this.visibility).append("'\n");
        return sb.toString();
    }
}

