/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.controls;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.controls.CodecControl;
import org.apache.directory.shared.ldap.codec.controls.ControlDecoder;
import org.apache.directory.shared.ldap.message.control.Control;
import org.apache.directory.shared.ldap.util.StringTools;

public abstract class AbstractControl
extends AbstractAsn1Object
implements Control,
CodecControl {
    private String oid;
    private boolean criticality = false;
    protected byte[] value;
    protected int valueLength;
    private int controlLength;
    protected ControlDecoder decoder;

    public AbstractControl(String oid) {
        this.oid = oid;
    }

    public String getOid() {
        return this.oid == null ? "" : this.oid;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        if (value != null) {
            this.value = new byte[value.length];
            System.arraycopy(value, 0, this.value, 0, value.length);
        } else {
            this.value = null;
        }
    }

    public boolean isCritical() {
        return this.criticality;
    }

    public void setCritical(boolean criticality) {
        this.criticality = criticality;
    }

    public int computeLength() {
        return 0;
    }

    public int computeLength(int valueLength) {
        int oidLengh = StringTools.getBytesUtf8(this.oid).length;
        this.controlLength = 1 + TLV.getNbBytes((int)oidLengh) + oidLengh;
        if (this.criticality) {
            this.controlLength += 3;
        }
        this.valueLength = valueLength;
        if (valueLength != 0) {
            this.controlLength += 1 + TLV.getNbBytes((int)valueLength) + valueLength;
        }
        return 1 + TLV.getNbBytes((int)this.controlLength) + this.controlLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((String)"ERR_04023", (Object[])new Object[0]));
        }
        try {
            buffer.put((byte)48);
            buffer.put(TLV.getBytes((int)this.controlLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((String)"ERR_04005", (Object[])new Object[0]));
        }
        Value.encode((ByteBuffer)buffer, (byte[])this.getOid().getBytes());
        if (this.criticality) {
            Value.encode((ByteBuffer)buffer, (boolean)this.criticality);
        }
        return buffer;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public ControlDecoder getDecoder() {
        return this.decoder;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Control\n");
        sb.append("        Control oid : '").append(this.oid).append("'\n");
        sb.append("        Criticality : '").append(this.criticality).append("'\n");
        if (this.value != null) {
            sb.append("        Control value : '").append(StringTools.dumpBytes(this.value)).append("'\n");
        }
        return sb.toString();
    }
}

