/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.subtree;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.Map;
import org.apache.directory.shared.ldap.schema.NormalizerMappingResolver;
import org.apache.directory.shared.ldap.schema.normalizers.OidNormalizer;
import org.apache.directory.shared.ldap.subtree.ReusableAntlrSubtreeSpecificationLexer;
import org.apache.directory.shared.ldap.subtree.ReusableAntlrSubtreeSpecificationParser;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubtreeSpecificationParser {
    private ReusableAntlrSubtreeSpecificationParser parser;
    private ReusableAntlrSubtreeSpecificationLexer lexer;
    private final boolean isNormalizing;

    public SubtreeSpecificationParser(Map<String, OidNormalizer> oidsMap) {
        StringReader in = new StringReader("");
        this.lexer = new ReusableAntlrSubtreeSpecificationLexer(in);
        this.parser = new ReusableAntlrSubtreeSpecificationParser(this.lexer);
        this.parser.init(oidsMap);
        this.isNormalizing = false;
    }

    public SubtreeSpecificationParser(NormalizerMappingResolver resolver, Map<String, OidNormalizer> oidsMap) {
        StringReader in = new StringReader("");
        this.lexer = new ReusableAntlrSubtreeSpecificationLexer(in);
        this.parser = new ReusableAntlrSubtreeSpecificationParser(this.lexer);
        this.parser.setNormalizerMappingResolver(resolver);
        this.parser.init(oidsMap);
        this.isNormalizing = true;
    }

    private synchronized void reset(String spec) {
        StringReader in = new StringReader(spec + "end");
        this.lexer.prepareNextInput(in);
        this.parser.resetState();
    }

    public synchronized SubtreeSpecification parse(String spec) throws ParseException {
        SubtreeSpecification ss = null;
        if (spec == null || spec.trim().equals("")) {
            return null;
        }
        this.reset(spec);
        try {
            ss = this.parser.wrapperEntryPoint();
        }
        catch (TokenStreamException e) {
            String msg = "Parser failure on subtree specification:\n\t" + spec;
            msg = msg + "\nAntlr exception trace:\n" + e.getMessage();
            throw new ParseException(msg, 0);
        }
        catch (RecognitionException e) {
            String msg = "Parser failure on subtree specification:\n\t" + spec;
            msg = msg + "\nAntlr exception trace:\n" + e.getMessage();
            throw new ParseException(msg, e.getColumn());
        }
        catch (Exception e) {
            String msg = "Parser failure on subtree specification:\n\t" + spec;
            msg = msg + "\nAntlr exception trace:\n" + e.getMessage();
            throw new ParseException(msg, 0);
        }
        return ss;
    }

    public boolean isNormizing() {
        return this.isNormalizing;
    }
}

