/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema;

import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.util.ArrayUtils;

public abstract class AbstractSchemaObject
implements SchemaObject {
    protected final String oid;
    private int hash;
    protected boolean isObsolete;
    protected String[] names = ArrayUtils.EMPTY_STRING_ARRAY;
    protected String description;
    protected String schema;

    protected AbstractSchemaObject(String oid) {
        this(oid, ArrayUtils.EMPTY_STRING_ARRAY, false, null);
        this.hash = oid.hashCode();
    }

    protected AbstractSchemaObject(String oid, String[] names) {
        this(oid, names, false, null);
        this.hash = oid.hashCode();
    }

    protected AbstractSchemaObject(String oid, String[] names, boolean isObsolete) {
        this(oid, names, isObsolete, null);
        this.hash = oid.hashCode();
    }

    protected AbstractSchemaObject(String oid, String name, boolean isObsolete) {
        this(oid, new String[]{name}, isObsolete, null);
        this.hash = oid.hashCode();
    }

    protected AbstractSchemaObject(String oid, boolean isObsolete) {
        this(oid, null, isObsolete, null);
        this.hash = oid.hashCode();
    }

    protected AbstractSchemaObject(String oid, String description) {
        this(oid, null, false, description);
        this.hash = oid.hashCode();
    }

    protected AbstractSchemaObject(String oid, String[] names, boolean isObsolete, String description) {
        if (oid == null) {
            throw new NullPointerException("oid cannot be null");
        }
        this.oid = oid;
        this.isObsolete = isObsolete;
        this.description = description;
        if (names != null) {
            this.names = new String[names.length];
            System.arraycopy(names, 0, this.names, 0, names.length);
        }
        this.hash = oid.hashCode();
    }

    public String getOid() {
        return this.oid;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public String[] getNamesRef() {
        return this.names;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.names == null || this.names.length == 0 ? null : this.names[0];
    }

    public String getDescription() {
        return this.description;
    }

    protected void setObsolete(boolean obsolete) {
        this.isObsolete = obsolete;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    protected void setNames(String[] names) {
        this.names = new String[names.length];
        System.arraycopy(names, 0, this.names, 0, names.length);
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SchemaObject) {
            return this.oid.equals(((SchemaObject)obj).getOid());
        }
        return false;
    }

    public String toString() {
        return "<" + this.oid + ", " + (this.names == null || this.names.length == 0 ? "null" : this.names[0]) + ">";
    }
}

