/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.Control;
import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.codec.AttributeValueAssertion;
import org.apache.directory.shared.ldap.codec.ControlCodec;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.LdapResultCodec;
import org.apache.directory.shared.ldap.codec.abandon.AbandonRequestCodec;
import org.apache.directory.shared.ldap.codec.add.AddRequestCodec;
import org.apache.directory.shared.ldap.codec.add.AddResponseCodec;
import org.apache.directory.shared.ldap.codec.bind.BindRequestCodec;
import org.apache.directory.shared.ldap.codec.bind.BindResponseCodec;
import org.apache.directory.shared.ldap.codec.bind.LdapAuthentication;
import org.apache.directory.shared.ldap.codec.bind.SaslCredentials;
import org.apache.directory.shared.ldap.codec.bind.SimpleAuthentication;
import org.apache.directory.shared.ldap.codec.compare.CompareRequestCodec;
import org.apache.directory.shared.ldap.codec.compare.CompareResponseCodec;
import org.apache.directory.shared.ldap.codec.controls.CascadeControlCodec;
import org.apache.directory.shared.ldap.codec.controls.replication.syncDoneValue.SyncDoneValueControlCodec;
import org.apache.directory.shared.ldap.codec.controls.replication.syncInfoValue.SyncInfoValueControlCodec;
import org.apache.directory.shared.ldap.codec.controls.replication.syncRequestValue.SyncRequestValueControlCodec;
import org.apache.directory.shared.ldap.codec.controls.replication.syncStateValue.SyncStateValueControlCodec;
import org.apache.directory.shared.ldap.codec.del.DelRequestCodec;
import org.apache.directory.shared.ldap.codec.del.DelResponseCodec;
import org.apache.directory.shared.ldap.codec.extended.ExtendedRequestCodec;
import org.apache.directory.shared.ldap.codec.extended.ExtendedResponseCodec;
import org.apache.directory.shared.ldap.codec.modify.ModifyRequestCodec;
import org.apache.directory.shared.ldap.codec.modify.ModifyResponseCodec;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNRequestCodec;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNResponseCodec;
import org.apache.directory.shared.ldap.codec.search.AndFilter;
import org.apache.directory.shared.ldap.codec.search.AttributeValueAssertionFilter;
import org.apache.directory.shared.ldap.codec.search.ConnectorFilter;
import org.apache.directory.shared.ldap.codec.search.ExtensibleMatchFilter;
import org.apache.directory.shared.ldap.codec.search.Filter;
import org.apache.directory.shared.ldap.codec.search.NotFilter;
import org.apache.directory.shared.ldap.codec.search.OrFilter;
import org.apache.directory.shared.ldap.codec.search.PresentFilter;
import org.apache.directory.shared.ldap.codec.search.SearchRequestCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultDoneCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultEntryCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultReferenceCodec;
import org.apache.directory.shared.ldap.codec.search.SubstringFilter;
import org.apache.directory.shared.ldap.codec.search.controls.pSearch.PSearchControlCodec;
import org.apache.directory.shared.ldap.codec.search.controls.pagedSearch.PagedSearchControlCodec;
import org.apache.directory.shared.ldap.codec.search.controls.subEntry.SubEntryControlCodec;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.ApproximateNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ExtensibleNode;
import org.apache.directory.shared.ldap.filter.GreaterEqNode;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.LessEqNode;
import org.apache.directory.shared.ldap.filter.NotNode;
import org.apache.directory.shared.ldap.filter.OrNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.message.AbandonRequestImpl;
import org.apache.directory.shared.ldap.message.AddRequestImpl;
import org.apache.directory.shared.ldap.message.AddResponseImpl;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.message.BindRequestImpl;
import org.apache.directory.shared.ldap.message.BindResponseImpl;
import org.apache.directory.shared.ldap.message.CompareRequestImpl;
import org.apache.directory.shared.ldap.message.CompareResponseImpl;
import org.apache.directory.shared.ldap.message.DeleteRequestImpl;
import org.apache.directory.shared.ldap.message.DeleteResponseImpl;
import org.apache.directory.shared.ldap.message.ExtendedRequestImpl;
import org.apache.directory.shared.ldap.message.ExtendedResponseImpl;
import org.apache.directory.shared.ldap.message.InternalLdapResult;
import org.apache.directory.shared.ldap.message.InternalMessage;
import org.apache.directory.shared.ldap.message.InternalReferral;
import org.apache.directory.shared.ldap.message.LdapResultImpl;
import org.apache.directory.shared.ldap.message.ModifyDnRequestImpl;
import org.apache.directory.shared.ldap.message.ModifyDnResponseImpl;
import org.apache.directory.shared.ldap.message.ModifyRequestImpl;
import org.apache.directory.shared.ldap.message.ModifyResponseImpl;
import org.apache.directory.shared.ldap.message.ReferralImpl;
import org.apache.directory.shared.ldap.message.SearchRequestImpl;
import org.apache.directory.shared.ldap.message.SearchResponseDoneImpl;
import org.apache.directory.shared.ldap.message.SearchResponseEntryImpl;
import org.apache.directory.shared.ldap.message.SearchResponseReferenceImpl;
import org.apache.directory.shared.ldap.message.UnbindRequestImpl;
import org.apache.directory.shared.ldap.message.control.CascadeControl;
import org.apache.directory.shared.ldap.message.control.InternalAbstractControl;
import org.apache.directory.shared.ldap.message.control.PagedSearchControl;
import org.apache.directory.shared.ldap.message.control.PersistentSearchControl;
import org.apache.directory.shared.ldap.message.control.SubentriesControl;
import org.apache.directory.shared.ldap.message.control.replication.SyncDoneValueControl;
import org.apache.directory.shared.ldap.message.control.replication.SyncInfoValueNewCookieControl;
import org.apache.directory.shared.ldap.message.control.replication.SyncInfoValueRefreshDeleteControl;
import org.apache.directory.shared.ldap.message.control.replication.SyncInfoValueRefreshPresentControl;
import org.apache.directory.shared.ldap.message.control.replication.SyncInfoValueSyncIdSetControl;
import org.apache.directory.shared.ldap.message.control.replication.SyncRequestValueControl;
import org.apache.directory.shared.ldap.message.control.replication.SyncStateValueControl;
import org.apache.directory.shared.ldap.message.extended.GracefulShutdownRequest;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwixTransformer {
    private static Logger LOG = LoggerFactory.getLogger(TwixTransformer.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public static InternalMessage transformAbandonRequest(LdapMessageCodec twixMessage, int messageId) {
        AbandonRequestImpl snickersMessage = new AbandonRequestImpl(messageId);
        AbandonRequestCodec abandonRequest = twixMessage.getAbandonRequest();
        snickersMessage.setAbandoned(abandonRequest.getAbandonedMessageId());
        return snickersMessage;
    }

    public static InternalMessage transformAddRequest(LdapMessageCodec twixMessage, int messageId) {
        AddRequestImpl snickersMessage = new AddRequestImpl(messageId);
        AddRequestCodec addRequest = twixMessage.getAddRequest();
        snickersMessage.setEntry(addRequest.getEntry());
        snickersMessage.setEntry(addRequest.getEntry());
        return snickersMessage;
    }

    public static InternalMessage transformBindRequest(LdapMessageCodec twixMessage, int messageId) {
        BindRequestImpl snickersMessage = new BindRequestImpl(messageId);
        BindRequestCodec bindRequest = twixMessage.getBindRequest();
        snickersMessage.setVersion3(bindRequest.isLdapV3());
        snickersMessage.setName(bindRequest.getName());
        LdapAuthentication authentication = bindRequest.getAuthentication();
        if (authentication instanceof SimpleAuthentication) {
            snickersMessage.setSimple(true);
            snickersMessage.setCredentials(((SimpleAuthentication)authentication).getSimple());
        } else {
            snickersMessage.setSimple(false);
            snickersMessage.setCredentials(((SaslCredentials)authentication).getCredentials());
            snickersMessage.setSaslMechanism(((SaslCredentials)authentication).getMechanism());
        }
        return snickersMessage;
    }

    public static InternalMessage transformBindResponse(LdapMessageCodec twixMessage, int messageId) {
        BindResponseImpl snickersMessage = new BindResponseImpl(messageId);
        BindResponseCodec bindResponse = twixMessage.getBindResponse();
        snickersMessage.setServerSaslCreds(bindResponse.getServerSaslCreds());
        TwixTransformer.transformControlsTwixToSnickers(twixMessage, snickersMessage);
        TwixTransformer.transformLdapResultTwixToSnickers(bindResponse.getLdapResult(), snickersMessage.getLdapResult());
        return snickersMessage;
    }

    public static void transformLdapResultTwixToSnickers(LdapResultCodec twixResult, InternalLdapResult snickersResult) {
        snickersResult.setErrorMessage(twixResult.getErrorMessage());
        try {
            snickersResult.setMatchedDn(new LdapDN(twixResult.getMatchedDN()));
        }
        catch (InvalidNameException e) {
            LOG.error("Could not parse matchedDN while transforming twix value to snickers: {}", (Object)twixResult.getMatchedDN());
            snickersResult.setMatchedDn(new LdapDN());
        }
        snickersResult.setResultCode(twixResult.getResultCode());
        if (twixResult.getReferrals() != null) {
            ReferralImpl referral = new ReferralImpl();
            for (LdapURL url : twixResult.getReferrals()) {
                referral.addLdapUrl(url.toString());
            }
            snickersResult.setReferral(referral);
        }
    }

    public static InternalMessage transformCompareRequest(LdapMessageCodec twixMessage, int messageId) {
        CompareRequestImpl snickersMessage = new CompareRequestImpl(messageId);
        CompareRequestCodec compareRequest = twixMessage.getCompareRequest();
        snickersMessage.setName(compareRequest.getEntry());
        snickersMessage.setAttributeId(compareRequest.getAttributeDesc());
        if (compareRequest.getAssertionValue() instanceof String) {
            snickersMessage.setAssertionValue((String)compareRequest.getAssertionValue());
        } else {
            snickersMessage.setAssertionValue((byte[])compareRequest.getAssertionValue());
        }
        return snickersMessage;
    }

    public static InternalMessage transformDelRequest(LdapMessageCodec twixMessage, int messageId) {
        DeleteRequestImpl snickersMessage = new DeleteRequestImpl(messageId);
        DelRequestCodec delRequest = twixMessage.getDelRequest();
        snickersMessage.setName(delRequest.getEntry());
        return snickersMessage;
    }

    public static InternalMessage transformExtendedRequest(LdapMessageCodec twixMessage, int messageId) {
        ExtendedRequestCodec extendedRequest = twixMessage.getExtendedRequest();
        ExtendedRequestImpl snickersMessage = extendedRequest.getRequestName().equals("1.3.6.1.4.1.18060.0.1.3") ? new GracefulShutdownRequest(messageId) : new ExtendedRequestImpl(messageId);
        snickersMessage.setOid(extendedRequest.getRequestName());
        snickersMessage.setPayload(extendedRequest.getRequestValue());
        return snickersMessage;
    }

    public static InternalMessage transformModifyDNRequest(LdapMessageCodec twixMessage, int messageId) {
        ModifyDnRequestImpl snickersMessage = new ModifyDnRequestImpl(messageId);
        ModifyDNRequestCodec modifyDNRequest = twixMessage.getModifyDNRequest();
        snickersMessage.setName(modifyDNRequest.getEntry());
        snickersMessage.setNewRdn(modifyDNRequest.getNewRDN());
        snickersMessage.setDeleteOldRdn(modifyDNRequest.isDeleteOldRDN());
        snickersMessage.setNewSuperior(modifyDNRequest.getNewSuperior());
        return snickersMessage;
    }

    public static InternalMessage transformModifyRequest(LdapMessageCodec twixMessage, int messageId) {
        ModifyRequestImpl snickersMessage = new ModifyRequestImpl(messageId);
        ModifyRequestCodec modifyRequest = twixMessage.getModifyRequest();
        snickersMessage.setName(modifyRequest.getObject());
        if (modifyRequest.getModifications() != null) {
            for (Modification modification : modifyRequest.getModifications()) {
                snickersMessage.addModification(modification);
            }
        }
        return snickersMessage;
    }

    public static ExprNode transformFilter(Filter twixFilter) {
        if (twixFilter != null) {
            if (twixFilter instanceof ConnectorFilter) {
                BranchNode branch = null;
                if (twixFilter instanceof AndFilter) {
                    branch = new AndNode();
                } else if (twixFilter instanceof OrFilter) {
                    branch = new OrNode();
                } else if (twixFilter instanceof NotFilter) {
                    branch = new NotNode();
                }
                List<Filter> filtersSet = ((ConnectorFilter)twixFilter).getFilterSet();
                if (filtersSet != null) {
                    for (Filter filter : filtersSet) {
                        branch.addNode(TwixTransformer.transformFilter(filter));
                    }
                }
                return branch;
            }
            LeafNode branch = null;
            if (twixFilter instanceof PresentFilter) {
                branch = new PresenceNode(((PresentFilter)twixFilter).getAttributeDescription());
            } else if (twixFilter instanceof AttributeValueAssertionFilter) {
                AttributeValueAssertion ava = ((AttributeValueAssertionFilter)twixFilter).getAssertion();
                switch (((AttributeValueAssertionFilter)twixFilter).getFilterType()) {
                    case 0: {
                        branch = new EqualityNode(ava.getAttributeDesc(), ava.getAssertionValue());
                        break;
                    }
                    case 1: {
                        branch = new GreaterEqNode(ava.getAttributeDesc(), ava.getAssertionValue());
                        break;
                    }
                    case 2: {
                        branch = new LessEqNode(ava.getAttributeDesc(), ava.getAssertionValue());
                        break;
                    }
                    case 3: {
                        branch = new ApproximateNode(ava.getAttributeDesc(), ava.getAssertionValue());
                    }
                }
            } else if (twixFilter instanceof SubstringFilter) {
                SubstringFilter filter = (SubstringFilter)twixFilter;
                String initialString = null;
                String finalString = null;
                ArrayList<String> anyString = null;
                if (filter.getInitialSubstrings() != null) {
                    initialString = filter.getInitialSubstrings();
                }
                if (filter.getFinalSubstrings() != null) {
                    finalString = filter.getFinalSubstrings();
                }
                if (filter.getAnySubstrings() != null) {
                    anyString = new ArrayList<String>();
                    for (String any : filter.getAnySubstrings()) {
                        anyString.add(any);
                    }
                }
                branch = new SubstringNode(anyString, filter.getType(), initialString, finalString);
            } else if (twixFilter instanceof ExtensibleMatchFilter) {
                ExtensibleMatchFilter filter = (ExtensibleMatchFilter)twixFilter;
                String attribute = null;
                String matchingRule = null;
                if (filter.getType() != null) {
                    attribute = filter.getType();
                }
                Value<?> value = filter.getMatchValue();
                if (filter.getMatchingRule() != null) {
                    matchingRule = filter.getMatchingRule();
                }
                branch = new ExtensibleNode(attribute, value, matchingRule, filter.isDnAttributes());
            }
            return branch;
        }
        return null;
    }

    public static Filter transformFilter(ExprNode exprNode) {
        if (exprNode != null) {
            Filter filter = null;
            if (exprNode instanceof BranchNode) {
                if (exprNode instanceof AndNode) {
                    filter = new AndFilter();
                } else if (exprNode instanceof OrNode) {
                    filter = new OrFilter();
                } else if (exprNode instanceof NotNode) {
                    filter = new NotFilter();
                }
                List<ExprNode> children = ((BranchNode)exprNode).getChildren();
                if (children != null) {
                    for (ExprNode child : children) {
                        try {
                            ((ConnectorFilter)filter).addFilter(TwixTransformer.transformFilter(child));
                        }
                        catch (DecoderException de) {
                            LOG.error("Error while transforming a ExprNode : " + de.getMessage());
                            return null;
                        }
                    }
                }
            } else if (exprNode instanceof PresenceNode) {
                filter = new PresentFilter();
                ((PresentFilter)filter).setAttributeDescription(((PresenceNode)exprNode).getAttribute());
            } else if (exprNode instanceof SimpleNode) {
                if (exprNode instanceof EqualityNode) {
                    filter = new AttributeValueAssertionFilter(0);
                    AttributeValueAssertion assertion = new AttributeValueAssertion();
                    assertion.setAttributeDesc(((EqualityNode)exprNode).getAssertionType().name());
                    assertion.setAssertionValue(((EqualityNode)exprNode).getValue());
                    ((AttributeValueAssertionFilter)filter).setAssertion(assertion);
                } else if (exprNode instanceof GreaterEqNode) {
                    filter = new AttributeValueAssertionFilter(1);
                    AttributeValueAssertion assertion = new AttributeValueAssertion();
                    assertion.setAttributeDesc(((EqualityNode)exprNode).getAssertionType().name());
                    assertion.setAssertionValue(((EqualityNode)exprNode).getValue());
                    ((AttributeValueAssertionFilter)filter).setAssertion(assertion);
                } else if (exprNode instanceof LessEqNode) {
                    filter = new AttributeValueAssertionFilter(2);
                    AttributeValueAssertion assertion = new AttributeValueAssertion();
                    assertion.setAttributeDesc(((EqualityNode)exprNode).getAssertionType().name());
                    assertion.setAssertionValue(((EqualityNode)exprNode).getValue());
                    ((AttributeValueAssertionFilter)filter).setAssertion(assertion);
                } else if (exprNode instanceof ApproximateNode) {
                    filter = new AttributeValueAssertionFilter(3);
                    AttributeValueAssertion assertion = new AttributeValueAssertion();
                    assertion.setAttributeDesc(((EqualityNode)exprNode).getAssertionType().name());
                    assertion.setAssertionValue(((EqualityNode)exprNode).getValue());
                    ((AttributeValueAssertionFilter)filter).setAssertion(assertion);
                }
            } else if (exprNode instanceof SubstringNode) {
                filter = new SubstringFilter();
                String initialString = ((SubstringNode)exprNode).getInitial();
                String finalString = ((SubstringNode)exprNode).getFinal();
                List<String> anyStrings = ((SubstringNode)exprNode).getAny();
                if (initialString != null) {
                    ((SubstringFilter)filter).setInitialSubstrings(initialString);
                }
                if (finalString != null) {
                    ((SubstringFilter)filter).setFinalSubstrings(finalString);
                }
                if (anyStrings != null) {
                    for (String any : anyStrings) {
                        ((SubstringFilter)filter).addAnySubstrings(any);
                    }
                }
            } else if (exprNode instanceof ExtensibleNode) {
                filter = new ExtensibleMatchFilter();
                String attribute = ((ExtensibleNode)exprNode).getAttribute();
                String matchingRule = ((ExtensibleNode)exprNode).getMatchingRuleId();
                boolean dnAttributes = ((ExtensibleNode)exprNode).hasDnAttributes();
                Value<?> value = ((ExtensibleNode)exprNode).getValue();
                if (attribute != null) {
                    ((ExtensibleMatchFilter)filter).setType(attribute);
                }
                if (matchingRule != null) {
                    ((ExtensibleMatchFilter)filter).setMatchingRule(matchingRule);
                }
                ((ExtensibleMatchFilter)filter).setMatchValue(value);
                ((ExtensibleMatchFilter)filter).setDnAttributes(dnAttributes);
            }
            return filter;
        }
        return null;
    }

    public static InternalMessage transformSearchRequest(LdapMessageCodec twixMessage, int messageId) {
        List<EntryAttribute> attributes;
        SearchRequestImpl snickersMessage = new SearchRequestImpl(messageId);
        SearchRequestCodec searchRequest = twixMessage.getSearchRequest();
        snickersMessage.setBase(searchRequest.getBaseObject());
        snickersMessage.setScope(searchRequest.getScope());
        switch (searchRequest.getDerefAliases()) {
            case 3: {
                snickersMessage.setDerefAliases(AliasDerefMode.DEREF_ALWAYS);
                break;
            }
            case 2: {
                snickersMessage.setDerefAliases(AliasDerefMode.DEREF_FINDING_BASE_OBJ);
                break;
            }
            case 1: {
                snickersMessage.setDerefAliases(AliasDerefMode.DEREF_IN_SEARCHING);
                break;
            }
            case 0: {
                snickersMessage.setDerefAliases(AliasDerefMode.NEVER_DEREF_ALIASES);
            }
        }
        snickersMessage.setSizeLimit(searchRequest.getSizeLimit());
        snickersMessage.setTimeLimit(searchRequest.getTimeLimit());
        snickersMessage.setTypesOnly(searchRequest.isTypesOnly());
        Filter twixFilter = searchRequest.getFilter();
        snickersMessage.setFilter(TwixTransformer.transformFilter(twixFilter));
        if (searchRequest.getAttributes() != null && (attributes = searchRequest.getAttributes()) != null && attributes.size() != 0) {
            for (EntryAttribute attribute : attributes) {
                if (attribute == null) continue;
                snickersMessage.addAttribute(attribute.getId());
            }
        }
        return snickersMessage;
    }

    public static InternalMessage transformUnBindRequest(LdapMessageCodec twixMessage, int messageId) {
        return new UnbindRequestImpl(messageId);
    }

    public static InternalMessage transform(Object obj) {
        LdapMessageCodec twixMessage = (LdapMessageCodec)((Object)obj);
        int messageId = twixMessage.getMessageId();
        if (IS_DEBUG) {
            LOG.debug("Transforming LdapMessage <" + messageId + ", " + twixMessage.getMessageTypeName() + "> from Twix to Snickers.");
        }
        InternalMessage snickersMessage = null;
        int messageType = twixMessage.getMessageType();
        switch (messageType) {
            case 3: {
                snickersMessage = TwixTransformer.transformBindRequest(twixMessage, messageId);
                break;
            }
            case 19: {
                snickersMessage = TwixTransformer.transformUnBindRequest(twixMessage, messageId);
                break;
            }
            case 15: {
                snickersMessage = TwixTransformer.transformSearchRequest(twixMessage, messageId);
                break;
            }
            case 13: {
                snickersMessage = TwixTransformer.transformModifyRequest(twixMessage, messageId);
                break;
            }
            case 1: {
                snickersMessage = TwixTransformer.transformAddRequest(twixMessage, messageId);
                break;
            }
            case 7: {
                snickersMessage = TwixTransformer.transformDelRequest(twixMessage, messageId);
                break;
            }
            case 11: {
                snickersMessage = TwixTransformer.transformModifyDNRequest(twixMessage, messageId);
                break;
            }
            case 5: {
                snickersMessage = TwixTransformer.transformCompareRequest(twixMessage, messageId);
                break;
            }
            case 0: {
                snickersMessage = TwixTransformer.transformAbandonRequest(twixMessage, messageId);
                break;
            }
            case 9: {
                snickersMessage = TwixTransformer.transformExtendedRequest(twixMessage, messageId);
                break;
            }
            case 4: {
                snickersMessage = TwixTransformer.transformBindResponse(twixMessage, messageId);
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                break;
            }
            default: {
                throw new IllegalStateException("shouldn't happen - if it does then we have issues");
            }
        }
        List<ControlCodec> twixControls = twixMessage.getControls();
        if (twixControls != null) {
            for (final ControlCodec twixControl : twixControls) {
                InternalAbstractControl neutralControl = null;
                if (twixControl.getControlValue() instanceof CascadeControlCodec) {
                    neutralControl = new CascadeControl();
                    neutralControl.setCritical(twixControl.getCriticality());
                } else if (twixControl.getControlValue() instanceof PSearchControlCodec) {
                    PersistentSearchControl neutralPsearch = new PersistentSearchControl();
                    neutralControl = neutralPsearch;
                    PSearchControlCodec twixPsearch = (PSearchControlCodec)((Object)twixControl.getControlValue());
                    neutralPsearch.setChangeTypes(twixPsearch.getChangeTypes());
                    neutralPsearch.setChangesOnly(twixPsearch.isChangesOnly());
                    neutralPsearch.setReturnECs(twixPsearch.isReturnECs());
                    neutralPsearch.setCritical(twixControl.getCriticality());
                } else if (twixControl.getControlValue() instanceof SubEntryControlCodec) {
                    SubentriesControl neutralSubentriesControl = new SubentriesControl();
                    SubEntryControlCodec twixSubentriesControl = (SubEntryControlCodec)((Object)twixControl.getControlValue());
                    neutralControl = neutralSubentriesControl;
                    neutralSubentriesControl.setVisibility(twixSubentriesControl.isVisible());
                    neutralSubentriesControl.setCritical(twixControl.getCriticality());
                } else if (twixControl.getControlValue() instanceof PagedSearchControlCodec) {
                    PagedSearchControl neutralPagedSearchControl = new PagedSearchControl();
                    neutralControl = neutralPagedSearchControl;
                    PagedSearchControlCodec twixPagedSearchControl = (PagedSearchControlCodec)((Object)twixControl.getControlValue());
                    neutralPagedSearchControl.setCookie(twixPagedSearchControl.getCookie());
                    neutralPagedSearchControl.setSize(twixPagedSearchControl.getSize());
                    neutralPagedSearchControl.setCritical(twixControl.getCriticality());
                } else if (twixControl.getControlValue() instanceof SyncDoneValueControlCodec) {
                    SyncDoneValueControl neutralSyncDoneValueControl = new SyncDoneValueControl();
                    SyncDoneValueControlCodec twixSyncDoneValueControl = (SyncDoneValueControlCodec)((Object)twixControl.getControlValue());
                    neutralControl = neutralSyncDoneValueControl;
                    neutralSyncDoneValueControl.setCritical(twixControl.getCriticality());
                    neutralSyncDoneValueControl.setCookie(twixSyncDoneValueControl.getCookie());
                    neutralSyncDoneValueControl.setRefreshDeletes(twixSyncDoneValueControl.isRefreshDeletes());
                } else if (twixControl.getControlValue() instanceof SyncInfoValueControlCodec) {
                    SyncInfoValueControlCodec twixSyncInfoValueControlCodec = (SyncInfoValueControlCodec)((Object)twixControl.getControlValue());
                    switch (twixSyncInfoValueControlCodec.getType()) {
                        case NEW_COOKIE: {
                            SyncInfoValueNewCookieControl neutralSyncInfoValueNewCookieControl = new SyncInfoValueNewCookieControl();
                            neutralControl = neutralSyncInfoValueNewCookieControl;
                            neutralSyncInfoValueNewCookieControl.setCritical(twixControl.getCriticality());
                            neutralSyncInfoValueNewCookieControl.setCookie(twixSyncInfoValueControlCodec.getCookie());
                            break;
                        }
                        case REFRESH_DELETE: {
                            SyncInfoValueRefreshDeleteControl neutralSyncInfoValueRefreshDeleteControl = new SyncInfoValueRefreshDeleteControl();
                            neutralControl = neutralSyncInfoValueRefreshDeleteControl;
                            neutralSyncInfoValueRefreshDeleteControl.setCritical(twixControl.getCriticality());
                            neutralSyncInfoValueRefreshDeleteControl.setCookie(twixSyncInfoValueControlCodec.getCookie());
                            neutralSyncInfoValueRefreshDeleteControl.setRefreshDone(twixSyncInfoValueControlCodec.isRefreshDone());
                            break;
                        }
                        case REFRESH_PRESENT: {
                            SyncInfoValueRefreshPresentControl neutralSyncInfoValueRefreshPresentControl = new SyncInfoValueRefreshPresentControl();
                            neutralControl = neutralSyncInfoValueRefreshPresentControl;
                            neutralSyncInfoValueRefreshPresentControl.setCritical(twixControl.getCriticality());
                            neutralSyncInfoValueRefreshPresentControl.setCookie(twixSyncInfoValueControlCodec.getCookie());
                            neutralSyncInfoValueRefreshPresentControl.setRefreshDone(twixSyncInfoValueControlCodec.isRefreshDone());
                            break;
                        }
                        case SYNC_ID_SET: {
                            SyncInfoValueSyncIdSetControl neutralSyncInfoValueSyncIdSetControl = new SyncInfoValueSyncIdSetControl();
                            neutralControl = neutralSyncInfoValueSyncIdSetControl;
                            neutralSyncInfoValueSyncIdSetControl.setCritical(twixControl.getCriticality());
                            neutralSyncInfoValueSyncIdSetControl.setCookie(twixSyncInfoValueControlCodec.getCookie());
                            neutralSyncInfoValueSyncIdSetControl.setRefreshDeletes(twixSyncInfoValueControlCodec.isRefreshDeletes());
                            List<byte[]> uuids = twixSyncInfoValueControlCodec.getSyncUUIDs();
                            if (uuids == null) break;
                            for (byte[] uuid : uuids) {
                                neutralSyncInfoValueSyncIdSetControl.addSyncUUID(uuid);
                            }
                            break;
                        }
                    }
                } else if (twixControl.getControlValue() instanceof SyncRequestValueControlCodec) {
                    SyncRequestValueControl neutralSyncRequestValueControl = new SyncRequestValueControl();
                    SyncRequestValueControlCodec twixSyncDoneValueControlCodec = (SyncRequestValueControlCodec)((Object)twixControl.getControlValue());
                    neutralControl = neutralSyncRequestValueControl;
                    neutralSyncRequestValueControl.setCritical(twixControl.getCriticality());
                    neutralSyncRequestValueControl.setMode(twixSyncDoneValueControlCodec.getMode());
                    neutralSyncRequestValueControl.setCookie(twixSyncDoneValueControlCodec.getCookie());
                    neutralSyncRequestValueControl.setReloadHint(twixSyncDoneValueControlCodec.isReloadHint());
                } else if (twixControl.getControlValue() instanceof SyncStateValueControl) {
                    SyncStateValueControl neutralSyncStateValueControl = new SyncStateValueControl();
                    SyncStateValueControlCodec twixSyncStateValueControlCodec = (SyncStateValueControlCodec)((Object)twixControl.getControlValue());
                    neutralControl = neutralSyncStateValueControl;
                    neutralSyncStateValueControl.setCritical(twixControl.getCriticality());
                    neutralSyncStateValueControl.setSyncStateType(twixSyncStateValueControlCodec.getSyncStateType());
                    neutralSyncStateValueControl.setEntryUUID(twixSyncStateValueControlCodec.getEntryUUID());
                    neutralSyncStateValueControl.setCookie(twixSyncStateValueControlCodec.getCookie());
                } else if (twixControl.getControlValue() instanceof byte[]) {
                    neutralControl = new InternalAbstractControl(){

                        public byte[] getEncodedValue() {
                            return (byte[])twixControl.getControlValue();
                        }
                    };
                    neutralControl.setCritical(twixControl.getCriticality());
                    neutralControl.setID(twixControl.getControlType());
                } else if (twixControl.getControlValue() == null) {
                    neutralControl = new InternalAbstractControl(){

                        public byte[] getEncodedValue() {
                            return (byte[])twixControl.getControlValue();
                        }
                    };
                    neutralControl.setCritical(twixControl.getCriticality());
                    neutralControl.setID(twixControl.getControlType());
                }
                snickersMessage.add(neutralControl);
            }
        }
        return snickersMessage;
    }

    public static LdapResultCodec transformLdapResult(LdapResultImpl snickersLdapResult) {
        LdapResultCodec twixLdapResult = new LdapResultCodec();
        twixLdapResult.setResultCode(snickersLdapResult.getResultCode());
        String errorMessage = snickersLdapResult.getErrorMessage();
        twixLdapResult.setErrorMessage(StringTools.isEmpty(errorMessage) ? "" : errorMessage);
        twixLdapResult.setMatchedDN(snickersLdapResult.getMatchedDn());
        ReferralImpl snickersReferrals = (ReferralImpl)snickersLdapResult.getReferral();
        if (snickersReferrals != null) {
            twixLdapResult.initReferrals();
            for (String referral : snickersReferrals.getLdapUrls()) {
                try {
                    LdapURL ldapUrl = new LdapURL(referral.getBytes());
                    twixLdapResult.addReferral(ldapUrl);
                }
                catch (LdapURLEncodingException lude) {
                    LOG.warn("The referral " + referral + " is invalid : " + lude.getMessage());
                    twixLdapResult.addReferral(LdapURL.EMPTY_URL);
                }
            }
        }
        return twixLdapResult;
    }

    public static void transformAddResponse(LdapMessageCodec twixMessage, InternalMessage snickersMessage) {
        AddResponseImpl snickersAddResponse = (AddResponseImpl)snickersMessage;
        AddResponseCodec addResponse = new AddResponseCodec();
        addResponse.setLdapResult(TwixTransformer.transformLdapResult((LdapResultImpl)snickersAddResponse.getLdapResult()));
        twixMessage.setProtocolOP((Asn1Object)addResponse);
    }

    public static void transformBindResponse(LdapMessageCodec twixMessage, InternalMessage snickersMessage) {
        BindResponseImpl snickersBindResponse = (BindResponseImpl)snickersMessage;
        BindResponseCodec bindResponse = new BindResponseCodec();
        byte[] serverSaslCreds = snickersBindResponse.getServerSaslCreds();
        if (serverSaslCreds != null) {
            bindResponse.setServerSaslCreds(serverSaslCreds);
        }
        bindResponse.setLdapResult(TwixTransformer.transformLdapResult((LdapResultImpl)snickersBindResponse.getLdapResult()));
        twixMessage.setProtocolOP((Asn1Object)bindResponse);
    }

    public static void transformBindRequest(LdapMessageCodec twixMessage, InternalMessage snickersMessage) {
        BindRequestImpl snickersBindRequest = (BindRequestImpl)snickersMessage;
        BindRequestCodec bindRequest = new BindRequestCodec();
        if (snickersBindRequest.isSimple()) {
            SimpleAuthentication simple = new SimpleAuthentication();
            simple.setSimple(snickersBindRequest.getCredentials());
            bindRequest.setAuthentication(simple);
        } else {
            SaslCredentials sasl = new SaslCredentials();
            sasl.setCredentials(snickersBindRequest.getCredentials());
            sasl.setMechanism(snickersBindRequest.getSaslMechanism());
            bindRequest.setAuthentication(sasl);
        }
        bindRequest.setMessageId(snickersBindRequest.getMessageId());
        bindRequest.setName(snickersBindRequest.getName());
        bindRequest.setVersion(snickersBindRequest.isVersion3() ? 3 : 2);
        twixMessage.setProtocolOP((Asn1Object)bindRequest);
    }

    public static void transformCompareResponse(LdapMessageCodec twixMessage, InternalMessage snickersMessage) {
        CompareResponseImpl snickersCompareResponse = (CompareResponseImpl)snickersMessage;
        CompareResponseCodec compareResponse = new CompareResponseCodec();
        compareResponse.setLdapResult(TwixTransformer.transformLdapResult((LdapResultImpl)snickersCompareResponse.getLdapResult()));
        twixMessage.setProtocolOP((Asn1Object)compareResponse);
    }

    public static void transformDelResponse(LdapMessageCodec twixMessage, InternalMessage snickersMessage) {
        DeleteResponseImpl snickersDelResponse = (DeleteResponseImpl)snickersMessage;
        DelResponseCodec delResponse = new DelResponseCodec();
        delResponse.setLdapResult(TwixTransformer.transformLdapResult((LdapResultImpl)snickersDelResponse.getLdapResult()));
        twixMessage.setProtocolOP((Asn1Object)delResponse);
    }

    public static void transformExtendedResponse(LdapMessageCodec twixMessage, InternalMessage snickersMessage) {
        ExtendedResponseImpl snickersExtendedResponse = (ExtendedResponseImpl)snickersMessage;
        ExtendedResponseCodec extendedResponse = new ExtendedResponseCodec();
        try {
            extendedResponse.setResponseName(new OID(snickersExtendedResponse.getResponseName()));
        }
        catch (DecoderException de) {
            LOG.warn("The OID " + snickersExtendedResponse.getResponseName() + " is invalid : " + de.getMessage());
            extendedResponse.setResponseName(null);
        }
        extendedResponse.setResponse(snickersExtendedResponse.getResponse());
        extendedResponse.setLdapResult(TwixTransformer.transformLdapResult((LdapResultImpl)snickersExtendedResponse.getLdapResult()));
        twixMessage.setProtocolOP((Asn1Object)extendedResponse);
    }

    public static void transformModifyResponse(LdapMessageCodec twixMessage, InternalMessage snickersMessage) {
        ModifyResponseImpl snickersModifyResponse = (ModifyResponseImpl)snickersMessage;
        ModifyResponseCodec modifyResponse = new ModifyResponseCodec();
        modifyResponse.setLdapResult(TwixTransformer.transformLdapResult((LdapResultImpl)snickersModifyResponse.getLdapResult()));
        twixMessage.setProtocolOP((Asn1Object)modifyResponse);
    }

    public static void transformModifyDNResponse(LdapMessageCodec twixMessage, InternalMessage snickersMessage) {
        ModifyDnResponseImpl snickersModifyDNResponse = (ModifyDnResponseImpl)snickersMessage;
        ModifyDNResponseCodec modifyDNResponse = new ModifyDNResponseCodec();
        modifyDNResponse.setLdapResult(TwixTransformer.transformLdapResult((LdapResultImpl)snickersModifyDNResponse.getLdapResult()));
        twixMessage.setProtocolOP((Asn1Object)modifyDNResponse);
    }

    public static void transformSearchResultDone(LdapMessageCodec twixMessage, InternalMessage snickersMessage) {
        SearchResponseDoneImpl snickersSearchResponseDone = (SearchResponseDoneImpl)snickersMessage;
        SearchResultDoneCodec searchResultDone = new SearchResultDoneCodec();
        searchResultDone.setLdapResult(TwixTransformer.transformLdapResult((LdapResultImpl)snickersSearchResponseDone.getLdapResult()));
        twixMessage.setProtocolOP((Asn1Object)searchResultDone);
    }

    public static void transformSearchResultEntry(LdapMessageCodec twixMessage, InternalMessage snickersMessage) {
        SearchResponseEntryImpl snickersSearchResultResponse = (SearchResponseEntryImpl)snickersMessage;
        SearchResultEntryCodec searchResultEntry = new SearchResultEntryCodec();
        searchResultEntry.setObjectName(snickersSearchResultResponse.getObjectName());
        searchResultEntry.setEntry(snickersSearchResultResponse.getEntry());
        twixMessage.setProtocolOP((Asn1Object)searchResultEntry);
    }

    public static void transformSearchResultReference(LdapMessageCodec twixMessage, InternalMessage snickersMessage) {
        Collection<String> urls;
        SearchResponseReferenceImpl snickersSearchResponseReference = (SearchResponseReferenceImpl)snickersMessage;
        SearchResultReferenceCodec searchResultReference = new SearchResultReferenceCodec();
        InternalReferral referrals = snickersSearchResponseReference.getReferral();
        if (referrals != null && (urls = referrals.getLdapUrls()) != null) {
            for (String url : urls) {
                try {
                    searchResultReference.addSearchResultReference(new LdapURL(url));
                }
                catch (LdapURLEncodingException luee) {
                    LOG.warn("The LdapURL " + url + " is incorrect : " + luee.getMessage());
                }
            }
        }
        twixMessage.setProtocolOP((Asn1Object)searchResultReference);
    }

    public static Object transform(InternalMessage msg) {
        if (IS_DEBUG) {
            LOG.debug("Transforming message type " + (Object)((Object)msg.getType()));
        }
        LdapMessageCodec twixMessage = new LdapMessageCodec();
        twixMessage.setMessageId(msg.getMessageId());
        switch (msg.getType()) {
            case SEARCH_RES_ENTRY: {
                TwixTransformer.transformSearchResultEntry(twixMessage, msg);
                break;
            }
            case SEARCH_RES_DONE: {
                TwixTransformer.transformSearchResultDone(twixMessage, msg);
                break;
            }
            case SEARCH_RES_REF: {
                TwixTransformer.transformSearchResultReference(twixMessage, msg);
                break;
            }
            case BIND_RESPONSE: {
                TwixTransformer.transformBindResponse(twixMessage, msg);
                break;
            }
            case BIND_REQUEST: {
                TwixTransformer.transformBindRequest(twixMessage, msg);
                break;
            }
            case ADD_RESPONSE: {
                TwixTransformer.transformAddResponse(twixMessage, msg);
                break;
            }
            case COMPARE_RESPONSE: {
                TwixTransformer.transformCompareResponse(twixMessage, msg);
                break;
            }
            case DEL_RESPONSE: {
                TwixTransformer.transformDelResponse(twixMessage, msg);
                break;
            }
            case MODIFY_RESPONSE: {
                TwixTransformer.transformModifyResponse(twixMessage, msg);
                break;
            }
            case MOD_DN_RESPONSE: {
                TwixTransformer.transformModifyDNResponse(twixMessage, msg);
                break;
            }
            case EXTENDED_RESP: {
                TwixTransformer.transformExtendedResponse(twixMessage, msg);
            }
        }
        if (!msg.getControls().isEmpty()) {
            TwixTransformer.transformControls(twixMessage, msg);
        }
        if (IS_DEBUG) {
            LOG.debug("Transformed message : " + (Object)((Object)twixMessage));
        }
        return twixMessage;
    }

    public static void transformControlsTwixToSnickers(LdapMessageCodec twixMessage, InternalMessage msg) {
        if (twixMessage.getControls() == null) {
            return;
        }
        for (ControlCodec control : twixMessage.getControls()) {
            LOG.debug("Not decoding response control: {}", (Object)control);
        }
    }

    public static void transformControls(LdapMessageCodec twixMessage, InternalMessage msg) {
        for (Control control : msg.getControls().values()) {
            ControlCodec twixControl = new ControlCodec();
            twixMessage.addControl(twixControl);
            twixControl.setCriticality(control.isCritical());
            byte[] encodedValue = control.getEncodedValue();
            twixControl.setControlValue(encodedValue);
            twixControl.setEncodedValue(encodedValue);
            twixControl.setControlType(control.getID());
            twixControl.setParent(twixMessage);
        }
    }
}

